/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;

class SelectedSparseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseDoubleMatrix1D(AbstractLongDoubleMap elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedSparseDoubleMatrix1D(int size, AbstractLongDoubleMap elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public double getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    public DoubleMatrix1D like(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseDoubleMatrix2D M = new SparseDoubleMatrix2D(rows, columns);
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                ((DoubleMatrix2D)M).setQuick(r, c, this.getQuick(idx++));
            }
        }
        return M;
    }

    public DoubleMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseDoubleMatrix3D M = new SparseDoubleMatrix3D(slices, rows, columns);
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    ((DoubleMatrix3D)M).setQuick(s, r, c, this.getQuick(idx++));
                }
            }
        }
        return M;
    }

    public void setQuick(int index, double value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value == 0.0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D otherMatrix = (SelectedSparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D otherMatrix = (SparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDoubleMatrix1D(this.elements, offsets);
    }
}

