/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleQMR
extends AbstractDoubleIterativeSolver {
    private DoublePreconditioner M1;
    private DoublePreconditioner M2;
    private DoubleMatrix1D r;
    private DoubleMatrix1D y;
    private DoubleMatrix1D z;
    private DoubleMatrix1D v;
    private DoubleMatrix1D w;
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D d;
    private DoubleMatrix1D s;
    private DoubleMatrix1D v_tld;
    private DoubleMatrix1D w_tld;
    private DoubleMatrix1D y_tld;
    private DoubleMatrix1D z_tld;
    private DoubleMatrix1D p_tld;

    public DoubleQMR(DoubleMatrix1D template) {
        this.M1 = this.M;
        this.M2 = this.M;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    public DoubleQMR(DoubleMatrix1D template, DoublePreconditioner M1, DoublePreconditioner M2) {
        this.M1 = M1;
        this.M2 = M2;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double rho = 0.0;
        double rho_1 = 0.0;
        double xi = 0.0;
        double gamma = 1.0;
        double gamma_1 = 0.0;
        double theta = 0.0;
        double theta_1 = 0.0;
        double eta = -1.0;
        double delta = 0.0;
        double ep = 0.0;
        double beta = 0.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.v_tld.assign(this.r);
        this.M1.apply(this.v_tld, this.y);
        rho = DenseDoubleAlgebra.DEFAULT.norm(this.y, Norm.Two);
        this.w_tld.assign(this.r);
        this.M2.transApply(this.w_tld, this.z);
        xi = DenseDoubleAlgebra.DEFAULT.norm(this.z, Norm.Two);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            if (rho == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (xi == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "xi", this.iter);
            }
            this.v.assign(this.v_tld, DoubleFunctions.multSecond(1.0 / rho));
            this.y.assign(DoubleFunctions.mult(1.0 / rho));
            this.w.assign(this.w_tld, DoubleFunctions.multSecond(1.0 / xi));
            this.z.assign(DoubleFunctions.mult(1.0 / xi));
            delta = this.z.zDotProduct(this.y);
            if (delta == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "delta", this.iter);
            }
            this.M2.apply(this.y, this.y_tld);
            this.M1.transApply(this.z, this.z_tld);
            if (this.iter.isFirst()) {
                this.p.assign(this.y_tld);
                this.q.assign(this.z_tld);
            } else {
                this.p.assign(this.y_tld, DoubleFunctions.plusMultFirst(-xi * delta / ep));
                this.q.assign(this.z_tld, DoubleFunctions.plusMultFirst(-rho * delta / ep));
            }
            A.zMult(this.p, this.p_tld);
            ep = this.q.zDotProduct(this.p_tld);
            if (ep == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "ep", this.iter);
            }
            beta = ep / delta;
            if (beta == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "beta", this.iter);
            }
            this.v_tld.assign(this.v, DoubleFunctions.multSecond(-beta)).assign(this.p_tld, DoubleFunctions.plus);
            this.M1.apply(this.v_tld, this.y);
            rho_1 = rho;
            rho = DenseDoubleAlgebra.DEFAULT.norm(this.y, Norm.Two);
            A.zMult(this.q, this.w_tld.assign(this.w, DoubleFunctions.multSecond(-beta)), 1.0, 1.0, true);
            this.M2.transApply(this.w_tld, this.z);
            xi = DenseDoubleAlgebra.DEFAULT.norm(this.z, Norm.Two);
            gamma_1 = gamma;
            theta_1 = theta;
            theta = rho / (gamma_1 * beta);
            gamma = 1.0 / Math.sqrt(1.0 + theta * theta);
            if (gamma == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "gamma", this.iter);
            }
            eta = -eta * rho_1 * gamma * gamma / (beta * gamma_1 * gamma_1);
            if (this.iter.isFirst()) {
                this.d.assign(this.p, DoubleFunctions.multSecond(eta));
                this.s.assign(this.p_tld, DoubleFunctions.multSecond(eta));
            } else {
                double val = theta_1 * theta_1 * gamma * gamma;
                this.d.assign(DoubleFunctions.mult(val)).assign(this.p, DoubleFunctions.plusMultSecond(eta));
                this.s.assign(DoubleFunctions.mult(val)).assign(this.p_tld, DoubleFunctions.plusMultSecond(eta));
            }
            x.assign(this.d, DoubleFunctions.plus);
            this.r.assign(this.s, DoubleFunctions.minus);
            this.iter.next();
        }
        return x;
    }

    public void setPreconditioner(DoublePreconditioner M) {
        super.setPreconditioner(M);
        this.M1 = M;
        this.M2 = M;
    }
}

