/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleBiCG
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D z;
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D r;
    private DoubleMatrix1D ztilde;
    private DoubleMatrix1D ptilde;
    private DoubleMatrix1D qtilde;
    private DoubleMatrix1D rtilde;

    public DoubleBiCG(DoubleMatrix1D template) {
        this.z = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.r = template.copy();
        this.ztilde = template.copy();
        this.ptilde = template.copy();
        this.qtilde = template.copy();
        this.rtilde = template.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double rho_1 = 1.0;
        double rho_2 = 1.0;
        double alpha = 1.0;
        double beta = 1.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            this.M.transApply(this.rtilde, this.ztilde);
            rho_1 = this.z.zDotProduct(this.rtilde);
            if (rho_1 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                this.ptilde.assign(this.ztilde);
            } else {
                beta = rho_1 / rho_2;
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(beta));
                this.ptilde.assign(this.ztilde, DoubleFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            A.zMult(this.ptilde, this.qtilde, 1.0, 0.0, true);
            alpha = rho_1 / this.ptilde.zDotProduct(this.q);
            x.assign(this.p, DoubleFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-alpha));
            this.rtilde.assign(this.qtilde, DoubleFunctions.plusMultSecond(-alpha));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

