/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultFirst;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_transpose;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected double[] values;

    public SparseCCDComplexMatrix2D(double[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCDComplexMatrix2D(DZcs_common.DZcs dzcs) {
        this(dzcs.m, dzcs.n);
        this.rowIndexes = dzcs.i;
        this.columnPointers = dzcs.p;
        this.values = dzcs.x;
    }

    public SparseCCDComplexMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCDComplexMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.rowIndexes = new int[nzmax];
        this.values = new double[2 * nzmax];
        this.columnPointers = new int[columns + 1];
    }

    public SparseCCDComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnPointers, double[] values) {
        block4: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block4;
                throw exc;
            }
        }
        if (columnPointers.length != columns + 1) {
            throw new IllegalArgumentException("columnPointers.length != columns + 1");
        }
        if (2 * rowIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        this.columnPointers = columnPointers;
        this.rowIndexes = rowIndexes;
        this.values = values;
    }

    public SparseCCDComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double re, double im, boolean removeDuplicates) {
        int k;
        block7: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (re == 0.0 && im == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new double[2 * nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[2 * r] = re;
            this.values[2 * r + 1] = im;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public SparseCCDComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double[] values, boolean removeDuplicates, boolean removeZeroes) {
        int k;
        block7: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * rowIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new double[2 * nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[2 * r] = values[2 * k];
            this.values[2 * r + 1] = values[2 * k + 1];
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public DComplexMatrix2D assign(final DComplexDComplexFunction function) {
        if (function instanceof DComplexMult) {
            double[] alpha = ((DComplexMult)function).multiplicator;
            if (alpha[0] == 1.0 && alpha[1] == 0.0) {
                return this;
            }
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this.assign(0.0, 0.0);
            }
            if (alpha[0] != alpha[0] || alpha[1] != alpha[1]) {
                return this.assign(alpha);
            }
            double[] valuesE = this.values;
            int nz = this.cardinality();
            double[] valE = new double[2];
            for (int j = 0; j < nz; ++j) {
                valE[0] = valuesE[2 * j];
                valE[1] = valuesE[2 * j + 1];
                valE = DComplex.mult(valE, alpha);
                valuesE[2 * j] = valE[0];
                valuesE[2 * j + 1] = valE[1];
            }
        } else {
            this.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int i, int j, double[] value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(double re, double im) {
        if (re == 0.0 && im == 0.0) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[2 * i] = re;
                this.values[2 * i + 1] = im;
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D other = (SparseCCDComplexMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.rowIndexes.length < nzmax) {
                this.rowIndexes = new int[nzmax];
                this.values = new double[2 * nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.rowIndexes, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.values, 0, other.getValues().length);
        } else if (source instanceof SparseRCDComplexMatrix2D) {
            SparseRCDComplexMatrix2D other = ((SparseRCDComplexMatrix2D)source).getConjugateTranspose();
            this.columnPointers = other.getRowPointers();
            this.rowIndexes = other.getColumnIndexes();
            this.values = other.getValues();
        } else {
            this.assign(0.0, 0.0);
            source.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int i, int j, double[] value) {
                    SparseCCDComplexMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D y, DComplexDComplexDComplexFunction function) {
        this.checkShape(y);
        if (y instanceof SparseCCDComplexMatrix2D && function == DComplexFunctions.plus) {
            SparseCCDComplexMatrix2D yy = (SparseCCDComplexMatrix2D)y;
            int nz = 0;
            int m = this.rows;
            int anz = this.columnPointers[this.columns];
            int n = yy.columns;
            int[] Bp = yy.columnPointers;
            int bnz = Bp[n];
            int[] w = new int[m];
            double[] x = new double[2 * m];
            SparseCCDComplexMatrix2D C = new SparseCCDComplexMatrix2D(m, n, anz + bnz);
            int[] Cp = C.columnPointers;
            int[] Ci = C.rowIndexes;
            double[] Cx = C.values;
            double[] one = new double[]{1.0, 0.0};
            for (int j = 0; j < n; ++j) {
                Cp[j] = nz;
                nz = this.scatter(this, j, one, w, x, j + 1, C, nz);
                nz = this.scatter(yy, j, one, w, x, j + 1, C, nz);
                for (int p = Cp[j]; p < nz; ++p) {
                    Cx[2 * p] = x[2 * Ci[p]];
                    Cx[2 * p + 1] = x[2 * Ci[p] + 1];
                }
            }
            Cp[n] = nz;
            this.rowIndexes = Ci;
            this.columnPointers = Cp;
            this.values = Cx;
            return this;
        }
        if (function instanceof DComplexPlusMultSecond) {
            final double[] alpha = ((DComplexPlusMultSecond)function).multiplicator;
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int i, int j, double[] value) {
                    SparseCCDComplexMatrix2D.this.setQuick(i, j, DComplex.plus(SparseCCDComplexMatrix2D.this.getQuick(i, j), DComplex.mult(alpha, value)));
                    return value;
                }
            });
            return this;
        }
        if (function instanceof DComplexPlusMultFirst) {
            final double[] alpha = ((DComplexPlusMultFirst)function).multiplicator;
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int i, int j, double[] value) {
                    SparseCCDComplexMatrix2D.this.setQuick(i, j, DComplex.plus(DComplex.mult(alpha, SparseCCDComplexMatrix2D.this.getQuick(i, j)), value));
                    return value;
                }
            });
            return this;
        }
        if (function == DComplexFunctions.mult) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            double[] valuesA = this.values;
            double[] valA = new double[2];
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    valA[0] = valuesA[2 * k];
                    valA[1] = valuesA[2 * k + 1];
                    valA = DComplex.mult(valA, y.getQuick(i, j));
                    valuesA[2 * k] = valA[0];
                    valuesA[2 * k + 1] = valA[1];
                    if (valuesA[2 * k] != 0.0 || valuesA[2 * k + 1] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == DComplexFunctions.div) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            double[] valuesA = this.values;
            double[] valA = new double[2];
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    valA[0] = valuesA[2 * k];
                    valA[1] = valuesA[2 * k + 1];
                    valA = DComplex.div(valA, y.getQuick(i, j));
                    valuesA[2 * k] = valA[0];
                    valuesA[2 * k + 1] = valA[1];
                    if (valuesA[2 * k] != 0.0 || valuesA[2 * k + 1] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction function) {
        int[] rowIndexesA = this.rowIndexes;
        int[] columnPointersA = this.columnPointers;
        double[] valuesA = this.values;
        double[] valA = new double[2];
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                int i = rowIndexesA[k];
                valA[0] = valuesA[2 * k];
                valA[1] = valuesA[2 * k + 1];
                valA = function.apply(i, j, valA);
                valuesA[2 * k] = valA[0];
                valuesA[2 * k + 1] = valA[1];
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseDComplexMatrix2D getDense() {
        final DenseDComplexMatrix2D dense = new DenseDComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDComplexFunction(){

            public double[] apply(int i, int j, double[] value) {
                dense.setQuick(i, j, SparseCCDComplexMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    public synchronized double[] getQuick(int row, int column) {
        int k = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        double[] v = new double[2];
        if (k >= 0) {
            v[0] = this.values[2 * k];
            v[1] = this.values[2 * k + 1];
        }
        return v;
    }

    public SparseRCDComplexMatrix2D getRowCompressed() {
        SparseCCDComplexMatrix2D tr = this.getConjugateTranspose();
        SparseRCDComplexMatrix2D rc = new SparseRCDComplexMatrix2D(this.rows, this.columns);
        rc.columnIndexes = tr.rowIndexes;
        rc.rowPointers = tr.columnPointers;
        rc.values = tr.values;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public DZcs_common.DZcs elements() {
        DZcs_common.DZcs cs = new DZcs_common.DZcs();
        cs.m = this.rows;
        cs.n = this.columns;
        cs.i = this.rowIndexes;
        cs.p = this.columnPointers;
        cs.x = this.values;
        cs.nz = -1;
        cs.nzmax = this.values.length / 2;
        return cs;
    }

    public SparseCCDComplexMatrix2D getTranspose() {
        DZcs_common.DZcs dzcst = DZcs_transpose.cs_transpose((DZcs_common.DZcs)this.elements(), (boolean)true);
        SparseCCDComplexMatrix2D tr = new SparseCCDComplexMatrix2D(dzcst);
        return tr;
    }

    public SparseCCDComplexMatrix2D getConjugateTranspose() {
        int p;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        double[] Ax = this.values;
        SparseCCDComplexMatrix2D C = new SparseCCDComplexMatrix2D(this.columns, this.rows, Ai.length);
        int[] w = new int[m];
        int[] Cp = C.columnPointers;
        int[] Ci = C.rowIndexes;
        double[] Cx = C.values;
        for (p = 0; p < Ap[n]; ++p) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
        }
        this.cumsum(Cp, w, m);
        for (int j = 0; j < n; ++j) {
            for (p = Ap[j]; p < Ap[j + 1]; ++p) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                Cx[2 * q] = Ax[2 * p];
                Cx[2 * q + 1] = -Ax[2 * p + 1];
            }
        }
        return C;
    }

    public double[] getValues() {
        return this.values;
    }

    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseCCDComplexMatrix2D(rows, columns);
    }

    public DComplexMatrix1D like1D(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    public synchronized void setQuick(int row, int column, double[] value) {
        int k = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        if (k >= 0) {
            if (value[0] == 0.0 && value[1] == 0.0) {
                this.remove(column, k);
            } else {
                this.values[2 * k] = value[0];
                this.values[2 * k + 1] = value[1];
            }
            return;
        }
        if (value[0] != 0.0 || value[1] != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public synchronized void setQuick(int row, int column, double re, double im) {
        int k = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        if (k >= 0) {
            if (re == 0.0 && im == 0.0) {
                this.remove(column, k);
            } else {
                this.values[2 * k] = re;
                this.values[2 * k + 1] = im;
            }
            return;
        }
        if (re != 0.0 || im != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, re, im);
        }
    }

    public void sortRowIndexes() {
        SparseCCDComplexMatrix2D tr = this.getConjugateTranspose();
        tr = tr.getConjugateTranspose();
        this.columnPointers = tr.columnPointers;
        this.rowIndexes = tr.rowIndexes;
        this.values = tr.values;
    }

    public void removeDuplicates() {
        int i;
        int nz = 0;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        double[] Ax = this.values;
        int[] w = new int[m];
        for (i = 0; i < m; ++i) {
            w[i] = -1;
        }
        for (int j = 0; j < n; ++j) {
            int q = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                i = Ai[p];
                if (w[i] >= q) {
                    int n2 = w[i];
                    Ax[n2] = Ax[n2] + Ax[p];
                    continue;
                }
                w[i] = nz;
                Ai[nz] = i;
                Ax[2 * nz] = Ax[2 * p];
                Ax[2 * nz + 1] = Ax[2 * p + 1];
                ++nz;
            }
            Ap[j] = q;
        }
        Ap[n] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        double[] Ax = this.values;
        for (int j = 0; j < n; ++j) {
            Ap[j] = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                if (Ax[p] == 0.0) continue;
                Ai[nz] = Ai[p];
                Ax[2 * nz] = Ax[2 * p];
                Ax[2 * nz + 1] = Ax[2 * p + 1];
                ++nz;
            }
        }
        Ap[n] = nz;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int high = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < high; ++j) {
                if (this.values[2 * j + 1] > 0.0) {
                    builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0) {
                    builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return builder.toString();
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D y, DComplexMatrix1D z, final double[] alpha, final double[] beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || transposeA;
        if (z == null) {
            z = new DenseDComplexMatrix1D(rowsA);
        }
        if (!(y instanceof DenseDComplexMatrix1D) || !(z instanceof DenseDComplexMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseDComplexMatrix1D zz = (DenseDComplexMatrix1D)z;
        final double[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)zz.index(0);
        DenseDComplexMatrix1D yy = (DenseDComplexMatrix1D)y;
        final double[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)yy.index(0);
        final int[] rowIndexesA = this.rowIndexes;
        final int[] columnPointersA = this.columnPointers;
        final double[] valuesA = this.values;
        int zidx = zeroZ;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (!transposeA) {
            if (!(ignore || beta[0] == 1.0 && beta[1] == 0.0)) {
                z.assign(DComplexFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final double[] result = new double[2 * rowsA];
                int k = this.columns / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] yElem = new double[2];
                            double[] valA = new double[2];
                            if (threadID == 0) {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j = rowIndexesA[k];
                                        valA[0] = valuesA[2 * k];
                                        valA[1] = valuesA[2 * k + 1];
                                        valA = DComplex.mult(valA, yElem);
                                        valA = DComplex.mult(valA, alpha);
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + valA[0];
                                        int n2 = zeroZ + strideZ * j + 1;
                                        elementsZ[n2] = elementsZ[n2] + valA[1];
                                    }
                                }
                            } else {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j = rowIndexesA[k];
                                        valA[0] = valuesA[2 * k];
                                        valA[1] = valuesA[2 * k + 1];
                                        valA = DComplex.mult(valA, yElem);
                                        valA = DComplex.mult(valA, alpha);
                                        int n = 2 * j;
                                        result[n] = result[n] + valA[0];
                                        int n3 = 2 * j + 1;
                                        result[n3] = result[n3] + valA[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = 0; j < rowsA; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[2 * j];
                    int n2 = zeroZ + j * strideZ + 1;
                    elementsZ[n2] = elementsZ[n2] + result[2 * j + 1];
                }
            } else {
                double[] yElem = new double[2];
                double[] valA = new double[2];
                for (int i = 0; i < this.columns; ++i) {
                    int high = columnPointersA[i + 1];
                    yElem[0] = elementsY[zeroY + strideY * i];
                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                    for (int k = columnPointersA[i]; k < high; ++k) {
                        int j = rowIndexesA[k];
                        valA[0] = valuesA[2 * k];
                        valA[1] = valuesA[2 * k + 1];
                        valA = DComplex.mult(valA, yElem);
                        valA = DComplex.mult(valA, alpha);
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + valA[0];
                        int n3 = zeroZ + strideZ * j + 1;
                        elementsZ[n3] = elementsZ[n3] + valA[1];
                    }
                }
            }
        } else if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int zidx = zeroZ + firstColumn * strideZ;
                        double[] valA = new double[2];
                        double[] valY = new double[2];
                        double[] valZ = new double[2];
                        for (int i = firstColumn; i < lastColumn; ++i) {
                            double[] sum = new double[2];
                            int high = SparseCCDComplexMatrix2D.this.columnPointers[i + 1];
                            for (int k = SparseCCDComplexMatrix2D.this.columnPointers[i]; k < high; ++k) {
                                valA[0] = valuesA[2 * k];
                                valA[1] = -valuesA[2 * k + 1];
                                valY[0] = elementsY[zeroY + strideY * SparseCCDComplexMatrix2D.this.rowIndexes[k]];
                                valY[1] = elementsY[zeroY + strideY * SparseCCDComplexMatrix2D.this.rowIndexes[k] + 1];
                                sum = DComplex.plus(sum, DComplex.mult(valA, valY));
                            }
                            sum = DComplex.mult(alpha, sum);
                            valZ[0] = elementsZ[zidx];
                            valZ[1] = elementsZ[zidx + 1];
                            valZ = DComplex.mult(valZ, beta);
                            elementsZ[zidx] = sum[0] + valZ[0];
                            elementsZ[zidx + 1] = sum[1] + valZ[1];
                            zidx += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] valA = new double[2];
            double[] valY = new double[2];
            double[] valZ = new double[2];
            for (int i = 0; i < this.columns; ++i) {
                double[] sum = new double[2];
                int high = this.columnPointers[i + 1];
                for (int k = this.columnPointers[i]; k < high; ++k) {
                    valA[0] = valuesA[2 * k];
                    valA[1] = -valuesA[2 * k + 1];
                    valY[0] = elementsY[zeroY + strideY * this.rowIndexes[k]];
                    valY[1] = elementsY[zeroY + strideY * this.rowIndexes[k] + 1];
                    sum = DComplex.plus(sum, DComplex.mult(valA, valY));
                }
                sum = DComplex.mult(alpha, sum);
                valZ[0] = elementsZ[zidx];
                valZ[1] = elementsZ[zidx + 1];
                valZ = DComplex.mult(valZ, beta);
                elementsZ[zidx] = sum[0] + valZ[0];
                elementsZ[zidx + 1] = sum[1] + valZ[1];
                zidx += strideZ;
            }
        }
        return z;
    }

    public DComplexMatrix2D zMult(DComplexMatrix2D B, DComplexMatrix2D C, double[] alpha, double[] beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseCCDComplexMatrix2D ? new SparseCCDComplexMatrix2D(rowsA, p, rowsA * p) : new DenseDComplexMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(ignore || beta[0] == 1.0 && beta[1] == 0.0)) {
            C.assign(DComplexFunctions.mult(beta));
        }
        if (B instanceof DenseDComplexMatrix2D && C instanceof DenseDComplexMatrix2D) {
            SparseCCDComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            DenseDComplexMatrix2D BB = transposeB ? (DenseDComplexMatrix2D)B.getConjugateTranspose() : (DenseDComplexMatrix2D)B;
            DenseDComplexMatrix2D CC = (DenseDComplexMatrix2D)C;
            int[] columnPointersA = AA.columnPointers;
            int[] rowIndexesA = AA.rowIndexes;
            double[] valuesA = AA.values;
            int zeroB = (int)BB.index(0, 0);
            int rowStrideB = BB.rowStride();
            int columnStrideB = BB.columnStride();
            double[] elementsB = BB.elements;
            int zeroC = (int)CC.index(0, 0);
            int rowStrideC = CC.rowStride();
            int columnStrideC = CC.columnStride();
            double[] elementsC = CC.elements;
            double[] valA = new double[2];
            double[] valB = new double[2];
            for (int jj = 0; jj < columnsB; ++jj) {
                for (int kk = 0; kk < columnsA; ++kk) {
                    int high = columnPointersA[kk + 1];
                    valB[0] = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB];
                    valB[1] = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB + 1];
                    for (int ii = columnPointersA[kk]; ii < high; ++ii) {
                        int j = rowIndexesA[ii];
                        valA[0] = valuesA[2 * ii];
                        valA[1] = valuesA[2 * ii + 1];
                        valA = DComplex.mult(valA, valB);
                        int n = zeroC + j * rowStrideC + jj * columnStrideC;
                        elementsC[n] = elementsC[n] + valA[0];
                        int n2 = zeroC + j * rowStrideC + jj * columnStrideC + 1;
                        elementsC[n2] = elementsC[n2] + valA[1];
                    }
                }
            }
            if (alpha[0] != 1.0 || alpha[1] != 0.0) {
                C.assign(DComplexFunctions.mult(alpha));
            }
        } else if (B instanceof SparseCCDComplexMatrix2D && C instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            SparseCCDComplexMatrix2D BB = (SparseCCDComplexMatrix2D)B;
            if (transposeB) {
                BB = BB.getConjugateTranspose();
            }
            SparseCCDComplexMatrix2D CC = (SparseCCDComplexMatrix2D)C;
            int nz = 0;
            int m = rowsA;
            int n = columnsB;
            int[] Bp = BB.columnPointers;
            int[] Bi = BB.rowIndexes;
            double[] Bx = BB.values;
            int[] w = new int[m];
            double[] x = new double[2 * m];
            int[] Cp = CC.columnPointers;
            int[] Ci = CC.rowIndexes;
            double[] Cx = CC.values;
            for (int j = 0; j < n; ++j) {
                int nzmaxC = CC.rowIndexes.length;
                if (nz + m > nzmaxC) {
                    nzmaxC = 2 * nzmaxC + m;
                    int[] rowIndexesNew = new int[nzmaxC];
                    System.arraycopy(Ci, 0, rowIndexesNew, 0, Ci.length);
                    Ci = rowIndexesNew;
                    double[] valuesNew = new double[2 * nzmaxC];
                    System.arraycopy(Cx, 0, valuesNew, 0, Cx.length);
                    Cx = valuesNew;
                }
                Cp[j] = nz;
                double[] elemB = new double[2];
                for (p = Bp[j]; p < Bp[j + 1]; ++p) {
                    elemB[0] = Bx[2 * p];
                    elemB[1] = Bx[2 * p + 1];
                    nz = this.scatter(AA, Bi[p], elemB, w, x, j + 1, CC, nz);
                }
                for (p = Cp[j]; p < nz; ++p) {
                    Cx[2 * p] = x[2 * Ci[p]];
                    Cx[2 * p + 1] = x[2 * Ci[p] + 1];
                }
            }
            Cp[n] = nz;
            if (alpha[0] != 1.0 || alpha[1] != 0.0) {
                CC.assign(DComplexFunctions.mult(alpha));
            }
        } else {
            if (transposeB) {
                B = B.getConjugateTranspose();
            }
            DComplexMatrix1D[] Brows = new DComplexMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            DComplexMatrix1D[] Crows = new DComplexMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            DComplexPlusMultSecond fun = DComplexPlusMultSecond.plusMult(new double[2]);
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            double[] valuesA = this.values;
            double[] valA = new double[2];
            int i3 = this.columns;
            while (--i3 >= 0) {
                int low = columnPointersA[i3];
                int k = columnPointersA[i3 + 1];
                while (--k >= low) {
                    int j = rowIndexesA[k];
                    valA[0] = valuesA[2 * k];
                    valA[1] = valuesA[2 * k + 1];
                    fun.multiplicator = DComplex.mult(valA, alpha);
                    if (!transposeA) {
                        Crows[j].assign(Brows[i3], fun);
                        continue;
                    }
                    Crows[i3].assign(Brows[j], fun);
                }
            }
        }
        return C;
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, double[] value) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        rowIndexesList.setSizeRaw(this.columnPointers[this.columns]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(2 * this.columnPointers[this.columns]);
        rowIndexesList.beforeInsert(index, row);
        valuesList.beforeInsert(2 * index, value[0]);
        valuesList.beforeInsert(2 * index + 1, value[1]);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void insert(int row, int column, int index, double re, double im) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        rowIndexesList.setSizeRaw(this.columnPointers[this.columns]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(2 * this.columnPointers[this.columns]);
        rowIndexesList.beforeInsert(index, row);
        valuesList.beforeInsert(2 * index, re);
        valuesList.beforeInsert(2 * index + 1, im);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        rowIndexesList.remove(index);
        valuesList.remove(2 * index);
        valuesList.remove(2 * index + 1);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    private long cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        long nz2 = 0L;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += (long)c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.columnPointers[this.columns];
        }
        int[] rowIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, rowIndexesNew, 0, length);
        this.rowIndexes = rowIndexesNew;
        double[] valuesNew = new double[2 * nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    private int scatter(SparseCCDComplexMatrix2D A, int j, double[] beta, int[] w, double[] x, int mark, SparseCCDComplexMatrix2D C, int nz) {
        int[] Ap = A.columnPointers;
        int[] Ai = A.rowIndexes;
        double[] Ax = A.values;
        int[] Ci = C.rowIndexes;
        double[] valX = new double[2];
        double[] valA = new double[2];
        for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
            int i = Ai[p];
            if (w[i] < mark) {
                w[i] = mark;
                Ci[nz++] = i;
                if (x == null) continue;
                valA[0] = Ax[2 * p];
                valA[1] = Ax[2 * p + 1];
                valA = DComplex.mult(beta, valA);
                x[2 * i] = valA[0];
                x[2 * i + 1] = valA[1];
                continue;
            }
            if (x == null) continue;
            valA[0] = Ax[2 * p];
            valA[1] = Ax[2 * p + 1];
            valA = DComplex.mult(beta, valA);
            int n = 2 * i;
            x[n] = x[n] + valA[0];
            int n2 = 2 * i + 1;
            x[n2] = x[n2] + valA[1];
        }
        return nz;
    }
}

