/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseDComplexMatrix1D(int size, ConcurrentHashMap<Long, double[]> elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected SelectedSparseDComplexMatrix1D(ConcurrentHashMap<Long, double[]> elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    public double[] getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D other) {
        if (other instanceof SelectedSparseDComplexMatrix1D) {
            SelectedSparseDComplexMatrix1D otherMatrix = (SelectedSparseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDComplexMatrix1D) {
            SparseDComplexMatrix1D otherMatrix = (SparseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public DComplexMatrix1D like(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int index, double[] value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value[0] == 0.0 && value[1] == 0.0) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public void setQuick(int index, double re, double im) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (re == 0.0 && im == 0.0) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, new double[]{re, im});
        }
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDComplexMatrix1D(this.elements, offsets);
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

