/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DComplexProperty {
    public static final DComplexProperty DEFAULT = new DComplexProperty(1.0E-9);
    public static final DComplexProperty ZERO = new DComplexProperty(0.0);
    public static final DComplexProperty TWELVE = new DComplexProperty(1.0E-12);
    protected double tolerance;

    private DComplexProperty() {
        this(1.0E-9);
    }

    public DComplexProperty(double newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    public void setTolerance(double newTolerance) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public void checkDense(DComplexMatrix1D A) {
        if (!(A instanceof DenseDComplexMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkSquare(DComplexMatrix2D A) {
        if (A.rows() != A.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(A));
        }
    }

    public void checkSparse(DComplexMatrix2D A) {
        if (!(A instanceof SparseCCDComplexMatrix2D) && !(A instanceof SparseRCDComplexMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public boolean equals(final DComplexMatrix1D A, final double[] value) {
        if (A == null) {
            return false;
        }
        final double epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int size = (int)A.size();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double[] x = A.getQuick(i);
                            diff[0] = Math.abs(value[0] - x[0]);
                            diff[1] = Math.abs(value[1] - x[1]);
                            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                diff[0] = 0.0;
                                diff[1] = 0.0;
                            }
                            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        int i = 0;
        while ((long)i < A.size()) {
            double[] x = A.getQuick(i);
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0;
                diff[1] = 0.0;
            }
            if (diff[0] > epsilon || diff[1] > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final DComplexMatrix1D A, final DComplexMatrix1D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int size = (int)A.size();
        if ((long)size != B.size()) {
            return false;
        }
        final double epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double[] x = A.getQuick(i);
                            double[] value = B.getQuick(i);
                            diff[0] = Math.abs(value[0] - x[0]);
                            diff[1] = Math.abs(value[1] - x[1]);
                            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                diff[0] = 0.0;
                                diff[1] = 0.0;
                            }
                            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        for (int i = 0; i < size; ++i) {
            double[] x = A.getQuick(i);
            double[] value = B.getQuick(i);
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0;
                diff[1] = 0.0;
            }
            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final DComplexMatrix2D A, final double[] value) {
        if (A == null) {
            return false;
        }
        int rows = A.rows();
        int columns = A.columns();
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < A.columns(); ++c) {
                                double[] x = A.getQuick(r, c);
                                diff[0] = Math.abs(value[0] - x[0]);
                                diff[1] = Math.abs(value[1] - x[1]);
                                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                    diff[0] = 0.0;
                                    diff[1] = 0.0;
                                }
                                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                double[] x = A.getQuick(r, c);
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0;
                    diff[1] = 0.0;
                }
                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix2D A, final DComplexMatrix2D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int rows = A.rows();
        int columns = A.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < A.columns(); ++c) {
                                double[] x = A.getQuick(r, c);
                                double[] value = B.getQuick(r, c);
                                diff[0] = Math.abs(value[0] - x[0]);
                                diff[1] = Math.abs(value[1] - x[1]);
                                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                    diff[0] = 0.0;
                                    diff[1] = 0.0;
                                }
                                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                double[] x = A.getQuick(r, c);
                double[] value = B.getQuick(r, c);
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0;
                    diff[1] = 0.0;
                }
                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix3D A, final double[] value) {
        if (A == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    double[] x = A.getQuick(s, r, c);
                                    diff[0] = Math.abs(value[0] - x[0]);
                                    diff[1] = Math.abs(value[1] - x[1]);
                                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                        diff[0] = 0.0;
                                        diff[1] = 0.0;
                                    }
                                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    double[] x = A.getQuick(s, r, c);
                    diff[0] = Math.abs(value[0] - x[0]);
                    diff[1] = Math.abs(value[1] - x[1]);
                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                        diff[0] = 0.0;
                        diff[1] = 0.0;
                    }
                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix3D A, final DComplexMatrix3D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        boolean result = false;
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] diff = new double[2];
                        for (int s = startslice; s < stopslice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    double[] x = A.getQuick(s, r, c);
                                    double[] value = B.getQuick(s, r, c);
                                    diff[0] = Math.abs(value[0] - x[0]);
                                    diff[1] = Math.abs(value[1] - x[1]);
                                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                                        diff[0] = 0.0;
                                        diff[1] = 0.0;
                                    }
                                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        double[] diff = new double[2];
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    double[] x = A.getQuick(s, r, c);
                    double[] value = B.getQuick(s, r, c);
                    diff[0] = Math.abs(value[0] - x[0]);
                    diff[1] = Math.abs(value[1] - x[1]);
                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                        diff[0] = 0.0;
                        diff[1] = 0.0;
                    }
                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

