/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.matrix.TimerProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;

public class BenchmarkMatrixKernel {
    public static int MATRIX_SIZE_1D = (int)Math.pow(2.0, 19.0);
    public static int[] MATRIX_SIZE_2D = new int[]{(int)Math.pow(2.0, 12.0), (int)Math.pow(2.0, 12.0)};
    public static int[] MATRIX_SIZE_3D = new int[]{(int)Math.pow(2.0, 7.0), (int)Math.pow(2.0, 7.0), (int)Math.pow(2.0, 7.0)};
    public static int[] NTHREADS = new int[]{1, 2, 4, 8};
    public static int NITERS = 20;
    private static String settingsFileName1D = "settings1D.txt";
    private static String settingsFileName2D = "settings2D.txt";
    private static String settingsFileName3D = "settings3D.txt";

    private BenchmarkMatrixKernel() {
    }

    public static void readSettings1D() {
        File settingsFile = new File(settingsFileName1D = System.getProperty("settingsFile1D", settingsFileName1D));
        if (settingsFile.exists()) {
            try {
                RandomAccessFile input = null;
                input = new RandomAccessFile(settingsFileName1D, "r");
                String line = input.readLine();
                line = input.readLine();
                String[] stringThreads = line.split(",");
                NTHREADS = new int[stringThreads.length];
                for (int i = 0; i < stringThreads.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringThreads[i].trim());
                }
                line = input.readLine();
                MATRIX_SIZE_1D = Integer.parseInt(line.trim());
                line = input.readLine();
                NITERS = Integer.parseInt(line.trim());
                input.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_1D);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void readSettings2D() {
        File settingsFile = new File(settingsFileName2D = System.getProperty("settingsFile2D", settingsFileName2D));
        if (settingsFile.exists()) {
            try {
                RandomAccessFile input = null;
                input = new RandomAccessFile(settingsFileName2D, "r");
                String line = input.readLine();
                line = input.readLine();
                String[] stringThreads = line.split(",");
                NTHREADS = new int[stringThreads.length];
                for (int i = 0; i < stringThreads.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringThreads[i].trim());
                }
                line = input.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] = Integer.parseInt(line.trim());
                line = input.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_2D[1] = Integer.parseInt(line.trim());
                line = input.readLine();
                NITERS = Integer.parseInt(line.trim());
                input.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_2D[0] + " x " + MATRIX_SIZE_2D[1]);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void readSettings3D() {
        File settingsFile = new File(settingsFileName3D = System.getProperty("settingsFile3D", settingsFileName3D));
        if (settingsFile.exists()) {
            try {
                RandomAccessFile input = null;
                input = new RandomAccessFile(settingsFileName3D, "r");
                String line = input.readLine();
                line = input.readLine();
                String[] stringThreads = line.split(",");
                NTHREADS = new int[stringThreads.length];
                for (int i = 0; i < stringThreads.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringThreads[i].trim());
                }
                line = input.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] = Integer.parseInt(line.trim());
                line = input.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] = Integer.parseInt(line.trim());
                line = input.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[2] = Integer.parseInt(line.trim());
                line = input.readLine();
                NITERS = Integer.parseInt(line.trim());
                input.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_3D[0] + " x " + MATRIX_SIZE_3D[1] + " x " + MATRIX_SIZE_3D[2]);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void writePropertiesToFile(String filename, int[] size) {
        String[] properties = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, false));
            out.write(new Date().toString());
            out.newLine();
            out.write("System properties:");
            out.newLine();
            out.write("\tos.name = " + System.getProperty(properties[0]));
            out.newLine();
            out.write("\tos.version = " + System.getProperty(properties[1]));
            out.newLine();
            out.write("\tos.arch = " + System.getProperty(properties[2]));
            out.newLine();
            out.write("\tjava.vendor = " + System.getProperty(properties[3]));
            out.newLine();
            out.write("\tjava.version = " + System.getProperty(properties[4]));
            out.newLine();
            out.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            out.newLine();
            switch (size.length) {
                case 1: {
                    out.write("Matrix size = " + size[0]);
                    break;
                }
                case 2: {
                    out.write("Matrix size = " + size[0] + " x " + size[1]);
                    break;
                }
                case 3: {
                    out.write("Matrix size = " + size[0] + " x " + size[1] + " x " + size[2]);
                }
            }
            out.newLine();
            out.write("--------------------------------------------------------------------------------------------------");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeMatrixBenchmarkResultsToFile(String filename, String method, int[] threads, double[] noViewTimes, double[] viewTimes) {
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, true));
            out.write("Method = " + method);
            out.newLine();
            out.write("\tNo view execution times:");
            out.newLine();
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == 1) {
                    out.write("\t\t" + threads[i] + " thread  = " + String.format("%.2f", noViewTimes[i]) + " milliseconds");
                } else {
                    out.write("\t\t" + threads[i] + " threads = " + String.format("%.2f", noViewTimes[i]) + " milliseconds");
                }
                out.newLine();
            }
            out.write("\tView execution times:");
            out.newLine();
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == 1) {
                    out.write("\t\t" + threads[i] + " thread  = " + String.format("%.2f", viewTimes[i]) + " milliseconds");
                } else {
                    out.write("\t\t" + threads[i] + " threads = " + String.format("%.2f", viewTimes[i]) + " milliseconds");
                }
                out.newLine();
            }
            out.write("--------------------------------------------------------------------------------------------------");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displayProperties(int[] size) {
        String[] properties = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        System.out.println(new Date().toString());
        System.out.println("System properties:");
        System.out.println("\tos.name = " + System.getProperty(properties[0]));
        System.out.println("\tos.version = " + System.getProperty(properties[1]));
        System.out.println("\tos.arch = " + System.getProperty(properties[2]));
        System.out.println("\tjava.vendor = " + System.getProperty(properties[3]));
        System.out.println("\tjava.version = " + System.getProperty(properties[4]));
        System.out.println("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
        switch (size.length) {
            case 1: {
                System.out.println("Matrix size = " + size[0]);
                break;
            }
            case 2: {
                System.out.println("Matrix size = " + size[0] + " x " + size[1]);
                break;
            }
            case 3: {
                System.out.println("Matrix size = " + size[0] + " x " + size[1] + " x " + size[2]);
            }
        }
        System.out.println("--------------------------------------------------------------------------------------------------");
    }

    public static void displayMatrixBenchmarkResults(String method, int[] threads, double[] noViewTimes, double[] viewTimes) {
        int i;
        System.out.println("Method = " + method);
        System.out.println("\tNo view execution times:");
        for (i = 0; i < threads.length; ++i) {
            if (threads[i] == 1) {
                System.out.println("\t\t" + threads[i] + " thread  = " + String.format("%.2f", noViewTimes[i]) + " milliseconds");
                continue;
            }
            System.out.println("\t\t" + threads[i] + " threads = " + String.format("%.2f", noViewTimes[i]) + " milliseconds");
        }
        System.out.println("\tView execution times:");
        for (i = 0; i < threads.length; ++i) {
            if (threads[i] == 1) {
                System.out.println("\t\t" + threads[i] + " thread  = " + String.format("%.2f", viewTimes[i]) + " milliseconds");
                continue;
            }
            System.out.println("\t\t" + threads[i] + " threads = " + String.format("%.2f", viewTimes[i]) + " milliseconds");
        }
        System.out.println("--------------------------------------------------------------------------------------------------");
    }

    public static float run(double minSeconds, TimerProcedure procedure) {
        long iter = 0L;
        long minMillis = (long)(minSeconds * 1000.0);
        long begin = System.currentTimeMillis();
        long limit = begin + minMillis;
        while (System.currentTimeMillis() < limit) {
            procedure.init();
            procedure.apply(null);
            ++iter;
        }
        long end = System.currentTimeMillis();
        if (minSeconds / (double)iter < 0.1) {
            begin = System.currentTimeMillis();
            long i = iter;
            while (--i >= 0L) {
                procedure.init();
                procedure.apply(null);
            }
            end = System.currentTimeMillis();
        }
        long begin2 = System.currentTimeMillis();
        int dummy = 1;
        long i = iter;
        while (--i >= 0L) {
            dummy = (int)((long)dummy * i);
            procedure.init();
        }
        long end2 = System.currentTimeMillis();
        long elapsed = end - begin - (end2 - begin2);
        return (float)elapsed / 1000.0f / (float)iter;
    }

    public static String systemInfo() {
        Object[] properties = new String[]{"java.vm.vendor", "java.vm.version", "java.vm.name", "os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vendor.url"};
        DenseObjectMatrix2D matrix = new DenseObjectMatrix2D(properties.length, 2);
        matrix.viewColumn(0).assign(properties);
        for (int i = 0; i < properties.length; ++i) {
            String value = System.getProperty((String)properties[i]);
            if (value == null) {
                value = "?";
            }
            matrix.set(i, 1, value);
        }
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.setPrintShape(false);
        return formatter.toString(matrix);
    }
}

