/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBufferConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer
extends PersistentObject
implements ShortBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBufferConsumer target;
    protected short[] elements;
    protected ShortArrayList list;
    protected int capacity;
    protected int size;

    public ShortBuffer(ShortBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new short[capacity];
        this.list = new ShortArrayList(this.elements);
        this.size = 0;
    }

    public void add(short element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    public void addAllOf(ShortArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

