/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBuffer3DConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer3D
extends PersistentObject
implements LongBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBuffer3DConsumer target;
    protected long[] xElements;
    protected long[] yElements;
    protected long[] zElements;
    protected LongArrayList xList;
    protected LongArrayList yList;
    protected LongArrayList zList;
    protected int capacity;
    protected int size;

    public LongBuffer3D(LongBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new long[capacity];
        this.yElements = new long[capacity];
        this.zElements = new long[capacity];
        this.xList = new LongArrayList(this.xElements);
        this.yList = new LongArrayList(this.yElements);
        this.zList = new LongArrayList(this.zElements);
        this.size = 0;
    }

    public void add(long x, long y, long z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    public void addAllOf(LongArrayList xElements, LongArrayList yElements, LongArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

