/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBuffer2DConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer2D
extends PersistentObject
implements LongBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBuffer2DConsumer target;
    protected long[] xElements;
    protected long[] yElements;
    protected LongArrayList xList;
    protected LongArrayList yList;
    protected int capacity;
    protected int size;

    public LongBuffer2D(LongBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new long[capacity];
        this.yElements = new long[capacity];
        this.xList = new LongArrayList(this.xElements);
        this.yList = new LongArrayList(this.yElements);
        this.size = 0;
    }

    public void add(long x, long y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    public void addAllOf(LongArrayList x, LongArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

