/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.function.tbyte.ByteComparator;
import cern.colt.function.tchar.CharComparator;
import cern.colt.function.tdouble.DoubleComparator;
import cern.colt.function.tfloat.FloatComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongComparator;
import cern.colt.function.tshort.ShortComparator;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ParallelQuickSort {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    public static void quickSort(final byte[] x, final int off, int len, final ByteComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        byte v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final char[] x, final int off, int len, final CharComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        char v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final double[] x, final int off, int len, final DoubleComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final float[] x, final int off, int len, final FloatComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final int[] x, final int off, int len, final IntComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final long[] x, final int off, int len, final LongComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final Object[] x, final int off, int len, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && ((Comparable)x[j - 1]).compareTo(x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s);
                m = ParallelQuickSort.med3(x, m - s, m, m + s);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n);
            }
            m = ParallelQuickSort.med3(x, l, m, n);
        }
        Comparable v = (Comparable)x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = ((Comparable)x[b]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = ((Comparable)x[c]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, 1);
            }
        }
    }

    public static void quickSort(final Object[] x, final int off, int len, final Comparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        Object v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    public static void quickSort(final short[] x, final int off, int len, final ShortComparator comp, final int nThreads) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    ParallelQuickSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ParallelQuickSort.med3(x, l, l + s, l + 2 * s, comp);
                m = ParallelQuickSort.med3(x, m - s, m, m + s, comp);
                n = ParallelQuickSort.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = ParallelQuickSort.med3(x, l, m, n, comp);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ParallelQuickSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ParallelQuickSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ParallelQuickSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ParallelQuickSort.vecswap(x, b, n - s, s);
        Future<?> other = null;
        if (nThreads > 1) {
            int s_f;
            s = b - a;
            if (s > 1) {
                s_f = s;
                other = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(x, off, s_f, comp, nThreads / 2);
                    }
                });
            }
            if ((s = d - c) > 1) {
                if (other == null) {
                    s_f = s;
                    final int ns_f = n - s;
                    other = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(x, ns_f, s_f, comp, nThreads / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(x, n - s, s, comp, nThreads / 2);
                }
            }
            try {
                other.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            s = b - a;
            if (s > 1) {
                ParallelQuickSort.quickSort(x, off, s, comp, 1);
            }
            if ((s = d - c) > 1) {
                ParallelQuickSort.quickSort(x, n - s, s, comp, 1);
            }
        }
    }

    private static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(Object[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ParallelQuickSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c, ByteComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(char[] x, int a, int b, int c, CharComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(double[] x, int a, int b, int c, DoubleComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(float[] x, int a, int b, int c, FloatComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(long[] x, int a, int b, int c, LongComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(Object[] x, int a, int b, int c) {
        int ab = ((Comparable)x[a]).compareTo(x[b]);
        int ac = ((Comparable)x[a]).compareTo(x[c]);
        int bc = ((Comparable)x[b]).compareTo(x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(Object[] x, int a, int b, int c, Comparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(short[] x, int a, int b, int c, ShortComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }
}

