/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.GeometryState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.CompressedGeometryHeader;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Point3d;

public class CompressedGeometryState
extends GeometryState {
    private byte[] bytes;
    private boolean isByReference;
    private CompressedGeometryHeader header;
    static /* synthetic */ Class class$javax$media$j3d$CompressedGeometryHeader;

    public CompressedGeometryState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeBoolean(((CompressedGeometry)this.node).isByReference());
        int n = ((CompressedGeometry)this.node).getByteCount();
        dataOutput.writeInt(n);
        this.bytes = new byte[n];
        ((CompressedGeometry)this.node).getCompressedGeometry(this.bytes);
        dataOutput.write(this.bytes);
        this.header = new CompressedGeometryHeader();
        ((CompressedGeometry)this.node).getCompressedGeometryHeader(this.header);
        this.writeCompressedGeometryHeader(dataOutput);
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.isByReference = dataInput.readBoolean();
        this.bytes = new byte[dataInput.readInt()];
        dataInput.readFully(this.bytes);
        this.header = new CompressedGeometryHeader();
        this.readCompressedGeometryHeader(dataInput);
    }

    private void writeCompressedGeometryHeader(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.header.majorVersionNumber);
        dataOutput.writeInt(this.header.minorVersionNumber);
        dataOutput.writeInt(this.header.minorMinorVersionNumber);
        dataOutput.writeInt(this.header.bufferType);
        dataOutput.writeInt(this.header.bufferDataPresent);
        dataOutput.writeInt(this.header.size);
        dataOutput.writeInt(this.header.start);
        if (this.header.lowerBound == null) {
            this.control.writePoint3d(dataOutput, new Point3d(-1.0, -1.0, -1.0));
        } else {
            this.control.writePoint3d(dataOutput, this.header.lowerBound);
        }
        if (this.header.upperBound == null) {
            this.control.writePoint3d(dataOutput, new Point3d(1.0, 1.0, 1.0));
        } else {
            this.control.writePoint3d(dataOutput, this.header.upperBound);
        }
    }

    private void readCompressedGeometryHeader(DataInput dataInput) throws IOException {
        this.header.majorVersionNumber = dataInput.readInt();
        this.header.minorVersionNumber = dataInput.readInt();
        this.header.minorMinorVersionNumber = dataInput.readInt();
        this.header.bufferType = dataInput.readInt();
        this.header.bufferDataPresent = dataInput.readInt();
        this.header.size = dataInput.readInt();
        this.header.start = dataInput.readInt();
        this.header.lowerBound = this.control.readPoint3d(dataInput);
        if (this.header.lowerBound.x == -1.0 && this.header.lowerBound.y == -1.0 && this.header.lowerBound.z == -1.0) {
            this.header.lowerBound = null;
        }
        this.header.upperBound = this.control.readPoint3d(dataInput);
        if (this.header.upperBound.x == 1.0 && this.header.upperBound.y == 1.0 && this.header.upperBound.z == 1.0) {
            this.header.upperBound = null;
        }
    }

    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{class$javax$media$j3d$CompressedGeometryHeader == null ? (class$javax$media$j3d$CompressedGeometryHeader = CompressedGeometryState.class$("javax.media.j3d.CompressedGeometryHeader")) : class$javax$media$j3d$CompressedGeometryHeader, this.bytes.getClass(), Boolean.TYPE}, new Object[]{this.header, this.bytes, new Boolean(this.isByReference)});
    }

    protected SceneGraphObject createNode() {
        return new CompressedGeometry(this.header, this.bytes, this.isByReference);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

