/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LWOBFileReader;
import com.sun.j3d.loaders.lw3d.LwoTexture;
import com.sun.j3d.loaders.lw3d.ParserObject;
import java.awt.Image;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

class LwoSurface
extends ParserObject {
    LWOBFileReader theReader;
    int red = 255;
    int green = 255;
    int blue = 255;
    float diffuse = 0.0f;
    float specular = 0.0f;
    float transparency = 0.0f;
    float luminosity = 0.0f;
    float creaseAngle = 0.0f;
    int gloss = 128;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    float shininess;
    Image theImage = null;
    Vector3f textureCenter = null;
    Vector3f textureSize = null;
    int textureAxis;
    String surfName;
    Vector textureList = new Vector();

    LwoSurface(LWOBFileReader lWOBFileReader, int n, int n2) throws FileNotFoundException {
        super(n2);
        this.debugOutputLn(1, "LwoSurface()");
        this.theReader = lWOBFileReader;
        this.getSurf(n);
        this.setJ3dColors();
    }

    void setJ3dColors() {
        this.color = new Color3f((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f);
        this.diffuseColor = new Color3f(this.diffuse * this.color.x, this.diffuse * this.color.y, this.diffuse * this.color.z);
        this.specularColor = new Color3f(this.specular * this.color.x, this.specular * this.color.y, this.specular * this.color.z);
        this.emissiveColor = new Color3f(this.luminosity * this.color.x, this.luminosity * this.color.y, this.luminosity * this.color.z);
        this.shininess = (float)(128.0 * ((double)this.gloss / 1024.0));
    }

    Color3f getColor() {
        return this.color;
    }

    Color3f getDiffuseColor() {
        return this.diffuseColor;
    }

    Color3f getSpecularColor() {
        return this.specularColor;
    }

    Color3f getEmissiveColor() {
        return this.emissiveColor;
    }

    float getShininess() {
        return this.shininess;
    }

    float getCreaseAngle() {
        return this.creaseAngle;
    }

    LwoTexture getTexture() {
        this.debugOutputLn(1, "getTexture()");
        try {
            if (this.textureList.isEmpty()) {
                return null;
            }
            return (LwoTexture)this.textureList.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.debugOutputLn(16, "getTexture(), exception returning first element: " + arrayIndexOutOfBoundsException);
            return null;
        }
    }

    String getSurfName() {
        return this.surfName;
    }

    float getTransparency() {
        return this.transparency;
    }

    void getSurf(int n) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.debugOutputLn(1, "getSurf()");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this.theReader.getMarker() + n;
        this.surfName = this.theReader.getString();
        String string = this.theReader.getToken();
        while (string != null && this.theReader.getMarker() < n2) {
            this.debugOutputLn(2, "  tokenString = " + string);
            this.debugOutputLn(2, "  marker, stop = " + this.theReader.getMarker() + ", " + n2);
            String string2 = null;
            int n3 = this.theReader.getShortInt();
            this.debugOutputLn(2, "  fl = " + n3);
            if (string.equals("COLR")) {
                this.debugOutputLn(8, "  COLR");
                try {
                    this.red = this.theReader.read();
                    this.green = this.theReader.read();
                    this.blue = this.theReader.read();
                    this.theReader.read();
                }
                catch (IOException iOException) {
                    throw new ParsingErrorException(iOException.getMessage());
                }
                if (n3 != 4) {
                    throw new IncorrectFormatException(J3dUtilsI18N.getString("LwoSurface0"));
                }
            } else if (string.equals("FLAG")) {
                this.debugOutputLn(8, "  FLAG");
                this.theReader.skipLength(n3);
            } else if (string.equals("VLUM")) {
                this.debugOutputLn(8, "  VLUM");
                this.luminosity = this.theReader.getFloat();
                bl = true;
            } else if (string.equals("LUMI")) {
                this.debugOutputLn(8, "  LUMI");
                if (bl) {
                    this.theReader.skipLength(n3);
                } else {
                    this.luminosity = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (string.equals("VDIF")) {
                this.debugOutputLn(8, "  VDIF");
                if (n3 != 4) {
                    throw new IncorrectFormatException("VDIF problem");
                }
                this.diffuse = this.theReader.getFloat();
                bl3 = true;
                this.debugOutputLn(2, "diff = " + this.diffuse);
            } else if (string.equals("DIFF")) {
                this.debugOutputLn(8, "  DIFF");
                if (bl3) {
                    this.theReader.skipLength(n3);
                } else {
                    this.diffuse = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (string.equals("VTRN")) {
                this.debugOutputLn(8, "  VTRN");
                this.transparency = this.theReader.getFloat();
                bl2 = true;
            } else if (string.equals("TRAN")) {
                this.debugOutputLn(8, "  TRAN");
                if (bl2) {
                    this.theReader.skipLength(n3);
                } else {
                    this.transparency = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (string.equals("VSPC")) {
                this.debugOutputLn(8, "  VSPC");
                this.specular = this.theReader.getFloat();
                bl4 = true;
                this.debugOutputLn(2, "spec = " + this.specular);
            } else if (string.equals("SPEC")) {
                this.debugOutputLn(8, "  SPEC");
                if (bl4) {
                    this.theReader.skipLength(n3);
                } else {
                    this.specular = n3 == 4 ? (float)this.theReader.getInt() / 255.0f : (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (string.equals("GLOS")) {
                this.debugOutputLn(8, "  GLOS");
                this.gloss = n3 == 4 ? this.theReader.getInt() : this.theReader.getShortInt();
            } else if (string.equals("SMAN")) {
                this.debugOutputLn(8, "  SMAN");
                this.creaseAngle = this.theReader.getFloat();
            } else if (string.endsWith("TEX")) {
                LwoTexture lwoTexture = new LwoTexture(this.theReader, n2 - this.theReader.getMarker(), string, this.debugPrinter.getValidOutput());
                string2 = lwoTexture.getNextToken();
                if (lwoTexture.isHandled()) {
                    this.textureList.addElement(lwoTexture);
                }
                this.debugOutputLn(64, "val = " + string);
            } else {
                this.debugOutputLn(64, "unrecognized token: " + string);
                this.theReader.skipLength(n3);
            }
            if (this.theReader.getMarker() >= n2) continue;
            string = string2 == null ? this.theReader.getToken() : string2;
        }
    }
}

