/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LWOBFileReader;
import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.ParserObject;
import com.sun.j3d.loaders.lw3d.ShapeHolder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

class LwoParser
extends ParserObject {
    LWOBFileReader theReader;
    int currLength;
    float[] coordsArray;
    float[] normalCoordsArray;
    int[] facetIndicesArray;
    int[] facetSizesArray;
    int[] normalIndicesArray;
    int red = 255;
    int green = 255;
    int blue = 255;
    float diffuse = 0.0f;
    float specular = 0.0f;
    float transparency = 0.0f;
    float luminosity = 0.0f;
    int gloss = 128;
    Vector surfNameList = null;
    Vector surfaceList = new Vector(200);
    Vector shapeList = new Vector(200);

    LwoParser(String string, int n) throws FileNotFoundException {
        super(n);
        this.debugOutputLn(1, "parser()");
        long l = System.currentTimeMillis();
        this.theReader = new LWOBFileReader(string);
        this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - l));
        this.parseFile();
    }

    LwoParser(URL uRL, int n) throws FileNotFoundException {
        super(n);
        this.debugOutputLn(1, "parser()");
        try {
            long l = System.currentTimeMillis();
            this.theReader = new LWOBFileReader(uRL);
            this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - l));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(uRL.toString());
        }
        this.parseFile();
    }

    int skipDetailPolygons(int n) throws ParsingErrorException {
        this.debugOutputLn(1, "skipDetailPolygons(), numPolys = " + n);
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < n) {
                this.debugOutputLn(2, "polyNum = " + n3);
                int n4 = this.theReader.getShortInt();
                this.theReader.skip(n4 * 2 + 2);
                n2 += n4 * 2 + 4;
                ++n3;
            }
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "Exception in reading detail polys: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
        return n2;
    }

    ShapeHolder getAppropriateShape(int n, int n2) {
        Enumeration enumeration = this.shapeList.elements();
        while (enumeration.hasMoreElements()) {
            ShapeHolder shapeHolder = (ShapeHolder)enumeration.nextElement();
            if (shapeHolder.numSurf != n || shapeHolder.numVerts != n2 && (shapeHolder.numVerts <= 3 || n2 <= 3)) continue;
            return shapeHolder;
        }
        return null;
    }

    void getPols(int n) {
        this.debugOutputLn(1, "getPols(len), len = " + n);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        Vector<Integer> vector = new Vector<Integer>(n / 6);
        int[] nArray = new int[n / 2];
        ShapeHolder shapeHolder = new ShapeHolder(this.debugPrinter.getValidOutput());
        this.debugOutputLn(2, "new shape = " + shapeHolder);
        shapeHolder.coordsArray = this.coordsArray;
        shapeHolder.facetSizesList = vector;
        shapeHolder.facetIndicesArray = nArray;
        this.shapeList.addElement(shapeHolder);
        boolean bl = true;
        while (n2 < n) {
            int n5 = this.theReader.getShortInt();
            n2 += 2;
            int[] nArray2 = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray2[n6] = this.theReader.getShortInt();
                n2 += 2;
                ++n6;
            }
            int n7 = this.theReader.getShortInt();
            n2 += 2;
            long l = 0L;
            long l2 = 0L;
            if (!(bl || n7 == n4 && (n5 == n3 || n3 >= 3 && n5 >= 3))) {
                shapeHolder = this.getAppropriateShape(n7, n5);
                if (shapeHolder == null) {
                    vector = new Vector<Integer>(n / 6);
                    nArray = new int[n / 2];
                    shapeHolder = new ShapeHolder(this.debugPrinter.getValidOutput());
                    shapeHolder.coordsArray = this.coordsArray;
                    shapeHolder.facetSizesList = vector;
                    shapeHolder.facetIndicesArray = nArray;
                    shapeHolder.numSurf = n7;
                    shapeHolder.numVerts = n5;
                    this.shapeList.addElement(shapeHolder);
                } else {
                    vector = shapeHolder.facetSizesList;
                    nArray = shapeHolder.facetIndicesArray;
                }
            } else {
                shapeHolder.numSurf = n7;
                shapeHolder.numVerts = n5;
            }
            n3 = n5;
            n4 = n7;
            vector.addElement(new Integer(n5));
            boolean bl2 = false;
            System.arraycopy(nArray2, 0, nArray, shapeHolder.currentNumIndices, n5);
            shapeHolder.currentNumIndices += n5;
            if (n7 < 0) {
                int n8 = this.theReader.getShortInt();
                n2 += this.skipDetailPolygons(n8);
                shapeHolder.numSurf = ~shapeHolder.numSurf & 0xFFFF;
                if (shapeHolder.numSurf == 0) {
                    shapeHolder.numSurf = 1;
                }
            }
            bl = false;
        }
    }

    void getSrfs(int n) {
        String string = new String();
        this.surfNameList = new Vector(n / 2);
        boolean bl = false;
        int n2 = this.theReader.getMarker() + n;
        boolean bl2 = false;
        while (this.theReader.getMarker() < n2) {
            this.debugOutputLn(2, "marker, stop = " + this.theReader.getMarker() + ", " + n2);
            this.debugOutputLn(8, "About to call getString");
            string = this.theReader.getString();
            this.debugOutputLn(2, "Surfname = " + string);
            this.surfNameList.addElement(string);
        }
    }

    void getPnts(int n) throws ParsingErrorException {
        int n2 = n / 12;
        this.coordsArray = new float[n2 * 3];
        this.theReader.getVerts(this.coordsArray, n2);
    }

    void getSurf(int n) throws FileNotFoundException {
        this.debugOutputLn(1, "getSurf()");
        LwoSurface lwoSurface = new LwoSurface(this.theReader, n, this.debugPrinter.getValidOutput());
        this.surfaceList.addElement(lwoSurface);
    }

    int parseFile() throws FileNotFoundException, IncorrectFormatException {
        this.debugOutputLn(1, "parseFile()");
        int n = 0;
        int n2 = 0;
        int n3 = 100000;
        long l = System.currentTimeMillis();
        String string = this.theReader.getToken();
        while (string != null && n2 < n3) {
            long l2 = System.currentTimeMillis();
            n = this.theReader.getInt();
            n2 += 4;
            if (string.equals("FORM")) {
                n3 = n + 4;
                n = 0;
                string = this.theReader.getToken();
                n2 += 4;
                if (!string.equals("LWOB")) {
                    throw new IncorrectFormatException("File not of FORM-length-LWOB format");
                }
            } else if (string.equals("PNTS")) {
                this.getPnts(n);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l2));
            } else if (string.equals("POLS")) {
                this.getPols(n);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l2));
            } else if (string.equals("SRFS")) {
                this.getSrfs(n);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l2));
            } else if (string.equals("CRVS")) {
                this.theReader.skipLength(n);
            } else if (string.equals("PCHS")) {
                this.theReader.skipLength(n);
            } else if (string.equals("SURF")) {
                this.getSurf(n);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l2));
            } else if (!string.equals("LWOB")) {
                this.theReader.skipLength(n);
            }
            if ((n2 += n) >= n3) continue;
            string = this.theReader.getToken();
            n2 += 4;
        }
        this.debugOutputLn(32, "done with parseFile in " + (System.currentTimeMillis() - l));
        return 0;
    }

    static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "cube.obj" : stringArray[0];
        try {
            LwoParser lwoParser = new LwoParser(string, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
    }
}

