/*
 * Decompiled with CFR 0.152.
 */
package imputationtool.postprocessing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ScatterPlot {
    private BufferedImage bi;
    private Graphics2D g2d;
    private int graphHeight;
    private int graphWidth;
    private int drawWidth;
    private int drawHeight;
    private Color color;
    private Font font;

    public ScatterPlot(int size) {
        this.init(size, size);
    }

    protected void init(int width, int height) {
        this.graphHeight = height;
        this.graphWidth = width;
        this.bi = new BufferedImage(width, height, 1);
        this.g2d = this.bi.createGraphics();
        this.color = new Color(255, 255, 255);
        this.font = new Font("Georgia", 0, 10);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2d.setColor(this.color);
        this.g2d.fillRect(0, 0, this.graphWidth, this.graphHeight);
        this.g2d.draw(new Line2D.Double((double)this.graphWidth / 2.0, 0.0, (double)this.graphWidth / 2.0, this.graphHeight));
        this.color = new Color(0, 0, 0);
        this.g2d.setColor(this.color);
    }

    void plot(int x, int y) {
    }

    public void plot(double x, double y) {
        double xpos = (double)this.graphWidth / 2.0 + (double)this.graphWidth / 2.0 * x;
        double ypos = (double)this.graphHeight - (double)this.graphHeight * y;
        int ixpos = (int)Math.floor(xpos);
        int iypos = (int)Math.floor(ypos);
        this.g2d.fillRect(ixpos - 1, iypos + 1, 2, 2);
    }

    public void draw(String outputFile) {
        try {
            ImageIO.write((RenderedImage)this.bi, "png", new File(outputFile));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }
}

