/*
 * Decompiled with CFR 0.152.
 */
package imputationtool.postprocessing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.io.text.TextFile;

public class ImputationSNPPresenceCheck {
    private HashMap<String, Integer> snpMappings;
    private ArrayList<String> snps = new ArrayList();
    private HashMap<Integer, HashSet<String>> snpsPerChr;
    private HashMap<String, String> reasonExcluded;

    public void run(String[] args) throws IOException {
        if (args.length < 5) {
            System.out.println("snps snpmappings pedmapreferenceloc pedmapdatasetloc dosagefileloc");
        } else {
            ImputationSNPPresenceCheck m = new ImputationSNPPresenceCheck();
            System.out.println("Loading SNPs: " + args[1]);
            m.loadSNPs(args[0]);
            System.out.println("Loading SNP mappings: " + args[1]);
            m.loadSNPMappings(args[1]);
            System.out.println("Checking reference exclusion files: " + args[2]);
            m.checkReferenceExclusionFiles(args[2], true);
            System.out.println("Checking reference map files: " + args[2]);
            m.checkReferenceMapFiles(args[2], true);
            m.output();
        }
        System.exit(0);
    }

    public ImputationSNPPresenceCheck() {
        this.snpMappings = new HashMap();
        this.snpsPerChr = new HashMap();
        this.reasonExcluded = new HashMap();
    }

    private void loadSNPs(String string) throws IOException {
        TextFile in = new TextFile(string, false);
        String line = "";
        while ((line = in.readLine()) != null) {
            this.snps.add(line);
        }
        in.close();
    }

    private void loadSNPMappings(String string) throws IOException {
        Integer chr;
        TextFile in = new TextFile(string, false);
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] elems = line.split("\t");
            String snp = elems[2];
            chr = null;
            try {
                chr = Integer.parseInt(elems[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (chr == null) continue;
            this.snpMappings.put(snp, chr);
        }
        in.close();
        for (String s : this.snps) {
            chr = this.snpMappings.get(s);
            HashSet<String> v = this.snpsPerChr.get(chr);
            if (v == null) {
                v = new HashSet();
            }
            v.add(s);
            this.snpsPerChr.put(chr, v);
        }
    }

    private void checkReferenceExclusionFiles(String string, boolean reference) throws IOException {
        for (int chr = 0; chr < 23; ++chr) {
            HashSet<String> v = this.snpsPerChr.get(chr);
            if (v == null) continue;
            TextFile in = new TextFile(string + "chr" + chr + ".excludedsnps.txt", false);
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] elems = line.split("\t");
                String snp = elems[0];
                if (!v.contains(snp)) continue;
                String reason = this.reasonExcluded.get(snp);
                if (reason == null) {
                    reason = "";
                }
                reason = reference ? reason + "\tReference: " + elems[2] : reason + "\tDataset: " + elems[2];
                this.reasonExcluded.put(snp, reason);
            }
            in.close();
        }
    }

    private void checkReferenceMapFiles(String string, boolean reference) throws IOException {
        for (int chr = 0; chr < 23; ++chr) {
            HashSet<String> v = this.snpsPerChr.get(chr);
            if (v == null) continue;
            TextFile in = new TextFile(string + "chr" + chr + ".map", false);
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] elems = line.split("\t");
                String snp = elems[1];
                if (!v.contains(snp)) continue;
                String reason = this.reasonExcluded.get(snp);
                if (reason == null) {
                    reason = "";
                }
                reason = reference ? reason + "\tReference: in map file" : reason + "\tDataset: in map file";
                this.reasonExcluded.put(snp, reason);
            }
            in.close();
        }
    }

    private void checkDosageFiles(String string) throws IOException {
        for (int chr = 0; chr < 23; ++chr) {
            HashSet<String> v = this.snpsPerChr.get(chr);
            if (v == null) continue;
            TextFile in = new TextFile(string + "ImputedGenotypeDosageFormatPLINK-Chr" + chr + ".dose", false);
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] elems = line.split("\t");
                String snp = elems[0];
                if (!v.contains(snp)) continue;
                String reason = "" + this.reasonExcluded.get(snp);
                reason = reason + "\tIsIncludedInMapFile";
                this.reasonExcluded.put(snp, reason);
            }
            in.close();
        }
    }

    private void output() {
        for (String s : this.snps) {
            String reason = this.reasonExcluded.get(s);
            System.out.println(s + "\t" + this.snpMappings.get(s) + reason);
        }
    }
}

