/*
 * Decompiled with CFR 0.152.
 */
package imputationtool.postprocessing;

import JSci.maths.ArrayMath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.BaseAnnot;

public class CompareImputedSNPsToRealSNPs {
    private final TriTyperGenotypeData ggDataset1 = new TriTyperGenotypeData();
    private final TriTyperGenotypeData ggDataset2;

    public static void main(String[] args) throws IOException {
        CompareImputedSNPsToRealSNPs c = new CompareImputedSNPsToRealSNPs("D:\\UMCG\\SAT-VAT-Liver-Muscle-ImputeTriTyper\\", "Imputed_1", "D:\\UMCG\\SAT-VAT-Liver-Muscle-ImputeTriTyper\\Liver\\LiverImputed100G\\", "Imputed");
    }

    public void run(String[] args) throws IOException {
        CompareImputedSNPsToRealSNPs c = new CompareImputedSNPsToRealSNPs("/Data/GeneticalGenomicsDatasets/RotterdamStudy/TriTyper773Samples-GenotypesQCedRotterdam/", "Unimputed", "/Data/GeneticalGenomicsDatasets/RotterdamStudy/MachImputed/TriTyperFixed/", "Imputed");
    }

    public CompareImputedSNPsToRealSNPs(String dataset1, String dataset1Name, String dataset2, String dataset2Name) throws IOException {
        int i;
        String[] snps;
        HashSet<String> testSnps;
        List<String> list;
        this.ggDataset1.load(dataset1);
        this.ggDataset2 = new TriTyperGenotypeData();
        this.ggDataset2.load(dataset2);
        ArrayList<String> snpsTmp = new ArrayList<String>();
        if (this.ggDataset1.getSNPs().length < this.ggDataset2.getSNPs().length) {
            list = Arrays.asList(this.ggDataset2.getSNPs());
            testSnps = new HashSet<String>(list);
            list = null;
            snps = this.ggDataset1.getSNPs();
            for (i = 0; i < snps.length; ++i) {
                if (!testSnps.contains(snps[i])) continue;
                snpsTmp.add(snps[i]);
            }
            testSnps = null;
        } else {
            list = Arrays.asList(this.ggDataset1.getSNPs());
            testSnps = new HashSet<String>(list);
            list = null;
            snps = this.ggDataset2.getSNPs();
            for (i = 0; i < snps.length; ++i) {
                if (!testSnps.contains(snps[i])) continue;
                snpsTmp.add(snps[i]);
            }
            testSnps = null;
        }
        System.out.println("Numer of snps shared: " + snpsTmp.size());
        String[] snps2 = snpsTmp.toArray(new String[snpsTmp.size()]);
        snpsTmp = null;
        String[] ind1 = this.ggDataset1.getIndividuals();
        int[] ids1 = new int[ind1.length];
        for (i = 0; i < ids1.length; ++i) {
            String name1 = ind1[i];
            Integer id2 = this.ggDataset2.getIndividualId(name1);
            ids1[i] = id2 != null ? id2 : -1;
        }
        long numTotalConcordant = 0L;
        long numTotalCalled = 0L;
        ArrayDoubleList maf1 = new ArrayDoubleList();
        ArrayDoubleList maf2 = new ArrayDoubleList();
        ArrayDoubleList hwep1 = new ArrayDoubleList();
        ArrayDoubleList hwep2 = new ArrayDoubleList();
        int q = 0;
        boolean concordant = false;
        boolean called = false;
        int nrIncompatible = 0;
        int nrAT = 0;
        SNPLoader loader1 = this.ggDataset1.createSNPLoader();
        SNPLoader loader2 = this.ggDataset2.createSNPLoader();
        for (String snp : snps2) {
            Integer snp1Id = this.ggDataset1.getSnpToSNPId().get((Object)snp);
            Integer snp2Id = this.ggDataset2.getSnpToSNPId().get((Object)snp);
            if (snp1Id != null && snp2Id != null) {
                SNP snp1 = this.ggDataset1.getSNPObject(snp1Id.intValue());
                SNP snp2 = this.ggDataset2.getSNPObject(snp2Id.intValue());
                loader1.loadGenotypes(snp1);
                loader2.loadGenotypes(snp2);
                int[] genotype1 = new int[ids1.length];
                int[] genotype2 = new int[ids1.length];
                byte[] alleles1 = snp1.getAlleles();
                byte[] alleles2 = snp2.getAlleles();
                if (alleles1 != null && alleles2 != null) {
                    String str1allele1 = BaseAnnot.toString((byte)alleles1[0]);
                    String str1allele2 = BaseAnnot.toString((byte)alleles1[1]);
                    String str2allele1 = BaseAnnot.toString((byte)alleles2[0]);
                    String str2allele2 = BaseAnnot.toString((byte)alleles2[1]);
                    byte minor1 = snp1.getMinorAllele();
                    byte minor2 = snp2.getMinorAllele();
                    String strminor1 = BaseAnnot.toString((byte)minor1);
                    String strminor2 = BaseAnnot.toString((byte)minor2);
                    boolean atOrCG = false;
                    boolean inverted = false;
                    boolean incompatible = false;
                    if (BaseAnnot.getComplement((byte)alleles1[0]) == alleles1[1]) {
                        atOrCG = true;
                        ++nrAT;
                    } else if (alleles1[0] == alleles2[0] && alleles1[1] == alleles2[1]) {
                        inverted = false;
                    } else if (alleles1[0] == alleles2[1] && alleles1[1] == alleles2[0]) {
                        inverted = true;
                    } else if (BaseAnnot.getComplement((byte)alleles1[0]) == alleles2[0] && BaseAnnot.getComplement((byte)alleles1[1]) == alleles2[1]) {
                        inverted = false;
                    } else if (BaseAnnot.getComplement((byte)alleles1[0]) == alleles2[1] && BaseAnnot.getComplement((byte)alleles1[1]) == alleles2[0]) {
                        inverted = true;
                    } else {
                        incompatible = true;
                        ++nrIncompatible;
                    }
                    if (!atOrCG && !incompatible) {
                        for (int i2 = 0; i2 < ids1.length; ++i2) {
                            if (ids1[i2] == -1) continue;
                            genotype1[i2] = snp1.getGenotypes()[i2];
                            genotype2[i2] = snp2.getGenotypes()[ids1[i2]];
                            int gt1 = genotype1[i2];
                            int gt2 = genotype2[i2];
                            if (inverted) {
                                if (gt2 == 0) {
                                    gt2 = 2;
                                } else if (gt2 == 2) {
                                    gt2 = 0;
                                }
                            }
                            if (gt1 == -1 || gt2 == -1) continue;
                            if (gt2 == gt1) {
                                ++numTotalConcordant;
                            }
                            ++numTotalCalled;
                        }
                    }
                    if (!Double.isNaN(snp1.getMAF()) && !Double.isNaN(snp2.getMAF())) {
                        maf1.add(snp1.getMAF());
                        maf2.add(snp2.getMAF());
                    }
                    hwep1.add(snp1.getHWEP());
                    hwep2.add(snp2.getHWEP());
                    snp1.clearGenotypes();
                    snp2.clearGenotypes();
                }
            }
            if (++q % 10000 != 0) continue;
            System.out.println(q + "snps parsed");
        }
        loader1.close();
        loader2.close();
        System.out.println("Total called: " + numTotalCalled + "\t" + numTotalConcordant + "\t" + (double)numTotalConcordant / (double)numTotalCalled + "\t" + nrIncompatible + "\t" + nrAT);
        System.out.println("Correlations between minor allel frequencies: " + ArrayMath.correlation((double[])maf1.toArray(), (double[])maf2.toArray()));
        System.out.println("Correlations between hwep " + ArrayMath.correlation((double[])hwep1.toArray(), (double[])hwep2.toArray()));
    }
}

