/*
 * Decompiled with CFR 0.152.
 */
package imputationtool.postprocessing;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.stats.WilcoxonMannWhitney;

public class BeagleImputationQuality {
    private static Pattern tab = Pattern.compile("\t");

    private String[] getBatches(int numBatches) {
        String[] batches = new String[numBatches];
        String[] alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String firstletter = "a";
        int alphacounter = 0;
        int betacounter = 0;
        for (int i = 0; i < numBatches; ++i) {
            if (i % 26 == 0) {
                firstletter = alphabet[alphacounter];
                ++alphacounter;
                betacounter = 0;
            }
            batches[i] = firstletter + alphabet[betacounter];
            ++betacounter;
        }
        return batches;
    }

    public void determineImputationQualityDistribution(String inputDir, String template, int numBatches, String outputLocation) throws IOException {
        String[] batchNames = this.getBatches(numBatches);
        int nrBatches = batchNames.length;
        int chrStart = 1;
        int chrEnd = 22;
        TextFile logGlobal = new TextFile(outputLocation + "/r2-distribution-global.txt", true);
        int[] r2globalfreqdistribution = new int[11];
        boolean allFilesAvailable = true;
        int filesnotfound = 0;
        for (int batch = 0; batch < nrBatches; ++batch) {
            boolean nrSamplesThisBatch = false;
            for (int chr = chrStart; chr <= chrEnd; ++chr) {
                String templatecopy = new String(template);
                templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                String fileName = inputDir + "/" + templatecopy + ".r2";
                File file = new File(fileName);
                if (file.canRead()) continue;
                System.out.println("Cannot open file:\t" + fileName);
                allFilesAvailable = false;
                ++filesnotfound;
            }
        }
        if (!allFilesAvailable) {
            System.out.println("Not all imputed dosage files are available!!! (" + filesnotfound + " out of " + nrBatches * 22 + "). Exiting...");
            System.exit(-1);
        }
        int numsnpsglobal = 0;
        for (int chr = 1; chr < 23; ++chr) {
            int i;
            int binNumber;
            double absCor;
            double correlation;
            String ln;
            TextFile reader;
            String fileName;
            String templatecopy;
            int[] r2batchfreqdistribution;
            int numsnpsbatch;
            TextFile logChr = new TextFile(outputLocation + "/r2-distribution-" + chr + ".txt", true);
            TextFile logWilChr = new TextFile(outputLocation + "/wilcoxon-" + chr + ".txt", true);
            int numsnpschr = 0;
            int[] r2chrfreqdistribution = new int[11];
            for (int batch = 0; batch < batchNames.length; ++batch) {
                TextFile logBatch = new TextFile(outputLocation + "/r2-distribution-" + chr + "-" + batchNames[batch] + ".txt", true);
                numsnpsbatch = 0;
                r2batchfreqdistribution = new int[11];
                templatecopy = new String(template);
                templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                fileName = inputDir + "/" + templatecopy + ".r2";
                reader = new TextFile(fileName, false);
                ln = "";
                while ((ln = reader.readLine()) != null) {
                    String[] elems = tab.split(ln);
                    if (elems.length != 2) continue;
                    correlation = Double.parseDouble(elems[1]);
                    absCor = Math.abs(correlation);
                    binNumber = (int)(absCor * 10.0);
                    if (Double.isNaN(absCor)) {
                        binNumber = 0;
                    }
                    int n = binNumber;
                    r2globalfreqdistribution[n] = r2globalfreqdistribution[n] + 1;
                    int n2 = binNumber;
                    r2chrfreqdistribution[n2] = r2chrfreqdistribution[n2] + 1;
                    int n3 = binNumber;
                    r2batchfreqdistribution[n3] = r2batchfreqdistribution[n3] + 1;
                    ++numsnpsglobal;
                    ++numsnpschr;
                    ++numsnpsbatch;
                }
                reader.close();
                System.out.println("Chr" + chr + "-" + batchNames[batch]);
                for (int i2 = 0; i2 < r2batchfreqdistribution.length; ++i2) {
                    logBatch.writeln((double)i2 / 10.0 + "\t" + (double)r2batchfreqdistribution[i2] / (double)numsnpsbatch);
                }
                System.out.println("");
                logBatch.close();
            }
            double[] r2chrfreqdistribution_d = new double[11];
            for (i = 0; i < 11; ++i) {
                r2chrfreqdistribution_d[i] = (double)r2chrfreqdistribution[i] / (double)numsnpschr;
            }
            for (int batch = 0; batch < batchNames.length; ++batch) {
                numsnpsbatch = 0;
                r2batchfreqdistribution = new int[11];
                templatecopy = new String(template);
                templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                fileName = inputDir + "/" + templatecopy + ".r2";
                reader = new TextFile(fileName, false);
                ln = "";
                while ((ln = reader.readLine()) != null) {
                    String[] elems = tab.split(ln);
                    if (elems.length != 2) continue;
                    correlation = Double.parseDouble(elems[1]);
                    absCor = Math.abs(correlation);
                    int n = binNumber = (int)(absCor * 10.0);
                    r2batchfreqdistribution[n] = r2batchfreqdistribution[n] + 1;
                    ++numsnpsbatch;
                }
                reader.close();
                double[] r2batchfreqdistribution_d = new double[11];
                for (int i3 = 0; i3 < 11; ++i3) {
                    r2batchfreqdistribution_d[i3] = (double)r2batchfreqdistribution[i3] / (double)numsnpsbatch;
                }
                double pvalue = this.wilCoxon(r2batchfreqdistribution_d, r2chrfreqdistribution_d);
                logWilChr.writeln("Chr" + chr + "-" + batchNames[batch] + "\t" + pvalue);
            }
            System.out.println("Chr" + chr);
            for (i = 0; i < r2chrfreqdistribution.length; ++i) {
                logChr.writeln((double)i / 10.0 + "\t" + (double)r2chrfreqdistribution[i] / (double)numsnpschr);
            }
            System.out.println("");
            logWilChr.close();
            logChr.close();
        }
        System.out.println("Global:");
        for (int i = 0; i < r2globalfreqdistribution.length; ++i) {
            logGlobal.writeln((double)i / 10.0 + "\t" + (double)r2globalfreqdistribution[i] / (double)numsnpsglobal);
        }
        System.out.println("");
        logGlobal.close();
    }

    private double wilCoxon(double[] vals1, double[] vals2) {
        WilcoxonMannWhitney wmw = new WilcoxonMannWhitney();
        double pValue = wmw.returnWilcoxonMannWhitneyPValue(vals1, vals2);
        return pValue;
    }
}

