/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.meta;

import java.util.Map;
import org.molgenis.vcf.meta.VcfMetaEntry;

public class VcfMetaInfo
extends VcfMetaEntry {
    private static final String KEY_ID = "ID";
    private static final String KEY_NUMBER = "Number";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_DESCRIPTION = "Description";
    private static final String KEY_SOURCE = "Source";
    private static final String KEY_VERSION = "Version";

    public VcfMetaInfo(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public String getName() {
        return "INFO";
    }

    public String getId() {
        return (String)this.properties.get(KEY_ID);
    }

    public String getNumber() {
        return (String)this.properties.get(KEY_NUMBER);
    }

    public Type getType() {
        return Type.from((String)this.properties.get(KEY_TYPE));
    }

    public String getDescription() {
        return (String)this.properties.get(KEY_DESCRIPTION);
    }

    public String getSource() {
        return (String)this.properties.get(KEY_SOURCE);
    }

    public String getVersion() {
        return (String)this.properties.get(KEY_VERSION);
    }

    public static enum Type {
        INTEGER("Integer"),
        FLOAT("Float"),
        FLAG("Flag"),
        CHARACTER("Character"),
        STRING("String");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public static Type from(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.type;
        }
    }
}

