/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.table;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.variant.GeneticVariant;

public class TableGenotypeWriter
implements GenotypeWriter {
    private final GenotypeData genotypeData;

    public TableGenotypeWriter(GenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    @Override
    public void write(String path) {
        try {
            BufferedWriter dosageWriter = new BufferedWriter(new FileWriter(path + ".dosages.txt"));
            BufferedWriter genotypeWriter = new BufferedWriter(new FileWriter(path + ".genotypes.txt"));
            for (String sample : this.genotypeData.getSampleNames()) {
                dosageWriter.append('\t');
                dosageWriter.append(sample);
                genotypeWriter.append('\t');
                genotypeWriter.append(sample);
            }
            genotypeWriter.append('\n');
            dosageWriter.append('\n');
            for (GeneticVariant variant : this.genotypeData) {
                dosageWriter.append(variant.getPrimaryVariantId());
                genotypeWriter.append(variant.getPrimaryVariantId());
                for (float dosage : variant.getSampleDosages()) {
                    dosageWriter.append('\t');
                    dosageWriter.append(String.valueOf(dosage));
                }
                Object object = variant.getSampleVariants().iterator();
                while (object.hasNext()) {
                    Alleles alleles = (Alleles)object.next();
                    genotypeWriter.append('\t');
                    boolean notFirst = false;
                    for (String allele : alleles.getAllelesAsString()) {
                        if (notFirst) {
                            genotypeWriter.append('/');
                        }
                        genotypeWriter.append(allele);
                        notFirst = true;
                    }
                }
                genotypeWriter.append('\n');
                dosageWriter.append('\n');
            }
            genotypeWriter.close();
            dosageWriter.close();
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error writing genotype tables: " + ex);
        }
    }
}

