/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.Positional;

public final class PositionalBufferedStream
extends InputStream
implements Positional {
    final InputStream is;
    final byte[] buffer;
    int nextChar;
    int nChars;
    long position;

    public PositionalBufferedStream(InputStream inputStream) {
        this(inputStream, 512000);
    }

    public PositionalBufferedStream(InputStream inputStream, int n) {
        this.is = inputStream;
        this.buffer = new byte[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public final int read() throws IOException {
        int n = this.peek();
        if (n >= 0) {
            ++this.position;
            ++this.nextChar;
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (this.nChars < 0) {
            return -1;
        }
        int n4 = 0;
        for (int i = n2; i > 0 && (this.nChars != this.nextChar || this.fill() >= 0); i -= n3) {
            n3 = Math.min(this.nChars - this.nextChar, i);
            System.arraycopy(this.buffer, this.nextChar, byArray, n + n4, n3);
            this.nextChar += n3;
            n4 += n3;
        }
        this.position += (long)n4;
        return n4;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final boolean isDone() throws IOException {
        return this.nChars == -1 || this.peek() == -1;
    }

    @Override
    public final int peek() throws IOException {
        if (this.nChars < 0) {
            return -1;
        }
        if (this.nextChar == this.nChars && this.fill() < 0) {
            return -1;
        }
        return PositionalBufferedStream.byteToInt(this.buffer[this.nextChar]);
    }

    private final int fill() throws IOException {
        this.nChars = this.is.read(this.buffer);
        this.nextChar = 0;
        return this.nChars;
    }

    @Override
    public final long skip(long l) throws IOException {
        long l2;
        long l3 = l;
        while (l3 > 0L && !this.isDone()) {
            l2 = this.nChars - this.nextChar;
            if (l3 > l2) {
                l3 -= l2;
                this.fill();
                continue;
            }
            this.nextChar = (int)((long)this.nextChar + l3);
            l3 = 0L;
        }
        l2 = l - l3;
        this.position += l2;
        return l2;
    }

    @Override
    public final void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            new TribbleException("Failed to close PositionalBufferedStream", iOException);
        }
    }

    private static final int byteToInt(byte by) {
        return by & 0xFF;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        int n = Integer.valueOf(stringArray[1]);
        boolean bl = Boolean.valueOf(stringArray[2]);
        boolean bl2 = Boolean.valueOf(stringArray[3]);
        System.out.printf("Testing %s%n", stringArray[0]);
        for (int i = 0; i < n; ++i) {
            InputStream inputStream;
            if (bl) {
                inputStream = new FileInputStream(file);
                if (bl2) {
                    PositionalBufferedStream.readFileInChunks("InputStream", inputStream);
                } else {
                    PositionalBufferedStream.readFileByLine("InputStream", inputStream);
                }
                inputStream.close();
            }
            inputStream = new PositionalBufferedStream(new FileInputStream(file));
            if (bl2) {
                PositionalBufferedStream.readFileInChunks("PositionalBufferedStream", inputStream);
            } else {
                PositionalBufferedStream.readFileByLine("PositionalBufferedStream", inputStream);
            }
            ((PositionalBufferedStream)inputStream).close();
        }
    }

    private static void readFileByLine(String string, InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (bufferedReader.readLine() != null) {
            ++l2;
        }
        long l3 = System.currentTimeMillis() - l;
        double d = (double)l2 / (double)l3;
        PositionalBufferedStream.printStatus(string, l2, d, l3);
        bufferedReader.close();
    }

    private static void readFileInChunks(String string, InputStream inputStream) throws IOException {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        byte[] byArray = new byte[4096];
        while (inputStream.read(byArray) != -1) {
            ++l2;
        }
        long l3 = System.currentTimeMillis() - l;
        double d = (double)l2 / (double)l3;
        PositionalBufferedStream.printStatus(string, l2, d, l3);
        inputStream.close();
    }

    private static final void printStatus(String string, long l, double d, long l2) {
        System.out.printf("%30s: %d lines read.  Rate = %.2e lines per second.  DT = %d%n", string, l, d, l2);
        System.out.flush();
    }
}

