/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.readers.TabixIteratorLineReader;
import org.broad.tribble.readers.TabixReader;
import org.broad.tribble.util.ParsingUtils;

public class TabixFeatureReader
extends AbstractFeatureReader {
    TabixReader tabixReader;
    List<String> sequenceNames;

    public TabixFeatureReader(String string, AsciiFeatureCodec asciiFeatureCodec) throws IOException {
        super(string, asciiFeatureCodec);
        this.tabixReader = new TabixReader(string);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.mChr2tid.keySet());
        this.readHeader();
    }

    private void readHeader() throws IOException {
        PositionalBufferedStream positionalBufferedStream = null;
        try {
            positionalBufferedStream = new PositionalBufferedStream(new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path)));
            this.header = this.codec.readHeader(positionalBufferedStream);
        }
        catch (Exception exception) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + exception.getMessage(), this.path, exception);
        }
        finally {
            if (positionalBufferedStream != null) {
                positionalBufferedStream.close();
            }
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public CloseableTribbleIterator query(String string, int n, int n2) throws IOException {
        List<String> list = this.getSequenceNames();
        if (list == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find sequence named " + string + " in the tabix index. ", this.path);
        }
        if (!list.contains(string)) {
            return new AbstractFeatureReader.EmptyIterator();
        }
        TabixIteratorLineReader tabixIteratorLineReader = new TabixIteratorLineReader(this.tabixReader.query(this.tabixReader.mChr2tid.get(string), n - 1, n2));
        return new FeatureIterator(tabixIteratorLineReader, n - 1, n2);
    }

    @Override
    public CloseableTribbleIterator iterator() throws IOException {
        BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path));
        PositionalBufferedStream positionalBufferedStream = new PositionalBufferedStream(blockCompressedInputStream);
        AsciiLineReader asciiLineReader = new AsciiLineReader(positionalBufferedStream);
        return new FeatureIterator(asciiLineReader, 0, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
    }

    class FeatureIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private T currentRecord;
        private LineReader lineReader;
        private int start;
        private int end;

        public FeatureIterator(LineReader lineReader, int n, int n2) throws IOException {
            this.lineReader = lineReader;
            this.start = n;
            this.end = n2;
            this.readNextRecord();
        }

        protected void readNextRecord() throws IOException {
            String string;
            this.currentRecord = null;
            while (this.currentRecord == null && (string = this.lineReader.readLine()) != null) {
                Feature feature = null;
                try {
                    feature = (Feature)((AsciiFeatureCodec)TabixFeatureReader.this.codec).decode(string);
                    if (feature == null) continue;
                    if (feature.getStart() > this.end) {
                        return;
                    }
                    if (feature.getEnd() <= this.start) continue;
                    this.currentRecord = feature;
                }
                catch (TribbleException tribbleException) {
                    tribbleException.setSource(TabixFeatureReader.this.path);
                    throw tribbleException;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "Error parsing line: " + string;
                    throw new TribbleException.MalformedFeatureFile(string2, TabixFeatureReader.this.path, numberFormatException);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.lineReader.close();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

