/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.EnumSet;
import java.util.zip.GZIPOutputStream;
import net.sf.picard.PicardException;
import net.sf.samtools.Defaults;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;

public final class VariantContextUtils {
    public static VariantContextWriter getConditionallyCompressingWriter(File file, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return file.getName().endsWith(".gz") ? VariantContextUtils.getCompressingWriter(file, sAMSequenceDictionary, enumSet) : VariantContextWriterFactory.create(file, sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter getCompressingWriter(File file, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file)){
                {
                    this.def.setLevel(Defaults.COMPRESSION_LEVEL);
                }
            };
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
            return VariantContextWriterFactory.create(file, bufferedOutputStream, sAMSequenceDictionary, enumSet);
        }
        catch (Exception exception) {
            throw new PicardException("Could not create a compressed output stream for the VCF writer: " + exception.getMessage(), exception);
        }
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        return sAMFileReader.getFileHeader().getSequenceDictionary();
    }
}

