/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.RuntimeIOException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VariantContextIterator
implements CloseableIterator<VariantContext> {
    private final VCFCodec vcfCodec = new VCFCodec();
    private final VCFHeader vcfHeader;
    private final AsciiLineReader reader;
    private String line = null;

    public VariantContextIterator(File file) {
        this.reader = new AsciiLineReader(IoUtil.openFileForReading(file));
        Object object = this.vcfCodec.readHeader(this.reader);
        if (!(object instanceof VCFHeader)) {
            throw new IllegalArgumentException("The file " + file.getAbsolutePath() + " did not have a VCF header");
        }
        this.vcfHeader = (VCFHeader)object;
    }

    @Override
    public void close() {
        CloserUtil.close(this.reader);
    }

    public VCFHeader getHeader() {
        return this.vcfHeader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.line == null) {
                this.line = this.reader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        return this.line != null;
    }

    @Override
    public VariantContext next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Called next() on an exhausted VariantContextIterator");
        }
        String string = this.line;
        this.line = null;
        return this.vcfCodec.decode(string);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

