/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.util.CloseableIterator;

public class MergingIterator<T>
implements CloseableIterator<T> {
    private final PriorityQueue<ComparableIterator> queue;
    private final Comparator<T> comparator;
    private T lastReturned;

    public MergingIterator(Comparator<T> comparator, Collection<CloseableIterator<T>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("One or more CloseableIterators must be provided.");
        }
        this.comparator = comparator;
        this.queue = new PriorityQueue();
        for (CloseableIterator<T> closeableIterator : collection) {
            this.addIfNotEmpty(new ComparableIterator(closeableIterator));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ComparableIterator comparableIterator = this.queue.poll();
        Object Object2 = comparableIterator.next();
        if (this.lastReturned != null && this.comparator.compare(this.lastReturned, Object2) > 0) {
            throw new IllegalStateException("The elements of the input Iterators are not sorted according to the comparator " + this.comparator.getClass().getName());
        }
        this.addIfNotEmpty(comparableIterator);
        this.lastReturned = Object2;
        return (T)Object2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (ComparableIterator comparableIterator : this.queue) {
            comparableIterator.close();
            this.queue.remove(comparableIterator);
        }
    }

    private void addIfNotEmpty(ComparableIterator comparableIterator) {
        if (comparableIterator.hasNext()) {
            this.queue.offer(comparableIterator);
        } else {
            comparableIterator.close();
        }
    }

    private class ComparableIterator
    extends PeekableIterator<T>
    implements Comparable<ComparableIterator> {
        public ComparableIterator(Iterator<T> iterator) {
            super(iterator);
        }

        @Override
        public int compareTo(ComparableIterator comparableIterator) {
            if (MergingIterator.this.comparator.getClass() != MergingIterator.this.comparator.getClass()) {
                throw new IllegalStateException("Can't compare two ComparableIterators that have different orderings.");
            }
            return MergingIterator.this.comparator.compare(this.peek(), comparableIterator.peek());
        }
    }
}

