/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public abstract class SinglePassSamProgram
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="File to write the output to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence fasta", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public long STOP_AFTER = 0L;
    private static final Log log = Log.getInstance(SinglePassSamProgram.class);

    @Override
    protected final int doWork() {
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, Arrays.asList(this));
        return 0;
    }

    protected static void makeItSo(File file, File file2, boolean bl, long l, Collection<SinglePassSamProgram> collection) {
        ReferenceSequenceFileWalker referenceSequenceFileWalker;
        IoUtil.assertFileIsReadable(file);
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        if (file2 == null) {
            referenceSequenceFileWalker = null;
        } else {
            IoUtil.assertFileIsReadable(file2);
            referenceSequenceFileWalker = new ReferenceSequenceFileWalker(file2);
            if (!sAMFileReader.getFileHeader().getSequenceDictionary().isEmpty()) {
                SequenceUtil.assertSequenceDictionariesEqual(sAMFileReader.getFileHeader().getSequenceDictionary(), referenceSequenceFileWalker.getSequenceDictionary());
            }
        }
        SAMFileHeader.SortOrder sortOrder = sAMFileReader.getFileHeader().getSortOrder();
        if (sortOrder != SAMFileHeader.SortOrder.coordinate) {
            if (bl) {
                log.warn("File reports sort order '" + (Object)((Object)sortOrder) + "', assuming it's coordinate sorted anyway.");
            } else {
                throw new PicardException("File " + file.getAbsolutePath() + " should be coordinate sorted but " + "the header says the sort order is " + (Object)((Object)sortOrder) + ". If you believe the file " + "to be coordinate sorted you may pass ASSUME_SORTED=true");
            }
        }
        boolean bl2 = false;
        for (SinglePassSamProgram iterator : collection) {
            iterator.setup(sAMFileReader.getFileHeader(), file);
            bl2 = bl2 || iterator.usesNoRefReads();
        }
        ProgressLogger progressLogger = new ProgressLogger(log);
        for (SAMRecord sAMRecord : sAMFileReader) {
            ReferenceSequence referenceSequence = referenceSequenceFileWalker == null || sAMRecord.getReferenceIndex() == -1 ? null : referenceSequenceFileWalker.get(sAMRecord.getReferenceIndex());
            for (SinglePassSamProgram singlePassSamProgram : collection) {
                singlePassSamProgram.acceptRead(sAMRecord, referenceSequence);
            }
            progressLogger.record(sAMRecord);
            if ((l <= 0L || progressLogger.getCount() < l) && (bl2 || sAMRecord.getReferenceIndex() != -1)) continue;
            break;
        }
        sAMFileReader.close();
        for (SinglePassSamProgram singlePassSamProgram : collection) {
            singlePassSamProgram.finish();
        }
    }

    protected boolean usesNoRefReads() {
        return true;
    }

    protected abstract void setup(SAMFileHeader var1, File var2);

    protected abstract void acceptRead(SAMRecord var1, ReferenceSequence var2);

    protected abstract void finish();
}

