/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.AlignmentSummaryMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.metrics.SAMRecordAndReference;
import net.sf.picard.metrics.SAMRecordAndReferenceMultiLevelCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class AlignmentSummaryMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<AlignmentSummaryMetrics, Comparable<?>> {
    private final boolean doRefMetrics;
    private final byte[][] adapterKmers;
    private final List<String> adapterSequence;
    private final int maxInsertSize;
    private final boolean isBisulfiteSequenced;
    private final int MAPPING_QUALITY_THRESOLD = 20;
    private static final int BASE_QUALITY_THRESHOLD = 20;
    private static final int ADAPTER_MATCH_LENGTH = 16;
    private static final int MAX_ADAPTER_ERRORS = 1;

    public AlignmentSummaryMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, boolean bl, List<String> list2, int n, boolean bl2) {
        this.doRefMetrics = bl;
        this.adapterSequence = list2;
        this.adapterKmers = this.prepareAdapterSequences();
        this.maxInsertSize = n;
        this.isBisulfiteSequenced = bl2;
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> makeChildCollector(String string, String string2, String string3) {
        return new GroupAlignmentSummaryMetricsPerUnitMetricCollector(string, string2, string3);
    }

    @Override
    public void acceptRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (!sAMRecord.getNotPrimaryAlignmentFlag()) {
            super.acceptRecord(sAMRecord, referenceSequence);
        }
    }

    private byte[][] prepareAdapterSequences() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.adapterSequence) {
            for (int i = 0; i <= string.length() - 16; ++i) {
                String string2 = string.substring(i, i + 16).toUpperCase();
                int n = 0;
                for (char c : string2.toCharArray()) {
                    if (c != 'N') continue;
                    ++n;
                }
                if (n > true) continue;
                hashSet.add(string2);
                hashSet.add(SequenceUtil.reverseComplement(string2));
            }
        }
        Object object = new byte[hashSet.size()][];
        int n = 0;
        for (String string2 : hashSet) {
            object[n++] = StringUtil.stringToBytes(string2);
        }
        return object;
    }

    private boolean isAdapterSequence(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        for (byte[] byArray2 : this.adapterKmers) {
            int n = 0;
            for (int i = 0; i < byArray2.length && (byArray[i] == byArray2[i] || ++n <= 1); ++i) {
            }
            if (n > true) continue;
            return true;
        }
        return false;
    }

    private class GroupAlignmentSummaryMetricsPerUnitMetricCollector
    implements PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> {
        final IndividualAlignmentSummaryMetricsCollector unpairedCollector;
        final IndividualAlignmentSummaryMetricsCollector firstOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector secondOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector pairCollector;
        final String sample;
        final String library;
        final String readGroup;

        public GroupAlignmentSummaryMetricsPerUnitMetricCollector(String string, String string2, String string3) {
            this.sample = string;
            this.library = string2;
            this.readGroup = string3;
            this.unpairedCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.UNPAIRED, string, string2, string3);
            this.firstOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.FIRST_OF_PAIR, string, string2, string3);
            this.secondOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.SECOND_OF_PAIR, string, string2, string3);
            this.pairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.PAIR, string, string2, string3);
        }

        @Override
        public void acceptRecord(SAMRecordAndReference sAMRecordAndReference) {
            SAMRecord sAMRecord = sAMRecordAndReference.getSamRecord();
            ReferenceSequence referenceSequence = sAMRecordAndReference.getReferenceSequence();
            if (sAMRecord.getReadPairedFlag()) {
                if (sAMRecord.getFirstOfPairFlag()) {
                    this.firstOfPairCollector.addRecord(sAMRecord, referenceSequence);
                } else {
                    this.secondOfPairCollector.addRecord(sAMRecord, referenceSequence);
                }
                this.pairCollector.addRecord(sAMRecord, referenceSequence);
            } else {
                this.unpairedCollector.addRecord(sAMRecord, referenceSequence);
            }
        }

        @Override
        public void finish() {
            this.unpairedCollector.onComplete();
            this.firstOfPairCollector.onComplete();
            this.secondOfPairCollector.onComplete();
            this.pairCollector.onComplete();
        }

        @Override
        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Comparable<?>> metricsFile) {
            if (this.firstOfPairCollector.getMetrics().TOTAL_READS > 0L) {
                this.pairCollector.getMetrics().BAD_CYCLES = this.firstOfPairCollector.getMetrics().BAD_CYCLES + this.secondOfPairCollector.getMetrics().BAD_CYCLES;
                metricsFile.addMetric(this.firstOfPairCollector.getMetrics());
                metricsFile.addMetric(this.secondOfPairCollector.getMetrics());
                metricsFile.addMetric(this.pairCollector.getMetrics());
            }
            if (this.unpairedCollector.getMetrics().TOTAL_READS > 0L || this.firstOfPairCollector.getMetrics().TOTAL_READS == 0L) {
                metricsFile.addMetric(this.unpairedCollector.getMetrics());
            }
        }

        private class IndividualAlignmentSummaryMetricsCollector {
            private long numPositiveStrand = 0L;
            private final Histogram<Integer> readLengthHistogram = new Histogram();
            private AlignmentSummaryMetrics metrics;
            private long chimeras;
            private long chimerasDenominator;
            private long adapterReads;
            private long indels;
            private long nonBisulfiteAlignedBases = 0L;
            private long hqNonBisulfiteAlignedBases = 0L;
            private final Histogram<Long> mismatchHistogram = new Histogram();
            private final Histogram<Long> hqMismatchHistogram = new Histogram();
            private final Histogram<Integer> badCycleHistogram = new Histogram();

            public IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category category, String string, String string2, String string3) {
                this.metrics = new AlignmentSummaryMetrics();
                this.metrics.CATEGORY = category;
                this.metrics.SAMPLE = string;
                this.metrics.LIBRARY = string2;
                this.metrics.READ_GROUP = string3;
            }

            public void addRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
                if (sAMRecord.getNotPrimaryAlignmentFlag()) {
                    return;
                }
                this.collectReadData(sAMRecord, referenceSequence);
                this.collectQualityData(sAMRecord, referenceSequence);
            }

            public void onComplete() {
                if (this.metrics.TOTAL_READS > 0L) {
                    this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
                    this.metrics.PCT_ADAPTER = (double)this.adapterReads / (double)this.metrics.PF_READS;
                    this.metrics.MEAN_READ_LENGTH = this.readLengthHistogram.getMean();
                    this.metrics.BAD_CYCLES = 0L;
                    for (Histogram.Bin bin : this.badCycleHistogram.values()) {
                        double d = bin.getValue() / (double)this.metrics.TOTAL_READS;
                        if (!(d >= 0.8)) continue;
                        ++this.metrics.BAD_CYCLES;
                    }
                    if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        if (this.metrics.PF_READS > 0L) {
                            this.metrics.PCT_PF_READS_ALIGNED = (double)this.metrics.PF_READS_ALIGNED / (double)this.metrics.PF_READS;
                        }
                        if (this.metrics.PF_READS_ALIGNED > 0L) {
                            this.metrics.PCT_READS_ALIGNED_IN_PAIRS = (double)this.metrics.READS_ALIGNED_IN_PAIRS / (double)this.metrics.PF_READS_ALIGNED;
                        }
                        if (this.metrics.PF_READS_ALIGNED > 0L) {
                            this.metrics.STRAND_BALANCE = (double)this.numPositiveStrand / (double)this.metrics.PF_READS_ALIGNED;
                        }
                        if (this.chimerasDenominator > 0L) {
                            this.metrics.PCT_CHIMERAS = (double)this.chimeras / (double)this.chimerasDenominator;
                        }
                        if (this.nonBisulfiteAlignedBases > 0L) {
                            this.metrics.PF_MISMATCH_RATE = this.mismatchHistogram.getSum() / (double)this.nonBisulfiteAlignedBases;
                        }
                        this.metrics.PF_HQ_MEDIAN_MISMATCHES = this.hqMismatchHistogram.getMedian();
                        if (this.hqNonBisulfiteAlignedBases > 0L) {
                            this.metrics.PF_HQ_ERROR_RATE = this.hqMismatchHistogram.getSum() / (double)this.hqNonBisulfiteAlignedBases;
                        }
                        if (this.metrics.PF_ALIGNED_BASES > 0L) {
                            this.metrics.PF_INDEL_RATE = (double)this.indels / (double)this.metrics.PF_ALIGNED_BASES;
                        }
                    }
                }
            }

            private void collectReadData(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
                ++this.metrics.TOTAL_READS;
                this.readLengthHistogram.increment(sAMRecord.getReadBases().length);
                if (!sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                    ++this.metrics.PF_READS;
                    if (this.isNoiseRead(sAMRecord)) {
                        ++this.metrics.PF_NOISE_READS;
                    }
                    if (sAMRecord.getReadUnmappedFlag()) {
                        byte[] byArray = sAMRecord.getReadBases();
                        if (!(sAMRecord instanceof BAMRecord)) {
                            StringUtil.toUpperCase(byArray);
                        }
                        if (AlignmentSummaryMetricsCollector.this.isAdapterSequence(byArray)) {
                            ++this.adapterReads;
                        }
                    } else if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        ++this.metrics.PF_READS_ALIGNED;
                        if (!sAMRecord.getReadNegativeStrandFlag()) {
                            ++this.numPositiveStrand;
                        }
                        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                            ++this.metrics.READS_ALIGNED_IN_PAIRS;
                            Integer n = sAMRecord.getIntegerAttribute("MQ");
                            if (n == null || n >= 20 && sAMRecord.getMappingQuality() >= 20) {
                                ++this.chimerasDenominator;
                                if (Math.abs(sAMRecord.getInferredInsertSize()) > AlignmentSummaryMetricsCollector.this.maxInsertSize || !sAMRecord.getReferenceIndex().equals(sAMRecord.getMateReferenceIndex())) {
                                    ++this.chimeras;
                                }
                            }
                        }
                    }
                }
            }

            private void collectQualityData(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
                block13: {
                    block12: {
                        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord.getReadFailsVendorQualityCheckFlag() && AlignmentSummaryMetricsCollector.this.doRefMetrics) break block12;
                        byte[] byArray = sAMRecord.getReadBases();
                        for (int i = 0; i < byArray.length; ++i) {
                            if (!SequenceUtil.isNoCall(byArray[i])) continue;
                            this.badCycleHistogram.increment(CoordMath.getCycle(sAMRecord.getReadNegativeStrandFlag(), byArray.length, i));
                        }
                        break block13;
                    }
                    if (sAMRecord.getReadFailsVendorQualityCheckFlag()) break block13;
                    boolean bl = this.isHighQualityMapping(sAMRecord);
                    if (bl) {
                        ++this.metrics.PF_HQ_ALIGNED_READS;
                    }
                    byte[] byArray = sAMRecord.getReadBases();
                    byte[] byArray2 = referenceSequence.getBases();
                    byte[] byArray3 = sAMRecord.getBaseQualities();
                    int n = byArray2.length;
                    long l = 0L;
                    long l2 = 0L;
                    for (AlignmentBlock object : sAMRecord.getAlignmentBlocks()) {
                        int n2 = object.getReadStart() - 1;
                        int n3 = object.getReferenceStart() - 1;
                        int n4 = object.getLength();
                        for (int i = 0; i < n4 && n3 + i < n; ++i) {
                            int n5 = n2 + i;
                            boolean bl2 = !SequenceUtil.basesEqual(byArray[n5], byArray2[n3 + i]);
                            boolean bl3 = false;
                            if (bl2 && AlignmentSummaryMetricsCollector.this.isBisulfiteSequenced && (sAMRecord.getReadNegativeStrandFlag() && (byArray2[n3 + i] == 71 || byArray2[n3 + i] == 103) && (byArray[n5] == 65 || byArray[n5] == 97) || !sAMRecord.getReadNegativeStrandFlag() && (byArray2[n3 + i] == 67 || byArray2[n3 + i] == 99) && byArray[n5] == 84 || byArray[n5] == 116)) {
                                bl3 = true;
                                bl2 = false;
                            }
                            if (bl2) {
                                ++l;
                            }
                            ++this.metrics.PF_ALIGNED_BASES;
                            if (!bl3) {
                                ++this.nonBisulfiteAlignedBases;
                            }
                            if (bl) {
                                ++this.metrics.PF_HQ_ALIGNED_BASES;
                                if (!bl3) {
                                    ++this.hqNonBisulfiteAlignedBases;
                                }
                                if (byArray3[n5] >= 20) {
                                    ++this.metrics.PF_HQ_ALIGNED_Q20_BASES;
                                }
                                if (bl2) {
                                    ++l2;
                                }
                            }
                            if (!bl2 && !SequenceUtil.isNoCall(byArray[n5])) continue;
                            this.badCycleHistogram.increment(CoordMath.getCycle(sAMRecord.getReadNegativeStrandFlag(), byArray.length, i));
                        }
                    }
                    this.mismatchHistogram.increment(l);
                    this.hqMismatchHistogram.increment(l2);
                    for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                        CigarOperator cigarOperator = cigarElement.getOperator();
                        if (cigarOperator != CigarOperator.INSERTION && cigarOperator != CigarOperator.DELETION) continue;
                        ++this.indels;
                    }
                }
            }

            private boolean isNoiseRead(SAMRecord sAMRecord) {
                Object object = sAMRecord.getAttribute("XN");
                return object != null && object.equals(1);
            }

            private boolean isHighQualityMapping(SAMRecord sAMRecord) {
                return !sAMRecord.getReadFailsVendorQualityCheckFlag() && sAMRecord.getMappingQuality() >= 20;
            }

            public AlignmentSummaryMetrics getMetrics() {
                return this.metrics;
            }
        }
    }
}

