/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.filters;

import nl.tudelft.simulation.language.filters.AbstractFilter;

public class SnippetFilter
extends AbstractFilter {
    private double snippet = Double.NaN;
    private double lastAcceptedXValue = -1.7976931348623157E308;

    public SnippetFilter(double snippet) {
        if (snippet <= 0.0) {
            throw new IllegalArgumentException("snippet should be >0.0");
        }
        this.snippet = snippet;
    }

    public boolean filter(Object entry) {
        if (!(entry instanceof double[]) || ((double[])entry).length != 2) {
            throw new IllegalArgumentException("entry should be instance of double[2] representing x,y");
        }
        double[] value = (double[])entry;
        if (value[0] - this.lastAcceptedXValue >= this.snippet) {
            this.lastAcceptedXValue = value[0];
            return true;
        }
        return false;
    }

    public String getCriterium() {
        return "accepts one entry per " + this.snippet + " xRange value";
    }
}

