/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.util;

import JSci.maths.ArrayMath;
import cern.jet.random.tdouble.StudentT;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import eqtlmappingpipeline.binarymeta.meta.graphics.ZScorePlot;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.BaseAnnot;

public class eQTLFileCompare {
    private static Pattern SPLIT_ON_TAB = Pattern.compile("\\t");
    private static Pattern SEMI_COLON_PATTERN = Pattern.compile(";");
    private int nrShared = 0;
    private int nrOpposite = 0;

    public int getNrShared() {
        return this.nrShared;
    }

    public int getNrOpposite() {
        return this.nrOpposite;
    }

    public eQTLFileCompare() {
    }

    public eQTLFileCompare(String[] args) {
        String out = null;
        String file1 = null;
        String file2 = null;
        boolean matchOnGeneName = false;
        boolean matchSnpOnPos = false;
        boolean splitGeneNames = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String val = null;
            if (i + 1 < args.length) {
                val = args[i + 1];
            }
            if (arg.equals("--out")) {
                out = val;
                continue;
            }
            if (arg.equals("--file1")) {
                file1 = val;
                continue;
            }
            if (arg.equals("--file2")) {
                file2 = val;
                continue;
            }
            if (arg.equals("--genebased")) {
                matchOnGeneName = true;
                System.out.println("Performing gene based analysis");
                continue;
            }
            if (arg.toLowerCase().equals("--matchsnponpos")) {
                matchSnpOnPos = true;
                System.out.println("Matching snp based on position");
                continue;
            }
            if (!arg.toLowerCase().equals("--splitgenenames")) continue;
            splitGeneNames = true;
            System.out.println("Splitting gene names on ;");
        }
        if (out != null && file1 != null && file2 != null) {
            try {
                this.compareOverlapAndZScoreDirectionTwoEQTLFiles(file1, file2, out, matchOnGeneName, matchSnpOnPos, splitGeneNames);
            }
            catch (IOException ex) {
                Logger.getLogger(eQTLFileCompare.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(eQTLFileCompare.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.printUsage();
        }
    }

    private void printUsage() {
        System.out.print("QTL File comparison\n-------------------------------------------------------------------------------\n");
        System.out.println("Compares two eQTL files with each other.");
        System.out.print("Command line options:\n-------------------------------------------------------------------------------\n");
        System.out.println("--out\t\tstring\t\tOutput file name\n--file1\t\tstring\t\tLocation of file 1\n--file2\t\tstring\t\tLocation of file 2\n--genebased\t\t\tPerform comparison on the basis of gene names (optional, defaults to probe based comparison)\n--matchSnpOnPos\t\tUse chr and and chr pos to match SNPs and ignore identifiers\n--splitGeneNames\t\tSplit gene names on ; when doing --genebased. Count as 2 effects (beta)");
    }

    public final void compareOverlapAndZScoreDirectionTwoEQTLFiles(String file1, String file2, String outputFile, boolean matchOnGeneName) throws IOException, Exception {
        this.compareOverlapAndZScoreDirectionTwoEQTLFiles(file1, file2, outputFile, matchOnGeneName, false, false);
    }

    public final void compareOverlapAndZScoreDirectionTwoEQTLFiles(String file1, String file2, String outputFile, boolean matchOnGeneName, boolean matchSnpOnPos, boolean splitGeneNames) throws IOException, Exception {
        int margin;
        double filterOnFDR = -1.0;
        HashMap hashConvertProbeNames = new HashMap();
        HashSet hashExcludeEQTLs = new HashSet();
        HashSet hashConfineAnalysisToSubsetOfProbes = new HashSet();
        HashSet hashTestedSNPsThatPassedQC = null;
        THashMap hashEQTLs = new THashMap();
        THashSet hashUniqueProbes = new THashSet();
        THashSet hashUniqueGenes = new THashSet();
        TextFile log = new TextFile(outputFile + "-eQTLComparisonLog.txt", true);
        TextFile in = new TextFile(file1, false);
        in.readLine();
        String[] data = in.readLineElemsReturnReference(SPLIT_ON_TAB);
        if (data.length < 5) {
            throw new IllegalStateException("QTL File does not have enough columns. Detected columns: " + data.length + " in file " + in.getFileName());
        }
        while (data != null) {
            if (hashConvertProbeNames.size() > 0 && hashConvertProbeNames.containsKey(data[4].trim())) {
                data[4] = (String)hashConvertProbeNames.get(data[4].trim());
            }
            if ((filterOnFDR == -1.0 || Double.parseDouble(data[18]) <= filterOnFDR) && (hashConfineAnalysisToSubsetOfProbes.isEmpty() || hashConfineAnalysisToSubsetOfProbes.contains(data[4]))) {
                if (matchOnGeneName) {
                    if (data[16].length() > 1) {
                        if (splitGeneNames) {
                            for (String gene : SEMI_COLON_PATTERN.split(data[16])) {
                                hashEQTLs.put((Object)((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + gene), (Object)data);
                                hashUniqueProbes.add((Object)data[4]);
                                hashUniqueGenes.add((Object)gene);
                            }
                        } else if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[16])) {
                            hashEQTLs.put((Object)((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[16]), (Object)data);
                            hashUniqueProbes.add((Object)data[4]);
                            hashUniqueGenes.add((Object)data[16]);
                        }
                    }
                } else if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[4])) {
                    hashEQTLs.put((Object)((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[4]), (Object)data);
                    hashUniqueProbes.add((Object)data[4]);
                    hashUniqueGenes.add((Object)data[16]);
                }
            }
            data = in.readLineElemsReturnReference(SPLIT_ON_TAB);
        }
        in.close();
        int nrUniqueProbes = hashUniqueProbes.size();
        int nrUniqueGenes = hashUniqueGenes.size();
        hashUniqueProbes = null;
        hashUniqueGenes = null;
        int width = 1000;
        int height = 1000;
        int x0 = margin = 100;
        int x1 = width - margin;
        int y0 = margin;
        int y1 = height - margin;
        ZScorePlot zs = new ZScorePlot();
        String zsOutFileName = outputFile + "-ZScoreComparison.pdf";
        zs.init(2, new String[]{"Dataset1", "Dataset2"}, true, zsOutFileName);
        int nreQTLsIdenticalDirection = 0;
        int nreQTLsOppositeDirection = 0;
        HashMap<String, Integer> hashEQTLNrTimesAssessed = new HashMap<String, Integer>();
        ArrayList<String> vecEQTLNrTimesAssessed = new ArrayList<String>();
        HashMap<String, String[]> hashEQTLs2 = new HashMap<String, String[]>();
        HashSet<String> hashUniqueProbes2 = new HashSet<String>();
        HashSet<String> hashUniqueGenes2 = new HashSet<String>();
        HashSet<String> hashUniqueProbesOverlap = new HashSet<String>();
        HashSet<String> hashUniqueGenesOverlap = new HashSet<String>();
        int counterFile2 = 0;
        int overlap = 0;
        ArrayList<Double> vecX = new ArrayList<Double>();
        ArrayList<Double> vecY = new ArrayList<Double>();
        LinkedHashSet<String> vecOppositeEQTLs = new LinkedHashSet<String>();
        in = new TextFile(file2, false);
        in.readLine();
        int lineno = 1;
        data = null;
        TextFile identicalOut = new TextFile(outputFile + "-eQTLsWithIdenticalDirecton.txt.gz", true);
        while ((data = in.readLineElemsReturnReference(SPLIT_ON_TAB)) != null) {
            if (filterOnFDR == -1.0 || Double.parseDouble(data[18]) <= filterOnFDR) {
                if (hashConvertProbeNames.size() > 0 && hashConvertProbeNames.containsKey(data[4].trim())) {
                    data[4] = (String)hashConvertProbeNames.get(data[4].trim());
                }
                if (hashConfineAnalysisToSubsetOfProbes.isEmpty() || hashConfineAnalysisToSubsetOfProbes.contains(data[4])) {
                    if (matchOnGeneName) {
                        if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[16]) && data[16].length() > 1) {
                            if (splitGeneNames) {
                                for (String gene : SEMI_COLON_PATTERN.split(data[16])) {
                                    hashUniqueProbes2.add(data[4]);
                                    hashUniqueGenes2.add(gene);
                                    if (hashEQTLs2.containsKey((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + gene)) continue;
                                    hashEQTLs2.put((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + gene, data);
                                    ++counterFile2;
                                }
                            } else {
                                hashUniqueProbes2.add(data[4]);
                                hashUniqueGenes2.add(data[16]);
                                if (!hashEQTLs2.containsKey((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[16])) {
                                    hashEQTLs2.put((matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[16], data);
                                    ++counterFile2;
                                }
                            }
                        }
                    } else if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[4])) {
                        hashUniqueProbes2.add(data[4]);
                        hashUniqueGenes2.add(data[16]);
                        ++counterFile2;
                    }
                    String[] eQTL = null;
                    String identifier = null;
                    if (matchOnGeneName) {
                        if (data.length > 16 && data[16].length() > 1) {
                            if (splitGeneNames) {
                                for (String gene : SEMI_COLON_PATTERN.split(data[16])) {
                                    if (hashExcludeEQTLs.contains(data[1] + "\t" + gene) || !hashEQTLs.containsKey((Object)(identifier = (matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + gene))) continue;
                                    eQTL = (String[])hashEQTLs.get((Object)identifier);
                                }
                            } else if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[16]) && hashEQTLs.containsKey((Object)(identifier = (matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[16]))) {
                                eQTL = (String[])hashEQTLs.get((Object)identifier);
                            }
                        }
                    } else if (!hashExcludeEQTLs.contains(data[1] + "\t" + data[4]) && hashEQTLs.containsKey((Object)(identifier = (matchSnpOnPos ? data[2] + ":" + data[3] : data[1]) + "\t" + data[4]))) {
                        eQTL = (String[])hashEQTLs.get((Object)identifier);
                    }
                    if (eQTL == null) {
                        double pValue = Double.parseDouble(data[0]);
                        if (hashTestedSNPsThatPassedQC == null || hashTestedSNPsThatPassedQC.contains(data[1])) {
                            log.write("eQTL Present In New file But Not In Original File:\t" + identifier + "\t" + data[0] + "\t" + data[2] + "\t" + data[3] + "\t" + data[16] + "\n");
                        }
                        double zScore2 = Double.parseDouble(data[10]);
                        int posX = 500;
                        int posY = 500 - (int)Math.round(zScore2 * 10.0);
                        zs.draw(null, zScore2, 0, 1);
                    } else {
                        int b;
                        int a;
                        String[] eQtlData = eQTL;
                        boolean identicalProbe = true;
                        String probe = data[4];
                        void probeFound = eQtlData[4];
                        if (!probe.equals(probeFound)) {
                            identicalProbe = false;
                        }
                        hashUniqueProbesOverlap.add(data[4]);
                        hashUniqueGenesOverlap.add(data[16]);
                        if (!hashEQTLNrTimesAssessed.containsKey(identifier)) {
                            hashEQTLNrTimesAssessed.put(identifier, 1);
                            vecEQTLNrTimesAssessed.add(identifier);
                        } else {
                            hashEQTLNrTimesAssessed.put(identifier, 1 + (Integer)hashEQTLNrTimesAssessed.get(identifier));
                        }
                        String alleles = eQtlData[8];
                        String alleleAssessed = eQtlData[9];
                        String[] correlations = eQtlData[17].split(";");
                        double correlation = 0.0;
                        int numCorr1 = 0;
                        for (int c = 0; c < correlations.length; ++c) {
                            try {
                                if (correlations[c].equals("-")) continue;
                                correlation += Double.parseDouble(correlations[c]);
                                ++numCorr1;
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        correlation /= (double)numCorr1;
                        double zScore = Double.parseDouble(eQtlData[10]);
                        String alleles2 = data[8];
                        String alleleAssessed2 = data[9];
                        double zScore2 = Double.parseDouble(data[10]);
                        String[] correlations2 = data[17].split(";");
                        double correlation2 = 0.0;
                        boolean alleleflipped = false;
                        if (!alleleAssessed.equals(data[9]) && data[9].equals(eQtlData[8].split("/")[0])) {
                            alleleflipped = true;
                        }
                        int numCorr2 = 0;
                        for (int c = 0; c < correlations2.length; ++c) {
                            try {
                                if (correlations2[c].equals("-")) continue;
                                correlation2 += Double.parseDouble(correlations2[c]);
                                ++numCorr2;
                                continue;
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        correlation2 /= (double)numCorr2;
                        if (alleleflipped) {
                            correlation2 = -correlation2;
                        }
                        boolean sameDirection = false;
                        int nrIdenticalAlleles = 0;
                        if (alleles.length() > 2 && alleles2.length() > 2) {
                            for (a = 0; a < 3; ++a) {
                                for (b = 0; b < 3; ++b) {
                                    if (a == 1 || b == 1 || alleles.getBytes()[a] != alleles2.getBytes()[b]) continue;
                                    ++nrIdenticalAlleles;
                                }
                            }
                        }
                        if (nrIdenticalAlleles == 0) {
                            alleles2 = (char)BaseAnnot.getComplement((byte)alleles2.charAt(0)) + "/" + (char)BaseAnnot.getComplement((byte)alleles2.charAt(2));
                            alleleAssessed2 = BaseAnnot.getComplement(alleleAssessed2);
                            if (alleles.length() > 2 && alleles2.length() > 2) {
                                for (a = 0; a < 3; ++a) {
                                    for (b = 0; b < 3; ++b) {
                                        if (a == 1 || b == 1 || alleles.getBytes()[a] != alleles2.getBytes()[b]) continue;
                                        ++nrIdenticalAlleles;
                                    }
                                }
                            }
                        }
                        if (nrIdenticalAlleles != 2) {
                            log.write("Error! SNPs have incompatible alleles!!:\t" + alleles + "\t" + alleles2 + "\t" + identifier + "\n");
                        } else {
                            ++overlap;
                            if (!alleleAssessed.equals(alleleAssessed2)) {
                                zScore2 = -zScore2;
                                alleleAssessed2 = alleleAssessed;
                            }
                            if (zScore2 * zScore > 0.0) {
                                sameDirection = true;
                            }
                            zs.draw(zScore, zScore2, 0, 1);
                            if (!sameDirection) {
                                ++nreQTLsOppositeDirection;
                                String oppositeEQTL = matchOnGeneName ? data[1] + "\t" + data[16] : data[1] + "\t" + data[4];
                                if (!vecOppositeEQTLs.contains(oppositeEQTL = oppositeEQTL + '\t' + alleles + '\t' + alleleAssessed + '\t' + zScore + '\t' + alleles2 + '\t' + alleleAssessed2 + '\t' + zScore2)) {
                                    vecOppositeEQTLs.add(oppositeEQTL);
                                }
                                vecX.add(zScore);
                                vecY.add(zScore2);
                            } else {
                                identicalOut.writeln(identifier);
                                ++nreQTLsIdenticalDirection;
                                if (!(alleles.length() <= 2 || alleles.equals("A/T") || alleles.equals("T/A") || alleles.equals("C/G") || alleles.equals("G/C"))) {
                                    vecX.add(zScore);
                                    vecY.add(zScore2);
                                }
                            }
                        }
                    }
                }
            }
            ++lineno;
        }
        identicalOut.close();
        log.close();
        in.close();
        double[] valsX = new double[vecX.size()];
        double[] valsY = new double[vecX.size()];
        for (int v = 0; v < valsX.length; ++v) {
            valsX[v] = (Double)vecX.get(v);
            valsY[v] = (Double)vecY.get(v);
        }
        if (valsX.length > 2) {
            double correlation = ArrayMath.correlation((double[])valsX, (double[])valsY);
            double r2 = correlation * correlation;
            DRand randomEngine = new DRand();
            StudentT tDistColt = new StudentT((double)(valsX.length - 2), (DoubleRandomEngine)randomEngine);
            double pValuePearson = 1.0;
            double tValue = correlation / Math.sqrt((1.0 - r2) / (double)(valsX.length - 2));
            pValuePearson = tValue < 0.0 ? tDistColt.cdf(tValue) : tDistColt.cdf(-tValue);
            System.out.println("\nCorrelation between the Z-Scores of the overlapping set of eQTLs:\t" + correlation + "\tP-Value:\t" + (pValuePearson *= 2.0));
        }
        TextFile out = new TextFile(outputFile + "-OppositeEQTLs.txt", true);
        for (String oppositeEQTL : vecOppositeEQTLs) {
            out.write(oppositeEQTL);
            out.append('\n');
        }
        out.close();
        in.close();
        zs.write(zsOutFileName);
        TextFile outSummary = new TextFile(outputFile + "-Summary.txt", true);
        System.out.println("");
        System.out.println("Nr of eQTLs:\t" + hashEQTLs.size() + "\tin file:\t" + file1 + "\tNrUniqueProbes:\t" + nrUniqueProbes + "\tNrUniqueGenes:\t" + nrUniqueGenes);
        outSummary.writeln("Nr of eQTLs:\t" + hashEQTLs.size() + "\tin file:\t" + file1 + "\tNrUniqueProbes:\t" + nrUniqueProbes + "\tNrUniqueGenes:\t" + nrUniqueGenes);
        System.out.println("Nr of eQTLs:\t" + counterFile2 + "\tin file:\t" + file2 + "\tNrUniqueProbes:\t" + hashUniqueProbes2.size() + "\tNrUniqueGenes:\t" + hashUniqueGenes2.size());
        outSummary.writeln("Nr of eQTLs:\t" + counterFile2 + "\tin file:\t" + file2 + "\tNrUniqueProbes:\t" + hashUniqueProbes2.size() + "\tNrUniqueGenes:\t" + hashUniqueGenes2.size());
        System.out.println("Overlap:\t" + overlap + "\tNrUniqueProbesOverlap:\t" + hashUniqueProbesOverlap.size() + "\tNrUniqueGenesOverlap:\t" + hashUniqueGenesOverlap.size());
        outSummary.writeln("Overlap:\t" + overlap + "\tNrUniqueProbesOverlap:\t" + hashUniqueProbesOverlap.size() + "\tNrUniqueGenesOverlap:\t" + hashUniqueGenesOverlap.size());
        System.out.println("");
        outSummary.writeln();
        System.out.println("Nr eQTLs with identical direction:\t" + nreQTLsIdenticalDirection);
        outSummary.writeln("Nr eQTLs with identical direction:\t" + nreQTLsIdenticalDirection);
        double proportionOppositeDirection = 100.0 * (double)nreQTLsOppositeDirection / (double)(nreQTLsOppositeDirection + nreQTLsIdenticalDirection);
        String proportionOppositeDirectionString = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.US)).format(proportionOppositeDirection);
        System.out.println("Nr eQTLs with opposite direction:\t" + nreQTLsOppositeDirection + "\t(" + proportionOppositeDirectionString + "%)");
        outSummary.writeln("Nr eQTLs with opposite direction:\t" + nreQTLsOppositeDirection + "\t(" + proportionOppositeDirectionString + "%)");
        outSummary.close();
        this.nrShared = hashUniqueProbesOverlap.size();
        this.nrOpposite = nreQTLsOppositeDirection;
    }
}

