/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import umcg.genetica.containers.SortableSNP;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class ProbeSNPMapper {
    public void mapprobes(String snpmappings, String probeannotation, String probelist) {
        try {
            TextFile tf = new TextFile(snpmappings, false);
            HashMap<Byte, ArrayList> snpsPerChr = new HashMap<Byte, ArrayList>();
            String[] elems = tf.readLineElemsReturnReference(TextFile.tab);
            while (elems != null) {
                Byte chr = ChrAnnotation.parseChr(elems[0]);
                Integer chrPos = Integer.parseInt(elems[1]);
                String name = elems[2];
                if (chr > 0) {
                    ArrayList<SortableSNP> snps = (ArrayList<SortableSNP>)snpsPerChr.get(chr);
                    if (snps == null) {
                        snps = new ArrayList<SortableSNP>();
                    }
                    snps.add(new SortableSNP(name, 0, chr, chrPos, SortableSNP.SORTBY.CHRPOS));
                    snpsPerChr.put(chr, snps);
                }
                elems = tf.readLineElemsReturnReference(TextFile.tab);
            }
            tf.close();
            HashMap<String, String> probeToChrPos = new HashMap<String, String>();
            for (byte chr = 0; chr < 26; chr = (byte)(chr + 1)) {
                ArrayList snps = (ArrayList)snpsPerChr.get(chr);
                if (snps == null) continue;
                Collections.sort(snps);
                snpsPerChr.put(chr, snps);
                System.out.println("chr:\t" + chr + "\tsnps:\t" + snps.size());
            }
            tf = new TextFile(probeannotation, false);
            elems = tf.readLineElemsReturnReference(TextFile.tab);
            while (elems != null) {
                if (!elems[0].equals("-")) {
                    probeToChrPos.put(elems[1], elems[3] + ";" + elems[4] + ":" + elems[5]);
                }
                elems = tf.readLineElemsReturnReference(TextFile.tab);
            }
            tf.close();
            tf = new TextFile(probelist, false);
            elems = tf.readLineElemsReturnReference(TextFile.tab);
            while (elems != null) {
                String probe = elems[0];
                String chrpos = (String)probeToChrPos.get(probe);
                if (chrpos != null) {
                    String[] chrposelems = chrpos.split(";");
                    byte chr = ChrAnnotation.parseChr(chrposelems[0]);
                    if (chr == -1) {
                        System.out.println("THERE IS NO ANNOTATION FOR PROBE: " + probe + "\t" + chrpos);
                    } else {
                        Integer chrend;
                        Integer chrstart = Integer.parseInt((chrposelems = chrposelems[1].split(":"))[0]);
                        if (chrstart.equals(chrend = Integer.valueOf(Integer.parseInt(chrposelems[1])))) {
                            System.out.println("ERROR: probe chr start == probe chr end");
                        } else {
                            ArrayList snps = (ArrayList)snpsPerChr.get(chr);
                            String snpsInProbe = "";
                            for (int i = 0; i < snps.size(); ++i) {
                                if (((SortableSNP)snps.get((int)i)).chrpos < chrstart || ((SortableSNP)snps.get((int)i)).chrpos > chrend) continue;
                                snpsInProbe = snpsInProbe + ((SortableSNP)snps.get((int)i)).name + ",";
                            }
                            System.out.println(probe + "\t" + chr + "\t" + chrstart + "\t" + chrend + "\t" + snpsInProbe);
                        }
                    }
                } else {
                    System.out.println("THERE IS NO ANNOTATION FOR PROBE: " + probe);
                }
                elems = tf.readLineElemsReturnReference(TextFile.tab);
            }
            tf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

