/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.util;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantCombinedFilter;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantFilterBiAllelic;
import org.molgenis.genotype.variantFilter.VariantFilterSeq;
import org.molgenis.genotype.variantFilter.VariantIdIncludeFilter;
import org.molgenis.genotype.variantFilter.VariantQcChecker;

public class NoLdSnpProbeListCreator {
    public static void main(String[] args) throws UnsupportedEncodingException, FileNotFoundException, IOException, Exception {
        String line;
        GnuParser parser = new GnuParser();
        System.out.flush();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location and name of the output file.");
        OptionBuilder.withLongOpt((String)"OutputFile");
        Option FileOut = OptionBuilder.create((String)"o");
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Type of reference data.");
        OptionBuilder.withLongOpt((String)"ReferenceType");
        Option ReferenceTypeIn = OptionBuilder.create((String)"rt");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location for the reference data");
        OptionBuilder.withLongOpt((String)"ReferenceLocation");
        Option ReferenceIn = OptionBuilder.create((String)"ri");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location of the input data");
        OptionBuilder.withLongOpt((String)"input");
        Option InFile = OptionBuilder.create((String)"i");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Half window size (default 250000).");
        OptionBuilder.withLongOpt((String)"Window_Size");
        Option WindowSize = OptionBuilder.create((String)"ws");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Additional probe margin (default 0).");
        OptionBuilder.withLongOpt((String)"Probe_margin");
        Option ProbeMargin = OptionBuilder.create((String)"pm");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cut-off point for max d'(default 0.2).");
        OptionBuilder.withLongOpt((String)"max_dPrime");
        Option MaxDprime = OptionBuilder.create((String)"dp");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cut-off point for max r2 (default 0.2).");
        OptionBuilder.withLongOpt((String)"max_rSquare");
        Option MaxRsquare = OptionBuilder.create((String)"r");
        OptionBuilder.withArgName((String)"String");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"List with variant ids to select.");
        OptionBuilder.withLongOpt((String)"variant_filter");
        Option variantFilter = OptionBuilder.create((String)"vf");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Call-rate cut-off.");
        OptionBuilder.withLongOpt((String)"min_callRate");
        Option callRate = OptionBuilder.create((String)"vc");
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Minor allel cut-off filter.");
        OptionBuilder.withLongOpt((String)"min_maf");
        Option mafFilter = OptionBuilder.create((String)"mf");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Filter input data on chromosome");
        OptionBuilder.withLongOpt((String)"chrFilter");
        Option chrFilter = OptionBuilder.create((String)"ch");
        options.addOption(FileOut).addOption(ReferenceTypeIn).addOption(ReferenceIn).addOption(WindowSize).addOption(InFile).addOption(ProbeMargin).addOption(MaxDprime).addOption(MaxRsquare).addOption(variantFilter).addOption(callRate).addOption(mafFilter).addOption(chrFilter);
        File probeFile = null;
        String genotypePath = null;
        String genotypeType = null;
        int windowHalfSize = 250000;
        int probeMargin = 1;
        float cRate = 0.0f;
        float maf = 0.0f;
        double HWE = 0.0;
        String variantFilterList = null;
        double maxDprime = 0.2;
        double maxR2 = 0.2;
        String chrF = null;
        File outputFile = null;
        String logOutput = "";
        try {
            CommandLine cmd = parser.parse(options, args);
            HelpFormatter formatter = new HelpFormatter();
            if (cmd.hasOption("OutputFile") || cmd.hasOption("o")) {
                outputFile = new File(cmd.getOptionValue("OutputFile"));
                logOutput = logOutput + "OutputFile:\t" + outputFile + "\n";
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("ReferenceLocation") || cmd.hasOption("ri")) {
                genotypePath = cmd.getOptionValue("ReferenceLocation");
                logOutput = logOutput + "ReferenceLocation:\t" + genotypePath + "\n";
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("ReferenceType") || cmd.hasOption("rt")) {
                genotypeType = cmd.getOptionValue("ReferenceType");
                logOutput = logOutput + "ReferenceType:\t" + genotypeType + "\n";
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("input") || cmd.hasOption("i")) {
                probeFile = new File(cmd.getOptionValue("input"));
                logOutput = logOutput + "Input probemapping:\t" + probeFile + "\n";
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("Window_Size") || cmd.hasOption("ws")) {
                windowHalfSize = Integer.parseInt(cmd.getOptionValue("Window_Size"));
                logOutput = logOutput + "Window Size:\t" + windowHalfSize + "\n";
            }
            if (cmd.hasOption("Probe_margin") || cmd.hasOption("pm")) {
                probeMargin = Integer.parseInt(cmd.getOptionValue("Probe_margin"));
                logOutput = logOutput + "Probe margin:\t" + probeMargin + "\n";
            }
            if (cmd.hasOption("variant_filter") || cmd.hasOption("vf")) {
                variantFilterList = cmd.getOptionValue("variant_filter");
                logOutput = logOutput + "Variant filter:\t" + variantFilterList + "\n";
            }
            if (cmd.hasOption("min_callRate") || cmd.hasOption("vc")) {
                cRate = Float.parseFloat(cmd.getOptionValue("min_callRate"));
                logOutput = logOutput + "Min callRate:\t" + cRate + "\n";
            }
            if (cmd.hasOption("min_maf") || cmd.hasOption("mf")) {
                maf = Float.parseFloat(cmd.getOptionValue("min_maf"));
                logOutput = logOutput + "Min maf:\t" + maf + "\n";
            }
            if (cmd.hasOption("MaxDprime") || cmd.hasOption("md")) {
                maxDprime = Double.parseDouble(cmd.getOptionValue("MaxDprime"));
                logOutput = logOutput + "Max D':\t" + maxDprime + "\n";
            }
            if (cmd.hasOption("max_rSquare") || cmd.hasOption("mr")) {
                maxR2 = Double.parseDouble(cmd.getOptionValue("max_rSquare"));
                logOutput = logOutput + "Max rSquare:\t" + maxR2 + "\n";
            }
            if (cmd.hasOption("chrFilter") || cmd.hasOption("ch")) {
                chrF = cmd.getOptionValue("chrFilter");
                logOutput = logOutput + "Chr filter:\t" + chrF + "\n";
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(NoLdSnpProbeListCreator.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(logOutput);
        SampleFilter sf = null;
        VariantCombinedFilter varFilter = new VariantCombinedFilter();
        varFilter.add((VariantFilter)new VariantFilterBiAllelic());
        if (cRate != 0.0f || maf != 0.0f || HWE != 0.0) {
            VariantQcChecker qc = new VariantQcChecker(maf, cRate, HWE);
            varFilter.add((VariantFilter)qc);
        }
        if (variantFilterList != null) {
            String line2;
            HashSet<String> snps = new HashSet<String>();
            BufferedReader variantIdFilterReader = new BufferedReader(new FileReader(variantFilterList));
            while ((line2 = variantIdFilterReader.readLine()) != null) {
                snps.add(line2);
            }
            VariantIdIncludeFilter snpIdFilter = new VariantIdIncludeFilter(snps);
            varFilter.add((VariantFilter)snpIdFilter);
        }
        if (chrF != null) {
            VariantFilterSeq seqFilter = new VariantFilterSeq(new String[]{chrF});
            varFilter.add((VariantFilter)seqFilter);
        }
        RandomAccessGenotypeData genotypeData = RandomAccessGenotypeDataReaderFormats.valueOf(genotypeType).createFilteredGenotypeData(genotypePath, 10000, (VariantFilter)varFilter, sf);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(probeFile), "UTF-8"));
        BufferedWriter snpProbeToTestWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        int rSquareExclusions = 0;
        int dPrimeExclusions = 0;
        int possibleCombinations = 0;
        int locatedInProbe = 0;
        int lineNr = 0;
        while ((line = reader.readLine()) != null) {
            String probeName;
            int probeStopPos;
            int probeStartPos;
            String chr;
            ++lineNr;
            String[] elements = StringUtils.splitPreserveAllTokens((String)line, (char)'\t');
            if (probeFile.getName().endsWith(".bed") && elements.length < 4 || probeFile.getName().endsWith(".txt") && elements.length < 6) {
                throw new Exception("Incorrect file format.");
            }
            if (probeFile.getName().endsWith(".bed")) {
                chr = elements[0].replace("chr", "");
                probeStartPos = Integer.parseInt(elements[1]);
                probeStopPos = Integer.parseInt(elements[2]);
                probeName = elements[3];
            } else if (probeFile.getName().endsWith(".txt")) {
                if (lineNr == 1) {
                    line = reader.readLine();
                    elements = StringUtils.splitPreserveAllTokens((String)line, (char)'\t');
                }
                chr = elements[3];
                probeStartPos = Integer.parseInt(elements[4]);
                probeStopPos = Integer.parseInt(elements[5]);
                probeName = elements[2];
            } else {
                throw new Exception("Incorrect file format.");
            }
            int probeCenter = probeStartPos + (int)Math.floor((double)(probeStopPos - probeStartPos) / 2.0);
            int windowsStart = probeCenter - windowHalfSize;
            windowsStart = windowsStart < 0 ? 0 : windowsStart;
            int windowStop = probeCenter + windowHalfSize;
            ArrayList probeVariants = Lists.newArrayList((Iterable)genotypeData.getVariantsByRange(chr, probeStartPos - probeMargin, probeStopPos + probeMargin));
            block6: for (GeneticVariant variant : genotypeData.getVariantsByRange(chr, windowsStart, windowStop)) {
                String variantPrimaryId;
                ++possibleCombinations;
                if (variant.getStartPos() >= probeStartPos - probeMargin && variant.getStartPos() <= probeStopPos + probeMargin) {
                    ++locatedInProbe;
                    continue;
                }
                if (!probeVariants.isEmpty()) {
                    for (GeneticVariant probeVariant : probeVariants) {
                        Ld ld = variant.calculateLd(probeVariant);
                        if (ld.getDPrime() >= maxDprime) {
                            ++dPrimeExclusions;
                            continue block6;
                        }
                        if (!(ld.getR2() >= maxR2)) continue;
                        ++rSquareExclusions;
                        continue block6;
                    }
                }
                if ((variantPrimaryId = variant.getPrimaryVariantId()) == null) {
                    snpProbeToTestWriter.append(variant.getSequenceName()).append('-').append(String.valueOf(variant.getStartPos()));
                } else {
                    snpProbeToTestWriter.append(variantPrimaryId);
                }
                snpProbeToTestWriter.append('-');
                snpProbeToTestWriter.append(probeName);
                snpProbeToTestWriter.append('\n');
            }
        }
        snpProbeToTestWriter.close();
        System.out.println("Number of valid combination: " + possibleCombinations);
        System.out.println("Excluded because located in probe: " + locatedInProbe);
        System.out.println("Excluded based on D': " + dPrimeExclusions);
        System.out.println("Excluded based on r2: " + rSquareExclusions);
    }
}

