/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.SortableSNP;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.DetermineLD;

public class LDCalculator {
    public static void calculatePairwiseLD(String snpfile, String dataset, String output) throws IOException {
        if (snpfile == null) {
            throw new IllegalArgumentException("Error: snp file location should be provided");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Error: dataset location should be provided");
        }
        if (output == null) {
            throw new IllegalArgumentException("Error: output location should be provided");
        }
        TextFile snpTextFile = new TextFile(snpfile, false);
        String[] elems = snpTextFile.readLineElems(TextFile.tab);
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        while (elems != null) {
            if (elems.length > 1) {
                Pair<String, String> p = new Pair<String, String>(elems[0], elems[1]);
                pairs.add(p);
            }
            elems = snpTextFile.readLineElems(TextFile.tab);
        }
        snpTextFile.close();
        if (pairs.isEmpty()) {
            throw new IllegalArgumentException("Error: " + snpfile + " does not contain any useable SNP pairs. Did you use tab separation?");
        }
        DetermineLD calc = new DetermineLD();
        TriTyperGenotypeData ds = new TriTyperGenotypeData();
        ds.load(dataset);
        SNPLoader loader = ds.createSNPLoader();
        TextFile outputfile = new TextFile(output, true);
        String header = "SNP1\tSNP1Chr\tSNP1ChrPos\tSNP1MAF\tSNP1CR\tSNP1HWEP\tSNP2\tSNP2Chr\tSNP2ChrPos\tSNP2MAF\tSNP2CR\tSNP2HWEP\tDistrance\tR2\tSNPOnSameChr";
        outputfile.writeln(header);
        for (Pair pair : pairs) {
            Integer snp1Id = ds.getSnpToSNPId().get(pair.getLeft());
            Integer snp2Id = ds.getSnpToSNPId().get(pair.getRight());
            boolean test = true;
            String teststr = "";
            if (snp1Id == -9) {
                System.out.println((String)pair.getLeft() + "\tnot present in dataset");
                teststr = (String)pair.getLeft() + "\tnot present in dataset";
                test = false;
            }
            if (snp2Id == -9) {
                System.out.println((String)pair.getRight() + "\tnot present in dataset");
                teststr = teststr.length() > 0 ? teststr + "\t" + (String)pair.getRight() + "\tnot present in dataset" : (String)pair.getRight() + "\tnot present in dataset";
                test = false;
            }
            if (!test) {
                outputfile.writeln(teststr);
                continue;
            }
            SNP snp1Obj = ds.getSNPObject(snp1Id);
            SNP snp2Obj = ds.getSNPObject(snp2Id);
            boolean snpOnSameChr = true;
            if (snp1Obj.getChr() != snp2Obj.getChr()) {
                System.out.println((String)pair.getLeft() + "\t" + snp1Obj.getChr() + "\t" + (String)pair.getRight() + "\t" + snp2Obj.getChr() + "\tnot on same chr");
                snpOnSameChr = false;
            }
            loader.loadGenotypes(snp1Obj);
            loader.loadGenotypes(snp2Obj);
            double r2 = calc.getRSquared(snp1Obj, snp2Obj, ds, 4, 1, false);
            int distance = snp2Obj.getChrPos() - snp1Obj.getChrPos();
            String ln = (String)pair.getLeft() + "\t" + snp1Obj.getChr() + "\t" + snp1Obj.getChrPos() + "\t" + snp1Obj.getMAF() + "\t" + snp1Obj.getCR() + "\t" + snp1Obj.getHWEP() + "\t" + (String)pair.getRight() + "\t" + snp2Obj.getChr() + "\t" + snp2Obj.getChrPos() + "\t" + snp2Obj.getMAF() + "\t" + snp2Obj.getCR() + "\t" + snp2Obj.getHWEP() + "\t" + distance + "\t" + r2 + "\t" + snpOnSameChr;
            System.out.println(ln);
            outputfile.writeln(ln);
            snp1Obj.clearGenotypes();
            snp2Obj.clearGenotypes();
        }
        outputfile.close();
    }

    public static void proxyLookUpInReferenceDataset(String reference, String inputList, double mafThreshold, double hwepthreshold, double crthreshold, double r2threshold, String output, int maxdistance) throws IOException {
        TextFile snpList = new TextFile(inputList, false);
        String[] snpsToQuery = snpList.readAsArray();
        snpList.close();
        TriTyperGenotypeData refDataset = new TriTyperGenotypeData();
        refDataset.load(reference);
        SNPLoader refLoader = refDataset.createSNPLoader();
        TextFile outputfile = new TextFile(output, true);
        int ctr = 0;
        String[] arr$ = snpsToQuery;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Triple<String, Double, Integer> proxy;
            String snp;
            String outputStr = snp = arr$[i$];
            System.out.println(ctr + "/" + snpsToQuery.length);
            Integer refDatasetId = refDataset.getSnpToSNPId().get((Object)snp);
            outputStr = refDatasetId == -9 ? outputStr + "\t-\tNo proxy available - Not present in reference" : ((proxy = LDCalculator.proxyLookUpInReferenceDataAlone(refDataset, refLoader, refDatasetId, r2threshold, mafThreshold, crthreshold, hwepthreshold, maxdistance)) == null ? outputStr + "\t-\tNo proxy available - no SNP that meets thresholds" : outputStr + "\t" + proxy.getLeft() + "\t" + proxy.getMiddle() + "\t" + proxy.getRight());
            outputfile.writeln(outputStr);
            System.out.println(outputStr);
            ++ctr;
        }
        outputfile.close();
        refLoader.close();
    }

    public static void proxyLookupInReferenceThatIsAlsoIneQTLDataset(String reference, String dataset, String inputList, double mafThreshold, double hwepthreshold, double crthreshold, double r2threshold, String output, int maxdistance) throws IOException {
        TextFile snpList = new TextFile(inputList, false);
        String[] snpsToQuery = snpList.readAsArray();
        snpList.close();
        TriTyperGenotypeData inDataset = new TriTyperGenotypeData();
        inDataset.load(dataset);
        SNPLoader datasetLoader = inDataset.createSNPLoader();
        TriTyperGenotypeData refDataset = new TriTyperGenotypeData();
        refDataset.load(reference);
        SNPLoader refLoader = refDataset.createSNPLoader();
        TextFile outputfile = new TextFile(output, true);
        String[] arr$ = snpsToQuery;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SNP snpInDataObj;
            String snp;
            String outputStr = snp = arr$[i$];
            Integer inDatasetId = inDataset.getSnpToSNPId().get((Object)snp);
            Integer refDatasetId = refDataset.getSnpToSNPId().get((Object)snp);
            if (inDatasetId == -9 && refDatasetId == -9) {
                outputStr = outputStr + "\t-\tNo proxy available - Not present in reference and dataset";
            } else if (inDatasetId == -9 && refDatasetId != -9) {
                Triple<String, Double, Integer> proxy = LDCalculator.findProxyThatIsAlsoInDatasetToTest(refDataset, inDataset, refLoader, datasetLoader, refDatasetId, r2threshold, mafThreshold, crthreshold, hwepthreshold, maxdistance);
                outputStr = proxy == null ? outputStr + "\t-\tNo proxy available - no SNP that meets thresholds" : outputStr + "\t" + proxy.getLeft() + "\t" + proxy.getMiddle() + "\t" + proxy.getRight();
            } else if (inDatasetId != -9 && refDatasetId != -9) {
                Triple<String, Double, Integer> proxy;
                snpInDataObj = inDataset.getSNPObject(inDatasetId);
                datasetLoader.loadGenotypes(snpInDataObj);
                snpInDataObj.clearGenotypes();
                outputStr = snpInDataObj.getMAF() < mafThreshold || snpInDataObj.getCR() < crthreshold || snpInDataObj.getHWEP() < hwepthreshold ? ((proxy = LDCalculator.findProxyThatIsAlsoInDatasetToTest(refDataset, inDataset, refLoader, datasetLoader, refDatasetId, r2threshold, mafThreshold, crthreshold, hwepthreshold, maxdistance)) == null ? outputStr + "\t-\tNo proxy available - no SNP that meets thresholds" : outputStr + "\t" + proxy.getLeft() + "\t" + proxy.getMiddle() + "\t" + proxy.getRight()) : outputStr + "\t" + snp + "\tNo proxy required";
            } else if (inDatasetId != -9 && refDatasetId == -9) {
                snpInDataObj = inDataset.getSNPObject(inDatasetId);
                datasetLoader.loadGenotypes(snpInDataObj);
                snpInDataObj.clearGenotypes();
                outputStr = snpInDataObj.getMAF() < mafThreshold || snpInDataObj.getCR() < crthreshold || snpInDataObj.getHWEP() < hwepthreshold ? outputStr + "\t-\tNo proxy available - SNP not present in reference" : outputStr + "\t" + snp + "\tNo proxy required - SNP not present in reference but meets eQTL QC thresholds";
            }
            outputfile.writeln(outputStr);
            System.out.println(outputStr);
        }
        outputfile.close();
        datasetLoader.close();
        refLoader.close();
    }

    private static Triple<String, Double, Integer> findProxyThatIsAlsoInDatasetToTest(TriTyperGenotypeData refDataset, TriTyperGenotypeData inDataset, SNPLoader refLoader, SNPLoader datasetLoader, Integer snpIdInReference, double r2threshold, double maf, double cr, double hwep, int maxDistance) throws IOException {
        String[] snpsInReference = refDataset.getSNPs();
        byte chromosomeOfStartSNP = refDataset.getChr(snpIdInReference);
        String query = snpsInReference[snpIdInReference];
        System.out.println("");
        System.out.println("Query:\t" + query);
        ArrayList<SortableSNP> snpsToSort = new ArrayList<SortableSNP>();
        for (int s = 0; s < snpsInReference.length; ++s) {
            if (refDataset.getChr(s) != chromosomeOfStartSNP || snpIdInReference.equals(s)) continue;
            String snpName = snpsInReference[s];
            int chrPos = refDataset.getChrPos(s);
            int distance = Math.abs(refDataset.getChrPos(s) - refDataset.getChrPos(snpIdInReference));
            if (distance >= maxDistance || inDataset.getSnpToSNPId().get((Object)snpName) == -9) continue;
            snpsToSort.add(new SortableSNP(snpName, s, chromosomeOfStartSNP, refDataset.getChrPos(s), SortableSNP.SORTBY.CHRPOS));
        }
        System.out.println(snpsToSort.size() + "\t SNPs within 10Mb");
        if (snpsToSort.isEmpty()) {
            return null;
        }
        Collections.sort(snpsToSort);
        SortableSNP[] sorted = snpsToSort.toArray(new SortableSNP[0]);
        SNP startSNPObj = refDataset.getSNPObject(snpIdInReference);
        refLoader.loadGenotypes(startSNPObj);
        DetermineLD ldcalc = new DetermineLD();
        Integer bestproxy = null;
        double maxR2 = Double.MIN_VALUE;
        int dist = 0;
        for (int s = 0; s < sorted.length; ++s) {
            int nextSNP = sorted[s].id;
            SNP nextSNPObj = refDataset.getSNPObject(nextSNP);
            refLoader.loadGenotypes(nextSNPObj);
            double r2 = ldcalc.getRSquared(startSNPObj, nextSNPObj, refDataset, 4, 1, false);
            double dp = ldcalc.getRSquared(startSNPObj, nextSNPObj, refDataset, 5, 1, false);
            int distance = nextSNPObj.getChrPos() - startSNPObj.getChrPos();
            if (r2 >= r2threshold) {
                Integer snpIdInDataset = inDataset.getSnpToSNPId().get((Object)nextSNPObj.getName());
                SNP snpInDatasetObj = inDataset.getSNPObject(snpIdInDataset);
                datasetLoader.loadGenotypes(snpInDatasetObj);
                boolean snpPassesQC = false;
                if (snpInDatasetObj.getMAF() > maf && snpInDatasetObj.getHWEP() > hwep && snpInDatasetObj.getCR() > cr && r2 >= maxR2) {
                    bestproxy = s;
                    maxR2 = r2;
                    dist = distance;
                    snpPassesQC = true;
                }
                snpInDatasetObj.clearGenotypes();
            }
            nextSNPObj.clearGenotypes();
        }
        startSNPObj.clearGenotypes();
        if (bestproxy == null) {
            return null;
        }
        return new Triple<String, Double, Integer>(sorted[bestproxy.intValue()].name, maxR2, dist);
    }

    private static Triple<String, Double, Integer> proxyLookUpInReferenceDataAlone(TriTyperGenotypeData refDataset, SNPLoader refLoader, Integer refDatasetSNPId, double r2threshold, double maf, double cr, double hwep, int maxdistance) throws IOException {
        String[] snpsInReference = refDataset.getSNPs();
        byte chromosomeOfStartSNP = refDataset.getChr(refDatasetSNPId);
        String query = snpsInReference[refDatasetSNPId];
        System.out.println("");
        System.out.println("Query:\t" + query);
        ArrayList<SortableSNP> snpsToSort = new ArrayList<SortableSNP>();
        for (int s = 0; s < snpsInReference.length; ++s) {
            int distance;
            if (refDataset.getChr(s) != chromosomeOfStartSNP || refDatasetSNPId.equals(s)) continue;
            String snpName = snpsInReference[s];
            int chrPos = refDataset.getChrPos(s);
            if (chrPos == -1 || (distance = Math.abs(refDataset.getChrPos(s) - refDataset.getChrPos(refDatasetSNPId))) >= maxdistance) continue;
            snpsToSort.add(new SortableSNP(snpName, s, chromosomeOfStartSNP, refDataset.getChrPos(s), SortableSNP.SORTBY.CHRPOS));
        }
        System.out.println(snpsToSort.size() + "\t SNPs within 10Mb");
        if (snpsToSort.isEmpty()) {
            return null;
        }
        Collections.sort(snpsToSort);
        SortableSNP[] sorted = snpsToSort.toArray(new SortableSNP[0]);
        SNP startSNPObj = refDataset.getSNPObject(refDatasetSNPId);
        refLoader.loadGenotypes(startSNPObj);
        DetermineLD ldcalc = new DetermineLD();
        Integer bestproxy = null;
        double maxR2 = Double.MIN_VALUE;
        int dist = 0;
        for (int s = 0; s < sorted.length; ++s) {
            int nextSNP = sorted[s].id;
            SNP nextSNPObj = refDataset.getSNPObject(nextSNP);
            refLoader.loadGenotypes(nextSNPObj);
            Pair<Double, Double> ld = ldcalc.getLD(startSNPObj, nextSNPObj, refDataset, 1, false);
            double r2 = ld.getLeft();
            double dp = ld.getRight();
            int distance = nextSNPObj.getChrPos() - startSNPObj.getChrPos();
            if (r2 >= r2threshold && nextSNPObj.getMAF() > maf && nextSNPObj.getHWEP() > hwep && nextSNPObj.getCR() > cr && r2 >= maxR2) {
                bestproxy = s;
                maxR2 = r2;
                dist = distance;
            }
            nextSNPObj.clearGenotypes();
        }
        startSNPObj.clearGenotypes();
        if (bestproxy == null) {
            return null;
        }
        return new Triple<String, Double, Integer>(sorted[bestproxy.intValue()].name, maxR2, dist);
    }
}

