/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.SortableSNP;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.probeannotation.ProbeTranslation;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.io.trityper.util.DetermineLD;
import umcg.genetica.text.Strings;

public class CisEQTLProbeSNPLDCheck {
    double cr = 0.95;
    double hwe = 0.001;
    double maf = 0.01;

    public void runNew(String probeMapFile, String snpprobefile, String[] referenceDatasets, String[] referenceDatasetNames, String outputDirectory, double rSquaredThreshold, double dPrimeThreshold, int probecol, int probechrposcol, int probechrcol) throws IOException {
        ArrayList<Byte> probeChr = new ArrayList<Byte>();
        ArrayList<String> probeChrPos = new ArrayList<String>();
        ArrayList<String> probes = new ArrayList<String>();
        HashMap<String, Integer> probeToId = new HashMap<String, Integer>();
        TextFile tf = new TextFile(probeMapFile, false);
        tf.readLine();
        String[] probePositions = tf.readLineElems(TextFile.tab);
        int id = 0;
        while (probePositions != null) {
            String probeStr = probePositions[probecol];
            String probechrposStr = probePositions[probechrposcol];
            String probeChrStr = probePositions[probechrcol];
            probeChr.add(ChrAnnotation.parseChr(probeChrStr));
            probeChrPos.add(probechrposStr);
            probes.add(probeStr);
            probeToId.put(probeStr, id);
            ++id;
            probePositions = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        TextFile tf2 = new TextFile(snpprobefile, false);
        HashSet<Pair<String, String>> snpProbePairs = tf2.readAsPairs(0, 1);
        tf2.close();
        DetermineLD ldcalc = new DetermineLD();
        HashMap<Pair, Boolean> qcResultsBoolean = new HashMap<Pair, Boolean>();
        HashMap<Pair, String[]> qcResultsStr = new HashMap<Pair, String[]>();
        HashSet<Pair> snpProbePairsTested = new HashSet<Pair>();
        for (int d = 0; d < referenceDatasets.length; ++d) {
            HashSet<Pair> snpProbePairsTestedForThisReferenceDs = new HashSet<Pair>();
            String referenceDatasetLocation = referenceDatasets[d];
            String referenceDatasetName = referenceDatasetNames[d];
            TriTyperGenotypeData reference = new TriTyperGenotypeData(referenceDatasetLocation);
            SNPLoader loader = reference.createSNPLoader();
            String[] snps = reference.getSNPs();
            TextFile output = new TextFile(outputDirectory + referenceDatasetName + "-QCOutput.txt", true);
            output.writeln("SNPProbe\tFailsQC\tReason");
            HashSet<Pair<String, String>> snpProbePairsToTestForThisReferenceDataset = new HashSet<Pair<String, String>>();
            for (Pair<String, String> snpProbePair : snpProbePairs) {
                Boolean b;
                String[] qcStrArr;
                String snp = snpProbePair.getLeft();
                Integer snpId = reference.getSnpToSNPId().get((Object)snp);
                if (snpId == -9) {
                    snpProbePairsTested.add(snpProbePair);
                    snpProbePairsTestedForThisReferenceDs.add(snpProbePair);
                    output.writeln(snpProbePair.toString() + "\tUNKNOWN: SNP not present in " + referenceDatasetName);
                    qcStrArr = (String[])qcResultsStr.get(snpProbePair);
                    if (qcStrArr == null) {
                        qcStrArr = new String[referenceDatasetNames.length];
                    }
                    qcStrArr[d] = "SNP not present in " + referenceDatasetName;
                    qcResultsStr.put(snpProbePair, qcStrArr);
                    b = (Boolean)qcResultsBoolean.get(snpProbePair);
                    if (b != null) continue;
                    qcResultsBoolean.put(snpProbePair, null);
                    continue;
                }
                if (reference.getChr(snpId) == null || reference.getChr(snpId) < 1 || reference.getChr(snpId) > 23) {
                    snpProbePairsTested.add(snpProbePair);
                    snpProbePairsTestedForThisReferenceDs.add(snpProbePair);
                    qcStrArr = (String[])qcResultsStr.get(snpProbePair);
                    if (qcStrArr == null) {
                        qcStrArr = new String[referenceDatasetNames.length];
                    }
                    output.writeln(snpProbePair.toString() + "\tUNKNOWN: SNP maps to chromosome " + reference.getChr(snpId) + " in dataset " + referenceDatasetName);
                    qcStrArr[d] = "SNP maps to chromosome " + reference.getChr(snpId) + " in dataset " + referenceDatasetName;
                    qcResultsStr.put(snpProbePair, qcStrArr);
                    b = (Boolean)qcResultsBoolean.get(snpProbePair);
                    if (b != null) continue;
                    qcResultsBoolean.put(snpProbePair, null);
                    continue;
                }
                snpProbePairsToTestForThisReferenceDataset.add(snpProbePair);
            }
            for (byte chr = 1; chr < 23; chr = (byte)(chr + 1)) {
                ArrayList<SortableSNP> snpsOnChr = new ArrayList<SortableSNP>();
                ArrayList<Integer> probesOnChr = new ArrayList<Integer>();
                int nrProbes = probes.size();
                for (int p = 0; p < nrProbes; ++p) {
                    if (!((Byte)probeChr.get(p)).equals(chr)) continue;
                    probesOnChr.add(p);
                }
                HashSet<String> snpsOnChrStrHash = new HashSet<String>();
                for (int s = 0; s < snps.length; ++s) {
                    if (reference.getChr(s) != chr) continue;
                    snpsOnChrStrHash.add(snps[s]);
                    snpsOnChr.add(new SortableSNP(snps[s], s, chr, reference.getChrPos(s), SortableSNP.SORTBY.ID));
                }
                System.out.println(snpsOnChr.size() + "\tSNPs on Chr " + chr);
                System.out.println(probesOnChr.size() + "\tProbes on Chr " + chr);
                Collections.sort(snpsOnChr);
                HashMap snpsInProbes = new HashMap();
                for (int p = 0; p < probesOnChr.size(); ++p) {
                    Integer n = (Integer)probesOnChr.get(p);
                    String actualAnnotation = (String)probeChrPos.get(n);
                    probePositions = actualAnnotation.split(":");
                    HashSet<Integer> snpsInProbe = new HashSet<Integer>();
                    for (String pos : probePositions) {
                        String[] probePositionElements = pos.split("-");
                        if (probePositionElements.length < 2) {
                            System.err.println("ERROR: " + pos + "\tis not parseable for probe: " + (String)probes.get(n));
                            continue;
                        }
                        try {
                            Integer start = Integer.parseInt(probePositionElements[0]);
                            Integer stop = Integer.parseInt(probePositionElements[1]);
                            for (SortableSNP s : snpsOnChr) {
                                int chrPos = s.chrpos;
                                if (chrPos < start || chrPos > stop) continue;
                                snpsInProbe.add(s.id);
                            }
                        }
                        catch (NumberFormatException e) {
                            System.err.println(pos + "\tis not parseable for probe: " + (String)probes.get(n));
                        }
                    }
                    snpsInProbes.put(n, snpsInProbe);
                }
                for (Pair pair : snpProbePairsToTestForThisReferenceDataset) {
                    if (snpProbePairsTestedForThisReferenceDs.contains(pair)) continue;
                    String snp = (String)pair.getLeft();
                    Integer snpId = reference.getSnpToSNPId().get((Object)snp);
                    if (!snpsOnChrStrHash.contains(snp)) continue;
                    snpProbePairsTestedForThisReferenceDs.add(pair);
                    snpProbePairsTested.add(pair);
                    String probe = (String)pair.getRight();
                    Integer probeId = (Integer)probeToId.get(probe);
                    if (probeId == null) {
                        System.err.println("ERROR: no annotation loaded for probe: " + probe);
                        output.writeln(pair.toString() + "\tUNKNOWN: \tProbe annotation not loaded.");
                        String[] qcStrArr = (String[])qcResultsStr.get(pair);
                        if (qcStrArr == null) {
                            qcStrArr = new String[referenceDatasetNames.length];
                        }
                        qcStrArr[d] = "Probe annotation not loaded.";
                        qcResultsStr.put(pair, qcStrArr);
                        qcResultsBoolean.put(pair, null);
                        continue;
                    }
                    HashSet probeSNPs = (HashSet)snpsInProbes.get(probeId);
                    if (probeSNPs.isEmpty()) {
                        output.writeln(pair.toString() + "\tFALSE\tNo SNPs underneath probe in " + referenceDatasetName);
                        String[] qcStrArr = (String[])qcResultsStr.get(pair);
                        if (qcStrArr == null) {
                            qcStrArr = new String[referenceDatasetNames.length];
                        }
                        qcStrArr[d] = "No SNPs underneath probe in " + referenceDatasetName;
                        qcResultsStr.put(pair, qcStrArr);
                        qcResultsBoolean.put(pair, false);
                        continue;
                    }
                    SNP snpObj1 = reference.getSNPObject(snpId);
                    loader.loadGenotypes(snpObj1);
                    String qcStr = "";
                    Boolean failsQC = false;
                    if (snpObj1.getMAF() > this.maf && snpObj1.getHWEP() > this.hwe && snpObj1.getCR() > this.cr) {
                        for (Integer otherSNP : probeSNPs) {
                            SNP snpObj2 = reference.getSNPObject(otherSNP);
                            loader.loadGenotypes(snpObj2);
                            if (snpObj2.getMAF() > this.maf && snpObj2.getHWEP() > this.hwe && snpObj2.getCR() > this.cr) {
                                Pair<Double, Double> ld = ldcalc.getLD(snpObj1, snpObj2, reference, 1, false);
                                if (ld.getLeft() > rSquaredThreshold || ld.getRight() > dPrimeThreshold) {
                                    failsQC = true;
                                    qcStr = qcStr.length() == 0 ? qcStr + snpObj2.getName() + "; TRUE (rsq: " + ld.getLeft() + ",D': " + ld.getRight() + ", MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")" : qcStr + "; " + snpObj2.getName() + "; TRUE (rsq: " + ld.getLeft() + ",D': " + ld.getRight() + ", MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")";
                                } else {
                                    qcStr = qcStr.length() == 0 ? qcStr + snpObj2.getName() + "; FALSE (rsq: " + ld.getLeft() + ",D': " + ld.getRight() + ", MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")" : qcStr + "; " + snpObj2.getName() + "; FALSE (rsq: " + ld.getLeft() + ",D': " + ld.getRight() + ", MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")";
                                }
                            } else {
                                qcStr = qcStr.length() == 0 ? qcStr + snpObj2.getName() + "; UNKNOWN (MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")" : qcStr + "; " + snpObj2.getName() + "; UNKNOWN (MAF: " + snpObj2.getMAF() + ", CR: " + snpObj2.getCR() + ", HWEP: " + snpObj2.getHWEP() + ")";
                            }
                            snpObj2.clearGenotypes();
                            snpObj2 = null;
                        }
                        output.writeln(pair.toString() + "\t" + failsQC + "\t" + qcStr);
                    } else {
                        qcStr = qcStr + "SNP does not pass QC thresholds in " + referenceDatasetName + "(MAF: " + snpObj1.getMAF() + ", CR: " + snpObj1.getCR() + ", HWEP: " + snpObj1.getHWEP() + ")";
                        output.writeln(pair.toString() + qcStr);
                        failsQC = null;
                    }
                    Boolean b = (Boolean)qcResultsBoolean.get(pair);
                    if (b == null && failsQC == null) {
                        qcResultsBoolean.put(pair, null);
                    } else {
                        boolean finalb = false;
                        if (failsQC == null && b != null) {
                            finalb = b;
                        } else if (failsQC != null && b == null) {
                            finalb = failsQC;
                        } else {
                            boolean bb = b;
                            finalb = failsQC != false || bb;
                        }
                        qcResultsBoolean.put(pair, finalb);
                    }
                    String[] qcStrArr = (String[])qcResultsStr.get(pair);
                    if (qcStrArr == null) {
                        qcStrArr = new String[referenceDatasetNames.length];
                    }
                    qcStrArr[d] = qcStr;
                    qcResultsStr.put(pair, qcStrArr);
                    snpObj1.clearGenotypes();
                    snpObj1 = null;
                }
            }
            output.close();
            loader.close();
        }
        TextFile output2 = new TextFile(outputDirectory + "Merged-CombinationsNotTestedByQC.txt", true);
        for (Pair<String, String> p : snpProbePairs) {
            if (snpProbePairsTested.contains(p)) continue;
            output2.writeln(p.toString());
        }
        output2.close();
        TextFile output3 = new TextFile(outputDirectory + "Merged-QCResults.txt", true);
        String header = "SNP-Probe\tFailsQC";
        for (String refDs : referenceDatasetNames) {
            header = header + "\tQCOutput-" + refDs;
        }
        output3.writeln(header);
        for (Pair<String, String> p : snpProbePairs) {
            if (!qcResultsStr.containsKey(p)) continue;
            String[] qcStr = (String[])qcResultsStr.get(p);
            Boolean b = (Boolean)qcResultsBoolean.get(p);
            if (b == null) {
                output3.writeln(p.toString() + "\tUNKNOWN\t" + Strings.concat(qcStr, Strings.tab));
                continue;
            }
            output3.writeln(p.toString() + "\t" + b + "\t" + Strings.concat(qcStr, Strings.tab));
        }
        output3.close();
    }

    public void determineSNPProbePairsWhichMayHaveFalsePositiveEffect(String probeTranslation, String reference, String outdir) throws IOException {
        ProbeTranslation pb = new ProbeTranslation();
        pb.load(probeTranslation);
        TriTyperGenotypeData ds = new TriTyperGenotypeData();
        ds.load(reference);
        String[] snps = ds.getSNPs();
        TextFile output = new TextFile(outdir + "SNPProbeCombosWithPossibleHybArtifacts1Kg.txt", true);
        for (byte chr = 1; chr < 23; chr = (byte)(chr + 1)) {
            ArrayList<SortableSNP> snpsOnChr = new ArrayList<SortableSNP>();
            ArrayList<Integer> probesOnChr = new ArrayList<Integer>();
            int nrProbes = pb.getNumProbes();
            for (int p = 0; p < nrProbes; ++p) {
                if (pb.getProbeChr(p) != chr) continue;
                probesOnChr.add(p);
            }
            for (int s = 0; s < snps.length; ++s) {
                if (ds.getChr(s) != chr) continue;
                snpsOnChr.add(new SortableSNP(snps[s], s, chr, ds.getChrPos(s), SortableSNP.SORTBY.ID));
            }
            System.out.println(snpsOnChr.size() + "\tSNPs on Chr " + chr);
            System.out.println(probesOnChr.size() + "\tProbes on Chr " + chr);
            Collections.sort(snpsOnChr);
            HashMap snpsInProbes = new HashMap();
            for (int p = 0; p < probesOnChr.size(); ++p) {
                String[] elems;
                String actualAnnotation = pb.getActualMappingPosition((Integer)probesOnChr.get(p));
                for (String pos : elems = actualAnnotation.split(":")) {
                    String[] elems2 = pos.split("-");
                    Integer start = Integer.parseInt(elems2[0]);
                    Integer stop = Integer.parseInt(elems2[1]);
                    for (SortableSNP s : snpsOnChr) {
                        int chrPos = s.chrpos;
                        if (chrPos < start || chrPos > stop) continue;
                        HashSet<Integer> snpsInProbe = (HashSet<Integer>)snpsInProbes.get(probesOnChr.get(p));
                        if (snpsInProbe == null) {
                            snpsInProbe = new HashSet<Integer>();
                        }
                        snpsInProbe.add(s.id);
                        snpsInProbes.put(probesOnChr.get(p), snpsInProbe);
                    }
                }
            }
            System.out.println(snpsInProbes.size() + "\tprobes with SNPs");
            SNPLoader loader = ds.createSNPLoader();
            DetermineLD ldcalc = new DetermineLD();
            ProgressBar progress = new ProgressBar(snpsOnChr.size(), "Testing chr: " + chr);
            HashSet<Integer> snpsNotPassingQC = new HashSet<Integer>();
            for (SortableSNP s : snpsOnChr) {
                if (!snpsNotPassingQC.contains(s.id)) {
                    SNP snpObj1 = ds.getSNPObject(s.id);
                    loader.loadGenotypes(snpObj1);
                    if (snpObj1.getMAF() > this.maf && snpObj1.getHWEP() > this.hwe && snpObj1.getCR() > this.cr) {
                        for (int p = 0; p < probesOnChr.size(); ++p) {
                            HashSet snpsInProbe = (HashSet)snpsInProbes.get(probesOnChr.get(p));
                            if (snpsInProbe == null) continue;
                            boolean failsQC = false;
                            String qcStr = "";
                            for (Integer snpInProbe : snpsInProbe) {
                                if (snpsNotPassingQC.contains(snpInProbe)) continue;
                                SNP snpObj2 = ds.getSNPObject(snpInProbe);
                                loader.loadGenotypes(snpObj2);
                                if (snpObj2.getMAF() > this.maf && snpObj2.getHWEP() > this.hwe && snpObj2.getCR() > this.cr) {
                                    Pair<Double, Double> ld = ldcalc.getLD(snpObj1, snpObj2, ds, 1, false);
                                    if (ld.getLeft() > 0.2 || ld.getRight() > 0.2) {
                                        failsQC = true;
                                        qcStr = qcStr + "\t" + snpObj2.getName() + " (" + ld.getLeft() + ", " + ld.getRight() + ")";
                                    }
                                } else {
                                    snpsNotPassingQC.add(snpInProbe);
                                }
                                snpObj2.clearGenotypes();
                            }
                            if (!failsQC) continue;
                            String outputStr = s.name + "\t" + pb.getProbes()[(Integer)probesOnChr.get(p)] + qcStr;
                            output.writeln(outputStr);
                        }
                    } else {
                        snpsNotPassingQC.add(s.id);
                    }
                    snpObj1.clearGenotypes();
                }
                progress.iterate();
            }
            progress.close();
        }
        output.close();
    }
}

