/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.textmeta;

import eqtlmappingpipeline.textmeta.FixedEffectMetaAnalysisTask;
import eqtlmappingpipeline.util.eqtlfilesorter.EQTLFileSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.eQTLTextFile;

public class FixedEffectMetaAnalysis {
    public void run(String filesDir, String output, Integer minimalNrDatasets, Integer minimalNrSamples) throws IOException {
        if (filesDir == null || output == null) {
            throw new IllegalArgumentException("Both input and output directory should be set!");
        }
        if (minimalNrDatasets == null) {
            minimalNrDatasets = 0;
        }
        if (minimalNrSamples == null) {
            minimalNrSamples = 0;
        }
        filesDir = Gpio.formatAsDirectory(filesDir);
        output = Gpio.formatAsDirectory(output);
        if (!Gpio.exists(filesDir)) {
            throw new IllegalArgumentException("Input directory does not seem to exist!");
        }
        String[] filesInDir = Gpio.getListOfFiles(filesDir, "txt");
        if (filesInDir.length == 0 && (filesInDir = Gpio.getListOfFiles(filesDir, "gz")).length == 0) {
            System.err.println("No parseable files found in directory: " + filesDir);
            System.exit(0);
        }
        for (String s : filesInDir) {
            System.out.println("Found text file:\t" + s);
        }
        Gpio.createDir(output);
        EQTL[][] allEQTLs = new EQTL[filesInDir.length][0];
        HashSet<Pair<String, String>> uniqueSNPProbeCombos = new HashSet<Pair<String, String>>();
        HashSet<Pair<String, String>> sharedSNPProbeCombos = new HashSet<Pair<String, String>>();
        for (int f = 0; f < filesInDir.length; ++f) {
            String fileName = filesInDir[f];
            TextFile tf = new TextFile(fileName, false);
            String header = tf.readLine();
            String[] elems = tf.readLineElemsReturnObjects(TextFile.tab);
            ArrayList<EQTL> eqtls = new ArrayList<EQTL>();
            int ctr = 0;
            while (elems != null) {
                if (elems.length > 10) {
                    EQTL e = new EQTL();
                    String string = elems[1];
                    String probe = elems[4];
                    Pair<String, String> p = new Pair<String, String>(string, probe);
                    if (uniqueSNPProbeCombos.contains(p)) {
                        sharedSNPProbeCombos.add(p);
                    } else {
                        uniqueSNPProbeCombos.add(p);
                    }
                    String[] datasetname = new String[]{elems[eQTLTextFile.DATASETNAMES]};
                    Double zscore = Double.parseDouble(elems[eQTLTextFile.METAZ]);
                    Integer[] sampleSize = new Integer[]{Integer.parseInt(elems[eQTLTextFile.DATASETSIZE])};
                    String alleleAssessed = elems[eQTLTextFile.ASESSEDALLELE];
                    String alleles = elems[eQTLTextFile.ASESSEDALLELE - 1];
                    e.setAlleles(alleles);
                    e.setAlleleAssessed(alleleAssessed);
                    e.setZscore(zscore);
                    e.setDatasets(datasetname);
                    e.setDatasetsSamples(sampleSize);
                    e.setProbe(probe);
                    e.setRsName(string);
                    eqtls.add(e);
                    ++ctr;
                }
                elems = tf.readLineElemsReturnObjects(TextFile.tab);
            }
            tf.close();
            allEQTLs[f] = eqtls.toArray(new EQTL[0]);
            System.out.println(eqtls.size() + " QTLs loaded from file: " + fileName);
        }
        System.out.println(uniqueSNPProbeCombos.size() + " unique SNP-probe combinations");
        System.out.println(sharedSNPProbeCombos.size() + " SNP-probe combinations shared with > 1 dataset");
        TextFile outfile = new TextFile(output + "eQTLs.txt", true);
        outfile.writeln(eQTLTextFile.header);
        boolean eqctr = false;
        int nrprocs = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(nrprocs);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(threadPool);
        HashMap<String, Integer> eqtlindex = new HashMap<String, Integer>();
        for (int i = 0; i < allEQTLs.length; ++i) {
            for (int j = 0; j < allEQTLs[i].length; ++j) {
                eqtlindex.put(i + "-" + allEQTLs[i][j].getRsName() + "-" + allEQTLs[i][j].getProbe(), j);
            }
        }
        int submitted = 0;
        for (Pair pair : uniqueSNPProbeCombos) {
            FixedEffectMetaAnalysisTask t = new FixedEffectMetaAnalysisTask(eqtlindex, pair, filesInDir, allEQTLs, minimalNrDatasets, minimalNrSamples);
            pool.submit(t);
            ++submitted;
        }
        System.out.println(submitted + " eQTLs meta-analyzing");
        int received = 0;
        ProgressBar progressBar = new ProgressBar(submitted, "Running meta-analysis.");
        while (received < submitted) {
            try {
                Future future = pool.take();
                String outputStr = (String)future.get();
                if (outputStr != null) {
                    outfile.writeln(outputStr);
                }
                progressBar.set(++received);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException ex) {
                Logger.getLogger(FixedEffectMetaAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        progressBar.close();
        outfile.close();
        System.out.println("Done. Now sorting results");
        EQTLFileSorter sorter = new EQTLFileSorter();
        sorter.run(output + "eQTLs.txt", output + "eQTLs_sorted.txt");
        if (Gpio.exists(output + "eQTLs_sorted.txt")) {
            Gpio.moveFile(output + "eQTLs_sorted.txt", output + "eQTLs.txt");
        }
    }
}

