/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.qcpca;

import eqtlmappingpipeline.qcpca.QCPCA;

public class QCPCAConsoleGui {
    public QCPCAConsoleGui(String[] args) {
        String settingsfile = null;
        String settingstexttoreplace = null;
        String settingstexttoreplacewith = null;
        String in = null;
        String out = null;
        boolean cis = false;
        boolean trans = false;
        boolean perm = true;
        String outtype = "text";
        String inexp = null;
        String inexpplatform = null;
        String inexpannot = null;
        String gte = null;
        String snpfile = null;
        Integer threads = null;
        boolean performEigenvectorQTLMapping = false;
        boolean inventorize = false;
        boolean inventorizepcqtl = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String val = null;
            if (i + 1 < args.length) {
                val = args[i + 1];
            }
            if (arg.equals("--settings")) {
                settingsfile = val;
                continue;
            }
            if (arg.equals("--replacetext")) {
                settingstexttoreplace = val;
                continue;
            }
            if (arg.equals("--replacetextwith")) {
                settingstexttoreplacewith = val;
                continue;
            }
            if (arg.equals("--in")) {
                in = val;
                continue;
            }
            if (arg.equals("--out")) {
                out = val;
                continue;
            }
            if (arg.equals("--inexp")) {
                inexp = val;
                continue;
            }
            if (arg.equals("--inexpplatform")) {
                inexpplatform = val;
                continue;
            }
            if (arg.equals("--inexpannot")) {
                inexpannot = val;
                continue;
            }
            if (arg.equals("--gte")) {
                gte = val;
                continue;
            }
            if (arg.equals("--pcqtl")) {
                performEigenvectorQTLMapping = true;
                continue;
            }
            if (arg.equals("--inventorize")) {
                inventorize = true;
                continue;
            }
            if (arg.equals("--snps")) {
                snpfile = val;
                continue;
            }
            if (arg.equals("--inventorize-pcqtl")) {
                inventorize = true;
                inventorizepcqtl = true;
                continue;
            }
            if (!arg.equals("--threads")) continue;
            try {
                threads = Integer.parseInt(val);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("Error --threads should be an integer");
            }
        }
        try {
            if (in == null || inexp == null || out == null) {
                System.out.println("ERROR: Please supply --in, --inexp and --out");
                this.printUsage();
            } else {
                QCPCA q = new QCPCA();
                q.run(inexp, inexpplatform, in, gte, inexpannot, out, snpfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void printUsage() {
        System.out.print("\tQCPCA\n-------------------------------------------------------------------------------\n");
        System.out.println("QCPCA performs principal component analysis on the genotype and gene expression data in order to detect for example population stratification effects.");
        System.out.print("\nExamples\n-------------------------------------------------------------------------------\n");
        System.out.println("Example using commandline:\tjava -jar eQTLMappingPipeline.jar --mode qcpca --in /path/to/GenotypeMatrix.dat/ --out /path/to/output/ --inexp /path/to/expressiondata.txt --inexpannot /path/to/annotation.txt --gte /path/to/genotypetoexpressioncoupling.txt");
        System.out.println("");
        System.out.print("Command line options:\n-------------------------------------------------------------------------------\n");
        System.out.println("--in\t\t\tdir\t\tLocation of the genotype data\n--out\t\t\tdir\t\tLocation where the output should be stored\n--inexp\t\t\tstring\t\tLocation of expression data\n--inexpplatform\t\tstring\t\tGene expression platform\n--inexpannot\t\tstring\t\tLocation of annotation file for gene expression data\n--gte\t\t\tstring\t\tLocation of genotype to expression coupling file\n--snps\t\t\tstring\t\tDon't prune SNPs, but use list of pruned SNPs (eg. generated by PLINK)");
        System.out.println("");
    }
}

