/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.pcaoptimum;

import eqtlmappingpipeline.graphics.Graphics;

public class PCAOptimumPlot
extends Graphics {
    PCAOptimumPlot(int i, int i0, boolean b, String out) {
        super(i, i0, b, out);
    }

    public void plot(double[] cisx, double[] cisy, double[] transx, double[] transy, int cisOrig, int cisNew, int cisShared, int transOrig, int transNew, int transShared) {
        int width = this.graphWidth;
        int height = this.graphHeight;
        int margin = 50;
        int plotwidth = (width - 3 * margin) / 2;
        int plotheight = (height - 3 * margin) / 2;
        this.scatterplot(cisx, cisy, plotwidth, plotheight, margin, margin);
        this.scatterplot(transx, transy, plotwidth, plotheight, margin, 2 * margin + plotheight);
    }

    private void scatterplot(double[] x, double[] y, int plotwidth, int plotheight, int offsetx, int offsety) {
        double maxX = this.max(x);
        double minX = this.min(x);
        double maxY = this.max(y);
        double minY = this.min(y);
        double rangeX = this.getrange(minX, maxX);
        double rangeY = this.getrange(minY, maxY);
        this.setColor(0, 0, 0, 255);
        int xCoord = (int)Math.floor(Math.abs(0.0 - minX) / rangeX * (double)plotwidth) + offsetx;
        int yCoord = (int)Math.floor(Math.abs(0.0 - minY) / rangeY * (double)plotheight) + offsety;
        this.drawLine(offsetx, yCoord, offsetx + plotwidth, yCoord);
        this.drawLine(xCoord, offsety, xCoord, plotheight + offsety);
        this.setColor(0, 0, 0, 128);
        for (int i = 0; i < x.length; ++i) {
            xCoord = (int)Math.floor(Math.abs(x[i] - minX) / rangeX * (double)plotwidth);
            yCoord = (int)Math.floor(Math.abs(y[i] - minY) / rangeY * (double)plotwidth);
            this.g2d.fillOval(xCoord, yCoord, 2, 2);
        }
    }

    public double max(double[] x) {
        double max = Double.MIN_VALUE;
        for (double d : x) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public double min(double[] x) {
        double min = Double.MAX_VALUE;
        for (double d : x) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public double getrange(double min, double max) {
        double range = 0.0;
        if (min < 0.0 && max < 0.0) {
            range = Math.abs(min) - Math.abs(max);
        }
        if (min < 0.0 && max > 0.0) {
            range = Math.abs(min) + max;
        }
        if (min > 0.0 && max > 0.0) {
            range = max - min;
        }
        return range;
    }
}

