/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.pcaoptimum;

import eqtlmappingpipeline.metaqtl3.FDR;
import eqtlmappingpipeline.metaqtl3.MetaQTL3;
import eqtlmappingpipeline.metaqtl3.containers.Settings;
import eqtlmappingpipeline.normalization.Normalizer;
import eqtlmappingpipeline.pcaoptimum.PCAOptimumInventorize;
import eqtlmappingpipeline.pcaoptimum.PCAOptimumPlot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.eQTLTextFile;
import umcg.genetica.text.Strings;

public class PCAOptimum
extends MetaQTL3 {
    protected String inexpplatform;
    protected String inexpannot;
    protected String ingt;
    protected String gte;
    protected Integer m_threads = 1;
    protected int permutations = 10;
    protected boolean covariatesremoved = false;
    protected String cissnps;
    protected String transsnps;
    private boolean performEigenVectorQTLMapping;

    public void setCovariatesRemoved(boolean b) {
        this.covariatesremoved = b;
    }

    public void setSNPSets(String cissnps, String transsnps) {
        this.cissnps = cissnps;
        this.transsnps = transsnps;
    }

    public void setPerformpcqtlNormalization(boolean performEigenvectorQTLMapping) {
        this.performEigenVectorQTLMapping = performEigenvectorQTLMapping;
    }

    @Override
    public void initialize(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String texttoreplace2, String texttoreplace2with, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads, Integer maxNrResults, String regressouteqtls, String snpprobecombofile, boolean skipdotplot, boolean skipqqplot, Long rseed, Double maf, Double hwe) throws IOException, Exception {
        String outputdir;
        TextFile tf;
        if (!out.endsWith("/")) {
            out = out + "/";
        }
        if (!Gpio.exists(out)) {
            Gpio.createDir(out);
        }
        this.permutations = perm;
        String origInExp = inexp;
        this.m_settings = new Settings();
        int nrProcs = Runtime.getRuntime().availableProcessors();
        if (threads != null && threads > 0 && threads <= nrProcs) {
            this.m_threads = threads;
        } else {
            if (threads != null && threads > nrProcs) {
                System.out.println("The number of threads you set using the command line is not correct for your system. You set " + threads + " threads, while your machine has " + nrProcs + " processors");
            }
            threads = nrProcs;
        }
        this.m_threads = threads;
        boolean round = false;
        HashSet<String> cisSnpsToTest = new HashSet<String>();
        HashSet<String> transSnpsToTest = new HashSet<String>();
        cis = this.cissnps != null;
        trans = this.transsnps != null;
        if (cis) {
            System.out.println("Loading cis SNP set from: " + this.cissnps);
            tf = new TextFile(this.cissnps, false);
            cisSnpsToTest.addAll(tf.readAsArrayList());
            tf.close();
        }
        if (trans) {
            System.out.println("Loading trans SNP set from: " + this.transsnps);
            tf = new TextFile(this.transsnps, false);
            transSnpsToTest.addAll(tf.readAsArrayList());
            tf.close();
        }
        if (!(outputdir = out + "Cis-0PCAsRemoved").endsWith("/")) {
            outputdir = outputdir + "/";
        }
        if (!Gpio.exists(outputdir)) {
            Gpio.createDir(outputdir);
        }
        this.inexpannot = inexpannot;
        this.inexpplatform = inexpplatform;
        this.ingt = ingt;
        this.gte = gte;
        String parentDir = Gpio.getParentDir(origInExp);
        System.out.println("Looking for PCA corrected files in folder: " + parentDir);
        String[] fileList = Gpio.getListOfFiles(parentDir);
        ArrayList<Integer> pcs = new ArrayList<Integer>();
        HashMap<Integer, String> stepToFile = new HashMap<Integer, String>();
        block0: for (String f : fileList) {
            String[] fileParts;
            if (!f.toLowerCase().contains("pcasoversamplesremoved") || f.toLowerCase().contains("geneticvectorsnotremoved")) continue;
            for (String p : fileParts = f.split("\\.")) {
                if (!p.toLowerCase().contains("pcasoversamplesremoved")) continue;
                Integer pc = Integer.parseInt(p.toLowerCase().replace("pcasoversamplesremoved", ""));
                pcs.add(pc);
                stepToFile.put(pc, f);
                System.out.println("Found file for PC: " + pc + "\t" + f);
                continue block0;
            }
        }
        if (pcs.isEmpty()) {
            System.out.println("No PCA corrected files.\n Please first run the normalization procedure.");
            System.exit(0);
        }
        Collections.sort(pcs);
        int max = 0;
        int stepSize = 0;
        for (int i = 0; i < pcs.size() - 1; ++i) {
            if (i == 0 && (Integer)pcs.get(pcs.size() - 1) > max) {
                max = (Integer)pcs.get(pcs.size() - 1);
            }
            if ((Integer)pcs.get(i) > max) {
                max = (Integer)pcs.get(i);
            }
            stepSize += (Integer)pcs.get(i + 1) - (Integer)pcs.get(i);
        }
        if (pcs.size() > 1) {
            if ((double)stepSize / (double)(pcs.size() - 1) % 1.0 != 0.0) {
                System.out.println("Step size is invalid.\n Please look in to the input directory for missing files");
                System.out.println((double)stepSize / (double)(pcs.size() - 1) % 1.0);
                System.exit(0);
            }
            stepSize = (int)((double)stepSize / (double)(pcs.size() - 1));
        } else {
            stepSize = (Integer)pcs.get(0);
            max = (Integer)pcs.get(0);
        }
        System.out.println("Determined max: " + max);
        System.out.println("Determined stepsize: " + stepSize);
        if (this.performEigenVectorQTLMapping) {
            this.performeQTLMappingOverEigenvectorMatrixAndReNormalize(origInExp, out, parentDir, stepSize, max, maxNrResults);
            fileList = Gpio.getListOfFiles(parentDir);
            pcs = new ArrayList();
            stepToFile = new HashMap();
            block3: for (String f : fileList) {
                String[] fileParts;
                if (!f.toLowerCase().contains("pcasoversamplesremoved-geneticvectorsnotremoved")) continue;
                for (String p : fileParts = f.split("\\.")) {
                    if (!p.toLowerCase().contains("pcasoversamplesremoved-geneticvectorsnotremoved")) continue;
                    Integer pc = Integer.parseInt(p.toLowerCase().replace("pcasoversamplesremoved-geneticvectorsnotremoved", ""));
                    pcs.add(pc);
                    stepToFile.put(pc, f);
                    System.out.println("Found file for PC: " + pc + "\t" + f);
                    continue block3;
                }
            }
        }
        String nextInExp = "";
        for (int pca = 0; pca <= max; pca += stepSize) {
            nextInExp = pca == 0 ? origInExp : parentDir + "/" + (String)stepToFile.get(pca);
            if (!Gpio.exists(nextInExp)) {
                System.err.println("Could not find file for pca: " + pca + "\t" + nextInExp);
                continue;
            }
            if (cis) {
                String outputDir = out + "Cis-" + pca + "PCAsRemoved/";
                if (this.performEigenVectorQTLMapping && pca > 0) {
                    outputDir = out + "Cis-" + pca + "PCAsRemoved-GeneticVectorsNotRemoved/";
                }
                if (pca == 0 && !Gpio.exists(outputDir + "eQTLProbesFDR0.05.txt") || pca > 0) {
                    this.performeQTLMapping(true, false, nextInExp, outputDir, cisSnpsToTest, null, threads, maxNrResults);
                    this.cleanup();
                }
            }
            if (!trans) continue;
            String outputDir = out + "Trans-" + pca + "PCAsRemoved/";
            if (this.performEigenVectorQTLMapping && pca > 0) {
                outputDir = out + "Trans-" + pca + "PCAsRemoved-GeneticVectorsNotRemoved/";
            }
            if ((pca != 0 || Gpio.exists(outputDir + "eQTLProbesFDR0.05.txt")) && pca <= 0) continue;
            this.performeQTLMapping(false, true, nextInExp, outputDir, transSnpsToTest, null, threads, maxNrResults);
            this.cleanup();
        }
        PCAOptimumInventorize pi = new PCAOptimumInventorize();
        if (this.performEigenVectorQTLMapping) {
            pi.inventorypcqtl(out, cis, trans, max, stepSize);
        } else {
            pi.inventory(out, cis, trans, max, stepSize);
        }
    }

    protected void init() throws IOException, Exception {
        int numDatasets = 1;
        this.m_gg = new TriTyperGeneticalGenomicsDataset[numDatasets];
        this.numAvailableInds = 0;
        for (int i = 0; i < numDatasets; ++i) {
            System.out.println("- Loading dataset: " + this.m_settings.datasetSettings.get((int)i).name + "");
            System.out.println("-------------------------------------------------------------------------------\n");
            this.m_gg[i] = new TriTyperGeneticalGenomicsDataset(this.m_settings.datasetSettings.get(i));
            if (!this.m_settings.performParametricAnalysis) {
                this.m_gg[i].getExpressionData().rankAllExpressionData(this.m_settings.equalRankForTies);
            }
            this.m_gg[i].getExpressionData().calcAndSubtractMean();
            this.m_gg[i].getExpressionData().calcMeanAndVariance();
            this.numAvailableInds += this.m_gg[i].getExpressionToGenotypeIdArray().length;
            System.out.println("-------------------------------------------------------------------------------\n");
            System.out.println("");
        }
        Arrays.sort(this.m_gg, Collections.reverseOrder());
        System.out.println("Accumulating available data...");
        System.out.print("-------------------------------------------------------------------------------\n");
        this.createSNPList();
        this.createProbeList();
        this.determineSNPProbeCombinations();
        if (this.m_workPackages == null || this.m_workPackages.length == 0) {
            System.err.println("Error: No work detected");
            System.exit(0);
        }
        if (this.m_settings.nrThreads == null) {
            this.m_settings.nrThreads = Runtime.getRuntime().availableProcessors();
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            if (this.m_settings.nrThreads > numProcs || this.m_settings.nrThreads < 1) {
                this.m_settings.nrThreads = numProcs;
            }
        }
        if (this.m_workPackages.length < this.m_settings.nrThreads) {
            this.m_settings.nrThreads = this.m_workPackages.length;
        }
        this.printSummary();
    }

    protected void cleanup() {
        for (int i = 0; i < this.m_gg.length; ++i) {
            this.m_gg[i] = null;
        }
        this.m_probeList = null;
        this.m_probeTranslationTable = null;
        this.m_snpList = null;
        this.m_snpTranslationTable = null;
        this.m_workPackages = null;
    }

    protected void performeQTLMapping(boolean cis, boolean trans, String inFile, String out, HashSet<String> snpsToTest, HashSet<String> probesToTest, int threads, Integer maxNrResults) throws IOException, Exception {
        String nextInExp = inFile;
        String outputdir = out;
        if (!Gpio.exists(outputdir)) {
            Gpio.createDir(outputdir);
        }
        this.m_settings = new Settings();
        TriTyperGeneticalGenomicsDatasetSettings s = new TriTyperGeneticalGenomicsDatasetSettings();
        s.name = "Dataset";
        s.expressionLocation = nextInExp;
        System.out.println(nextInExp);
        s.expressionplatform = this.inexpplatform;
        s.probeannotation = this.inexpannot;
        s.genotypeLocation = this.ingt;
        s.genotypeToExpressionCoupling = this.gte;
        s.cisAnalysis = cis;
        s.transAnalysis = trans;
        if (probesToTest != null) {
            s.tsProbesConfine = probesToTest;
        }
        this.m_settings.datasetSettings = new ArrayList();
        this.m_settings.datasetSettings.add(s);
        this.m_settings.ciseQTLAnalysMaxSNPProbeMidPointDistance = cis ? 250000 : 5000000;
        this.m_settings.nrThreads = threads;
        this.m_settings.cisAnalysis = cis;
        this.m_settings.transAnalysis = trans;
        this.m_settings.nrPermutationsFDR = this.permutations;
        this.m_settings.tsSNPsConfine = snpsToTest;
        if (probesToTest != null) {
            this.m_settings.tsProbesConfine = probesToTest;
        }
        this.m_settings.outputReportsDir = outputdir;
        this.m_settings.createTEXTOutputFiles = true;
        this.m_settings.createBinaryOutputFiles = false;
        this.m_settings.randomNumberGenerator = new Random(this.m_settings.rSeed);
        this.m_settings.fdrType = FDR.FDRMethod.FULL;
        if (maxNrResults != null) {
            this.m_settings.maxNrMostSignificantEQTLs = maxNrResults;
        }
        this.init();
        super.mapEQTLs();
        this.cleanup();
    }

    protected void compareZScores(EQTL[] ciseqtls, EQTL[] transeqtls, EQTL[] originalCisEQTLs, EQTL[] originalTransEQTLs, String out, int pca) {
        EQTL origE;
        HashMap<String, EQTL> origCis = new HashMap<String, EQTL>();
        HashMap<String, EQTL> origTrans = new HashMap<String, EQTL>();
        for (EQTL e : originalCisEQTLs) {
            origCis.put(e.getRsName() + "///" + e.getProbe(), e);
        }
        for (EQTL e : originalTransEQTLs) {
            origTrans.put(e.getRsName() + "///" + e.getProbe(), e);
        }
        int cisShared = 0;
        int transShared = 0;
        ArrayList<Double> cisXAL = new ArrayList<Double>();
        ArrayList<Double> cisYAL = new ArrayList<Double>();
        ArrayList<Double> transXAL = new ArrayList<Double>();
        ArrayList<Double> transYAL = new ArrayList<Double>();
        for (EQTL e : ciseqtls) {
            origE = (EQTL)origTrans.get(e.getRsName() + "///" + e.getProbe());
            if (origE == null) continue;
            ++cisShared;
            cisXAL.add(e.getZscore());
            cisYAL.add(origE.getZscore());
        }
        for (EQTL e : transeqtls) {
            origE = (EQTL)origTrans.get(e.getRsName() + "///" + e.getProbe());
            if (origE == null) continue;
            ++transShared;
            transXAL.add(e.getZscore());
            transYAL.add(origE.getZscore());
        }
        double[] cisx = this.toArray(cisXAL);
        double[] cisy = this.toArray(cisYAL);
        double[] transx = this.toArray(transXAL);
        double[] transy = this.toArray(transYAL);
        PCAOptimumPlot p = new PCAOptimumPlot(500, 1000, true, out);
        p.plot(cisx, cisy, transx, transy, originalCisEQTLs.length, ciseqtls.length, cisShared, originalTransEQTLs.length, transeqtls.length, transShared);
        p.draw(out);
    }

    protected double[] toArray(ArrayList<Double> x) {
        double[] y = new double[x.size()];
        int i = 0;
        for (Double z : x) {
            y[i] = z;
            ++i;
        }
        return y;
    }

    public void performeQTLMappingOverEigenvectorMatrixAndReNormalize(String origInExp, String out, String parentDir, int stepSize, int max, Integer maxNrResults) throws IOException, Exception {
        Normalizer n;
        TextFile tf = new TextFile(origInExp, false);
        String[] header = tf.readLineElems(TextFile.tab);
        int nrCols = header.length;
        tf.close();
        int nrToRemove = max + 1;
        HashSet<String> probesToTest = new HashSet<String>();
        for (int i = 1; i < nrToRemove; ++i) {
            probesToTest.add("Comp" + i);
        }
        parentDir = parentDir + Gpio.getFileSeparator();
        String[] files = Gpio.getListOfFiles(parentDir);
        String pcaOverSampleEigenVectorsTransposedFile = null;
        boolean desiredMaxThresholdExict = false;
        for (String file : files) {
            if (file.toLowerCase().contains("pcaoversampleseigenvectorstransposed")) {
                pcaOverSampleEigenVectorsTransposedFile = parentDir + "" + file;
            }
            if (!file.toLowerCase().contains(max + "PCAsOverSamplesRemoved.txt.gz")) continue;
            desiredMaxThresholdExict = true;
        }
        if (pcaOverSampleEigenVectorsTransposedFile == null) {
            System.out.println("Error! Could not find pcaOverSampleEigenVectorsTransposedFile");
            System.exit(0);
        }
        String nextInExp = pcaOverSampleEigenVectorsTransposedFile;
        this.performeQTLMapping(true, true, nextInExp, out + "CisTrans-PCAEigenVectors/", this.m_settings.tsSNPsConfine, probesToTest, this.m_threads, maxNrResults);
        this.cleanup();
        eQTLTextFile etf = new eQTLTextFile(out + "CisTrans-PCAEigenVectors/eQTLProbesFDR0.05.txt", false);
        EQTL[] eigenvectorEQTLs = etf.read();
        etf.close();
        HashSet<Integer> geneticEigenVectors = new HashSet<Integer>();
        for (EQTL e : eigenvectorEQTLs) {
            String probe;
            Integer compId;
            Double fdr = e.getFDR();
            if (fdr == null || fdr != 0.0 || (compId = Integer.valueOf(Integer.parseInt((probe = e.getProbe()).replace("Comp", "")))) <= 1) continue;
            geneticEigenVectors.add(compId);
        }
        System.out.println("These PCs are under genetic control: " + Strings.concat((Object[])geneticEigenVectors.toArray(new Integer[0]), Strings.comma));
        System.out.println();
        if (geneticEigenVectors.size() > 0) {
            n = new Normalizer();
            n.repeatPCAOmitCertainPCAs(geneticEigenVectors, parentDir, origInExp, max, stepSize);
        } else if (!desiredMaxThresholdExict) {
            n = new Normalizer();
            n.repeatPCAOmitCertainPCAs(geneticEigenVectors, parentDir, origInExp, max, stepSize);
        } else {
            System.out.println("No PCA vectors seem to be genetically associated.");
            System.exit(0);
        }
    }

    public void alternativeInitialize(String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, String snpfile, Integer threads) throws IOException, Exception {
        if (!out.endsWith(Gpio.getFileSeparator())) {
            out = out + Gpio.getFileSeparator();
        }
        if (!Gpio.exists(out)) {
            Gpio.createDir(out);
        }
        this.permutations = perm;
        this.m_settings = new Settings();
        int nrProcs = Runtime.getRuntime().availableProcessors();
        if (threads != null && threads > 0 && threads <= nrProcs) {
            this.m_threads = threads;
        } else {
            if (threads != null && threads > nrProcs) {
                System.out.println("The number of threads you set using the command line is not correct for your system. You set " + threads + " threads, while your machine has " + nrProcs + " processors");
            }
            threads = nrProcs;
        }
        this.m_threads = threads;
        cis = this.cissnps != null;
        trans = this.transsnps != null;
        this.inexpannot = inexpannot;
        this.inexpplatform = inexpplatform;
        this.ingt = ingt;
        this.gte = gte;
        if (snpfile != null) {
            TextFile f = new TextFile(snpfile, false);
            this.m_settings.tsSNPsConfine = new HashSet<String>(f.readAsArrayList());
        }
        this.m_settings.createDotPlot = false;
        this.m_settings.createQQPlot = false;
        this.m_settings.fullFdrOutput = false;
    }
}

