/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.mixupmapper.stat.dist;

import java.util.ArrayList;
import java.util.Collections;

public class Dist {
    protected double max = 0.0;
    protected double min = 0.0;
    protected double var = 0.0;
    protected double se = 0.0;
    protected double mean = 0.0;
    protected double median = 0.0;

    public void createDist(ArrayList<Double> alValues) {
        this.max = Collections.max(alValues);
        this.min = Collections.min(alValues);
        this.calcStatistics(alValues);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getVariance() {
        return this.var;
    }

    public void setVariance(double newVar) {
        this.var = newVar;
    }

    public double getSD() {
        return Math.sqrt(this.var);
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double newMedian) {
        this.median = newMedian;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double newMean) {
        this.mean = newMean;
    }

    protected void calcStatistics(ArrayList<Double> alValues) {
        double total = 0.0;
        for (Double val : alValues) {
            total += val.doubleValue();
        }
        int size = alValues.size();
        this.mean = total / (double)size;
        this.var = 0.0;
        for (Double val : alValues) {
            this.var += (val - this.mean) * (val - this.mean);
        }
        Collections.sort(alValues);
        this.median = 0.0;
        if (size % 2 == 0) {
            int mediantop = (int)((double)(size / 2) + 0.5);
            int medianbottom = (int)((double)(size / 2) - 0.5);
            this.median = (alValues.get(mediantop) + alValues.get(medianbottom)) / 2.0;
        } else {
            int index = (int)((double)(size / 2) + 0.5);
            this.median = alValues.get(index);
        }
    }
}

