/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.mixupmapper.stat.dist;

import eqtlmappingpipeline.graphics.histogram.FrequencyDistributionHistogram;
import eqtlmappingpipeline.graphics.histogram.Histogram;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.Dist;
import java.util.ArrayList;
import java.util.Collections;

public class DiscreteDist
extends Dist {
    private double binInterval = 0.0;
    private int numTotalValues = 0;
    private Bin[] bins;
    private int binIterator = 0;

    public void createDist(double _min, double _max, int numBins) {
        this.min = _min;
        this.max = _max;
        this.createBins(numBins);
    }

    public void createDist(ArrayList<Double> alValues, int numBins) {
        double _max = Collections.max(alValues);
        double _min = Collections.min(alValues);
        this.createDist(alValues, numBins, _min, _max);
    }

    public void createDist(ArrayList<Double> alValues, int numBins, double _min, double _max) {
        this.min = _min;
        this.max = _max;
        this.createBins(numBins);
        if (alValues != null) {
            double dBinNum = 0.0;
            int iBinNum = 0;
            for (Double value : alValues) {
                double dValue = value;
                dBinNum = (dValue - this.min) / this.binInterval;
                iBinNum = (int)Math.floor(dBinNum);
                if (iBinNum >= this.bins.length) {
                    --iBinNum;
                }
                if (iBinNum < this.bins.length) {
                    this.bins[iBinNum].add();
                    ++this.numTotalValues;
                    continue;
                }
                System.out.println("could not include value: " + value + " because it falls out of the range: " + this.min + "-" + this.max);
            }
        }
    }

    public double getBinInterval() {
        return this.binInterval;
    }

    public int getTotalNumValues() {
        return this.numTotalValues;
    }

    public void setTotalNumValues(int total) {
        this.numTotalValues = total;
    }

    public int getNumBins() {
        return this.bins.length;
    }

    public void calcCumulative() {
        int add = 0;
        for (int binNum = 0; binNum < this.bins.length; ++binNum) {
            if (this.bins[binNum] == null) continue;
            this.bins[binNum].setCumulative(0);
            this.bins[binNum].setCumulative(add += this.bins[binNum].getCount());
        }
    }

    public void plot(String outfile) {
        Histogram hist = new Histogram(512, 512);
        hist.plot(this);
        hist.draw(outfile);
    }

    public void plotFreqDist(String outfile) {
        FrequencyDistributionHistogram hist = new FrequencyDistributionHistogram(512, 512);
        hist.plot(this);
        hist.draw(outfile);
    }

    public boolean hasNext() {
        return this.binIterator < this.bins.length;
    }

    public Bin getNext() {
        if (this.binIterator < this.bins.length) {
            Bin currentBin = this.bins[this.binIterator];
            ++this.binIterator;
            return currentBin;
        }
        return null;
    }

    public Bin getPrev() {
        if (this.binIterator - 1 >= 0 && this.binIterator - 1 < this.bins.length - 1) {
            Bin currentBin = this.bins[this.binIterator - 1];
            return currentBin;
        }
        return null;
    }

    public void resetIterator() {
        this.binIterator = 0;
    }

    public void convertToFrequency(int total) {
        for (int binNum = 0; binNum < this.bins.length; ++binNum) {
            if (this.bins[binNum] == null) continue;
            this.bins[binNum].calcFrequency(total);
        }
    }

    public void addToBin(int binNum) {
        this.bins[binNum].add();
        ++this.numTotalValues;
    }

    private void createBins(int numBins) {
        this.bins = new Bin[numBins];
        double range = this.max - this.min;
        double lower = this.min;
        this.binInterval = range / (double)numBins;
        for (int binId = 0; binId < numBins; ++binId) {
            this.bins[binId] = new Bin(lower, lower + this.binInterval);
            lower += this.binInterval;
        }
    }
}

