/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.mixupmapper.containers;

public class Matrix {
    private double[][] mat;
    private String[] rowNames;
    private String[] colNames;

    public Matrix(int numRows, int numCols) {
        this.mat = new double[numRows][numCols];
    }

    public void addRow(int rowIndex, double[] row) {
        this.mat[rowIndex] = row;
    }

    public void setRowNames(String[] r) {
        this.rowNames = r;
    }

    public void setColNames(String[] c) {
        this.colNames = c;
    }

    public double[][] getMatrix() {
        return this.mat;
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public void setMatrix(double[][] matrix) {
        this.mat = matrix;
    }

    public void scaleAndCenterOverRows() {
        if (this.mat.length > 0) {
            for (int row = 0; row < this.mat.length; ++row) {
                double sum = 0.0;
                for (int col = 0; col < this.mat[row].length; ++col) {
                    sum += this.mat[row][col];
                }
                double mean = sum / (double)this.mat[row].length;
                double diff = 0.0;
                for (int col = 0; col < this.mat[row].length; ++col) {
                    diff += (this.mat[row][col] - mean) * (this.mat[row][col] - mean);
                }
                double sd = Math.sqrt(diff / (double)this.mat[row].length);
                for (int col = 0; col < this.mat[row].length; ++col) {
                    this.mat[row][col] = (this.mat[row][col] - mean) / sd;
                }
            }
        }
    }

    public void scaleAndCenterOverCols() {
        if (this.mat.length > 0) {
            for (int i = 0; i < this.mat[0].length; ++i) {
                double[] col = new double[this.mat.length];
                double sum = 0.0;
                for (int j = 0; j < this.mat.length; ++j) {
                    col[j] = this.mat[j][i];
                    sum += col[j];
                }
                double mean = sum / (double)this.mat.length;
                double diff = 0.0;
                for (int j = 0; j < this.mat.length; ++j) {
                    diff += (col[j] - mean) * (col[j] - mean);
                }
                double sd = Math.sqrt(diff / (double)this.mat.length);
                for (int j = 0; j < this.mat.length; ++j) {
                    this.mat[j][i] = (col[j] - mean) / sd;
                }
            }
        }
    }

    public double[] asArray() {
        double[] output = new double[this.mat.length * this.mat[0].length];
        int combos = 0;
        for (int i = 0; i < this.mat.length; ++i) {
            for (int j = 0; j < this.mat[i].length; ++j) {
                output[combos] = this.mat[i][j];
                ++combos;
            }
        }
        return output;
    }
}

