/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.mixupmapper;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.graphics.curve.ROCCurve;
import eqtlmappingpipeline.graphics.histogram.MultiFrequencyDistributionHistogram;
import eqtlmappingpipeline.graphics.map.MixupMapperHeatMap;
import eqtlmappingpipeline.mixupmapper.containers.Trio;
import eqtlmappingpipeline.mixupmapper.stat.dist.Bin;
import eqtlmappingpipeline.mixupmapper.stat.dist.DiscreteDist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.TTest;

public class MixupMapperVisualization {
    private double[][] TPR = null;
    private double[][] FPR = null;
    private double[] AUC;
    private boolean loadedFamilyData;
    private static final double LOG10SCALE = 1.0 / Math.log(10.0);
    private HashMap<String, Trio> sampleToTrio;
    private HashMap<String, String> etg;
    private HashMap<String, String> gte;
    private TextFile textOutput;

    public void createROC(DoubleMatrixDataset<String, String> result, HashMap<String, String> genotypeToTrait, HashMap<String, String> traitToGenotype, String outputLoc) throws IOException {
        this.textOutput = new TextFile(outputLoc + "ROC.txt", true);
        this.etg = traitToGenotype;
        this.gte = genotypeToTrait;
        String[] rowNames = result.rowObjects.toArray(new String[0]);
        String[] colNames = result.colObjects.toArray(new String[0]);
        double[][] matrix = result.rawData;
        int numPositives = traitToGenotype.size();
        int matrixSize = rowNames.length * colNames.length;
        int numTP = numPositives;
        int numTN = matrixSize - numTP;
        int tp = 0;
        int tn = 0;
        double[] truePosValues = new double[numTP];
        double[] trueNegValues = new double[numTN];
        if (this.loadedFamilyData) {
            int numParents = 0;
            for (int r = 0; r < matrix.length; ++r) {
                String rowName = rowNames[r];
                String coupledGenotype = this.etg.get(rowName);
                Trio relatives = this.sampleToTrio.get(coupledGenotype);
                boolean isChild = false;
                if (relatives == null) continue;
                if (relatives.child.sampleName.equals(coupledGenotype)) {
                    isChild = true;
                }
                for (int c = 0; c < matrix[matrix.length - 1].length; ++c) {
                    String colName = colNames[c];
                    boolean valueIsFromRelative = false;
                    if (isChild) {
                        if (colName.equals(relatives.parent1.sampleName) || colName.equals(relatives.parent2.sampleName)) {
                            valueIsFromRelative = true;
                        }
                    } else if (colName.equals(relatives.child.sampleName)) {
                        valueIsFromRelative = true;
                    }
                    if (!valueIsFromRelative) continue;
                    ++numParents;
                }
            }
            System.out.println("Num relatives: " + numParents);
            if (numParents > 0) {
                double[] truePosMinFamilyValues = new double[numTP];
                double[] trueNegMinFamilyValues = new double[numTN - numParents];
                double[] parentValues = new double[numParents];
                numParents = 0;
                int tpc = 0;
                int tnc = 0;
                for (int r = 0; r < matrix.length; ++r) {
                    String rowName = rowNames[r];
                    String coupledGenotype = this.etg.get(rowName);
                    Trio relatives = this.sampleToTrio.get(coupledGenotype);
                    boolean isChild = false;
                    if (relatives.child.sampleName.equals(coupledGenotype)) {
                        isChild = true;
                    }
                    for (int c = 0; c < matrix[matrix.length - 1].length; ++c) {
                        String colName = colNames[c];
                        boolean valueIsFromRelative = false;
                        if (isChild) {
                            if (colName.equals(relatives.parent1.sampleName) || colName.equals(relatives.parent2.sampleName)) {
                                valueIsFromRelative = true;
                            }
                        } else if (colName.equals(relatives.child.sampleName)) {
                            valueIsFromRelative = true;
                        }
                        if (valueIsFromRelative) {
                            parentValues[numParents] = matrix[r][c];
                            ++numParents;
                            continue;
                        }
                        if (this.etg.get(rowName) != null && this.etg.get(rowName).equals(colName)) {
                            truePosMinFamilyValues[tpc] = matrix[r][c];
                            ++tpc;
                            continue;
                        }
                        trueNegMinFamilyValues[tnc] = matrix[r][c];
                        ++tnc;
                    }
                }
                this.drawDistributionsWithFamilyData(truePosMinFamilyValues, trueNegMinFamilyValues, parentValues, outputLoc);
            }
        }
        for (int row = 0; row < rowNames.length; ++row) {
            String rowName = rowNames[row];
            for (int col = 0; col < colNames.length; ++col) {
                String colName = colNames[col];
                if (this.etg.get(rowName) != null && this.etg.get(rowName).equals(colName)) {
                    truePosValues[tp] = matrix[row][col];
                    ++tp;
                    continue;
                }
                trueNegValues[tn] = matrix[row][col];
                ++tn;
            }
        }
        double[] lowestVals = new double[numPositives];
        double[] restVals = new double[numTN];
        int tnProcessed = 0;
        for (int col = 0; col < colNames.length; ++col) {
            int row;
            double lowestForThisCol = Double.MAX_VALUE;
            int lowestRow = -1;
            for (row = 0; row < rowNames.length; ++row) {
                if (!(matrix[row][col] < lowestForThisCol)) continue;
                lowestRow = row;
                lowestForThisCol = matrix[row][col];
            }
            for (row = 0; row < rowNames.length; ++row) {
                if (row == lowestRow) {
                    lowestVals[col] = matrix[row][col];
                    continue;
                }
                restVals[tnProcessed] = matrix[row][col];
                ++tnProcessed;
            }
        }
        this.drawROCCurve(lowestVals, restVals, true, outputLoc);
        this.drawROCCurve(truePosValues, trueNegValues, false, outputLoc);
        this.textOutput.close();
    }

    public void plotHeatMap(DoubleMatrixDataset<String, String> result, String plotTitle, String subTitle, String xAxisLabel, String yAxisLabel, double[] expPC1EigenVector, double[] genPC1EigenVector, String outdir) {
        int numRows = result.rowObjects.size();
        int numCols = result.colObjects.size();
        MixupMapperHeatMap hm = new MixupMapperHeatMap(numCols * 10 + 50, numRows * 10 + 50, true, outdir + "HeatMap.pdf");
        hm.setLabels(result.rowObjects.toArray(new String[0]), result.colObjects.toArray(new String[0]));
        hm.setAxisLabels(xAxisLabel, yAxisLabel);
        hm.setPC1EigenVector(genPC1EigenVector, expPC1EigenVector);
        hm.plot(result.rawData);
        hm.setTitle(plotTitle);
        if (subTitle != null) {
            hm.setSubTitle(subTitle);
        }
        hm.draw(outdir + "HeatMap.pdf");
        hm.close();
    }

    private void drawDistributionsWithFamilyData(double[] truePosValues, double[] trueNegValues, double[] parentValues, String outputLoc) {
        int binNum;
        double val;
        int i;
        int numBins = 100;
        double[] tmpVals = new double[]{ArrayMath.max((double[])truePosValues), ArrayMath.max((double[])trueNegValues), ArrayMath.max((double[])parentValues)};
        double distmax = ArrayMath.max((double[])tmpVals);
        tmpVals[0] = ArrayMath.min((double[])truePosValues);
        tmpVals[1] = ArrayMath.min((double[])trueNegValues);
        tmpVals[2] = ArrayMath.min((double[])parentValues);
        double distmin = ArrayMath.min((double[])tmpVals);
        distmin = Math.floor(distmin);
        distmax = Math.ceil(distmax);
        double mu0 = ArrayMath.mean((double[])trueNegValues);
        double mu1 = ArrayMath.mean((double[])truePosValues);
        double mu2 = ArrayMath.mean((double[])parentValues);
        double sd0 = ArrayMath.standardDeviation((double[])trueNegValues);
        double var0 = ArrayMath.variance((double[])trueNegValues);
        double sd1 = ArrayMath.standardDeviation((double[])truePosValues);
        double var1 = ArrayMath.variance((double[])truePosValues);
        double sd2 = ArrayMath.standardDeviation((double[])parentValues);
        double var2 = ArrayMath.variance((double[])parentValues);
        double absmu = Math.abs(mu1 - mu0);
        double absmutpvsp = Math.abs(mu1 - mu2);
        double abssd = (sd0 + sd1) / 2.0;
        double SNR = absmu / abssd;
        double absvar = (var0 + var1) / 2.0;
        double SNR2 = absmu / absvar;
        double absvartpvsp = (var1 + var2) / 2.0;
        double SNR2tpvsp = absmutpvsp / absvartpvsp;
        double SNRTPVsParents = absmutpvsp / ((sd0 + sd2) / 2.0);
        double test = TTest.test(trueNegValues, truePosValues);
        System.out.println("The SNR/distance between the original sample assignment frequency distribution and other sample pair frequency distribution:\t" + SNR2);
        System.out.println("The SNR/distance between the true positive and 1st degree family distributions:\t" + SNR2tpvsp);
        DiscreteDist tp = new DiscreteDist();
        tp.createDist(distmin, distmax, numBins);
        DiscreteDist tn = new DiscreteDist();
        tn.createDist(distmin, distmax, numBins);
        DiscreteDist pv = new DiscreteDist();
        pv.createDist(distmin, distmax, numBins);
        Arrays.sort(truePosValues);
        Arrays.sort(trueNegValues);
        Arrays.sort(parentValues);
        double range = 0.0;
        range = distmin < 0.0 ? distmax + Math.abs(distmin) : distmax - distmin;
        double binInterval = range / (double)numBins;
        for (i = 0; i < truePosValues.length; ++i) {
            val = 0.0;
            val = distmin < 0.0 ? truePosValues[i] + Math.abs(distmin) : truePosValues[i] - distmin;
            binNum = (int)Math.floor(val / binInterval);
            if (binNum == numBins) {
                binNum = numBins - 1;
            }
            tp.addToBin(binNum);
        }
        for (i = 0; i < trueNegValues.length; ++i) {
            val = 0.0;
            val = distmin < 0.0 ? trueNegValues[i] + Math.abs(distmin) : trueNegValues[i] - distmin;
            binNum = (int)Math.floor(val / binInterval);
            if (binNum == numBins) {
                binNum = numBins - 1;
            }
            tn.addToBin(binNum);
        }
        for (i = 0; i < parentValues.length; ++i) {
            val = 0.0;
            val = distmin < 0.0 ? parentValues[i] + Math.abs(distmin) : parentValues[i] - distmin;
            binNum = (int)Math.floor(val / binInterval);
            if (binNum == numBins) {
                binNum = numBins - 1;
            }
            pv.addToBin(binNum);
        }
        DiscreteDist[] dists = new DiscreteDist[3];
        tp.convertToFrequency(truePosValues.length);
        tn.convertToFrequency(trueNegValues.length);
        pv.convertToFrequency(parentValues.length);
        dists[0] = tp;
        dists[2] = pv;
        dists[1] = tn;
        MultiFrequencyDistributionHistogram mfh = new MultiFrequencyDistributionHistogram(1100, 1100, true, outputLoc + "Distribution-Frequency-WithRelatives.pdf");
        mfh.plot(dists);
        mfh.draw(outputLoc + "Distribution-Frequency-WithRelatives.png");
        mfh.close();
    }

    private void drawROCCurve(double[] truePosValues, double[] trueNegValues, boolean bestmatches, String outputLoc) throws IOException {
        if (trueNegValues.length == 0 || truePosValues.length == 0) {
            System.out.println("WARNING: cannot determine ROCs since there are no values for true positives or true negatives: (" + truePosValues.length + " - " + trueNegValues.length + ")");
        } else {
            int binNum;
            double val;
            int i;
            int numBins = 100;
            double[] tmpVals = new double[]{ArrayMath.max((double[])truePosValues), ArrayMath.max((double[])trueNegValues)};
            double distmax = ArrayMath.max((double[])tmpVals);
            tmpVals[0] = ArrayMath.min((double[])truePosValues);
            tmpVals[1] = ArrayMath.min((double[])trueNegValues);
            double distmin = ArrayMath.min((double[])tmpVals);
            distmin = Math.floor(distmin);
            distmax = Math.ceil(distmax);
            double mu0 = ArrayMath.mean((double[])trueNegValues);
            double mu1 = ArrayMath.mean((double[])truePosValues);
            double sd0 = ArrayMath.standardDeviation((double[])trueNegValues);
            double var0 = ArrayMath.variance((double[])trueNegValues);
            double sd1 = ArrayMath.standardDeviation((double[])truePosValues);
            double var1 = ArrayMath.variance((double[])truePosValues);
            double absmu = Math.abs(mu1 - mu0);
            double abssd = (sd0 + sd1) / 2.0;
            double SNR = absmu / abssd;
            double absvar = (var0 + var1) / 2.0;
            double SNR2 = absmu / absvar;
            double test = TTest.test(trueNegValues, truePosValues);
            System.out.println("P-value of T-test between original sample assignments and other sample pairs: " + test);
            if (bestmatches) {
                System.out.println("The SNR/distance between the best match frequency distribution and other sample pair frequency distribution:\t" + SNR2);
            } else {
                System.out.println("The SNR/distance between the original sample assignment frequency distribution and other sample pair frequency distribution:\t" + SNR2);
            }
            DiscreteDist tp = new DiscreteDist();
            tp.createDist(distmin, distmax, numBins);
            DiscreteDist tn = new DiscreteDist();
            tn.createDist(distmin, distmax, numBins);
            Arrays.sort(truePosValues);
            Arrays.sort(trueNegValues);
            double range = 0.0;
            range = distmin < 0.0 ? distmax + Math.abs(distmin) : distmax - distmin;
            double binInterval = range / (double)numBins;
            for (i = 0; i < truePosValues.length; ++i) {
                val = 0.0;
                val = distmin < 0.0 ? truePosValues[i] + Math.abs(distmin) : truePosValues[i] - distmin;
                binNum = (int)Math.floor(val / binInterval);
                if (binNum == numBins) {
                    binNum = numBins - 1;
                }
                tp.addToBin(binNum);
            }
            for (i = 0; i < trueNegValues.length; ++i) {
                val = 0.0;
                val = distmin < 0.0 ? trueNegValues[i] + Math.abs(distmin) : trueNegValues[i] - distmin;
                binNum = (int)Math.floor(val / binInterval);
                if (binNum == numBins) {
                    binNum = numBins - 1;
                }
                tn.addToBin(binNum);
            }
            DiscreteDist[] dists = new DiscreteDist[2];
            tp.convertToFrequency(truePosValues.length);
            tn.convertToFrequency(trueNegValues.length);
            dists[0] = tp;
            dists[1] = tn;
            MultiFrequencyDistributionHistogram mfh = null;
            mfh = bestmatches ? new MultiFrequencyDistributionHistogram(1100, 1100, true, outputLoc + "Distribution-Frequency-BestMatches.pdf") : new MultiFrequencyDistributionHistogram(1100, 1100, true, outputLoc + "Distribution-Frequency.pdf");
            mfh.plot(dists);
            if (bestmatches) {
                mfh.draw(outputLoc + "Distribution-Frequency-BestMatches.pdf");
            } else {
                mfh.draw(outputLoc + "Distribution-Frequency.pdf");
            }
            mfh.close();
            tp.calcCumulative();
            tn.calcCumulative();
            tp.convertToFrequency(truePosValues.length);
            tn.convertToFrequency(trueNegValues.length);
            tp.resetIterator();
            tn.resetIterator();
            int numPos = truePosValues.length;
            int numNeg = trueNegValues.length;
            this.TPR = new double[6][numBins];
            this.FPR = new double[6][numBins];
            this.AUC = new double[6];
            for (int i2 = 1; i2 < 6; ++i2) {
                tp.resetIterator();
                tn.resetIterator();
                double apriori = (double)i2 * 0.2;
                double[] tmpTPR = new double[numBins];
                double[] tmpFPR = new double[numBins];
                double tmpAUC = 0.0;
                int currentBinNum = 0;
                double prevTPR = 0.0;
                double prevFPR = 0.0;
                double curTPR = 0.0;
                double curFPR = 0.0;
                while (tp.hasNext()) {
                    Bin tpBin = tp.getNext();
                    Bin tnBin = tn.getNext();
                    double TP = tpBin.getCumulativeFrequency();
                    double FN = 1.0 - TP;
                    double FP = tnBin.getCumulativeFrequency();
                    double TN = 1.0 - FP;
                    curTPR = TP * apriori / (TP * apriori + FN);
                    curFPR = FP / (FP + TN);
                    tmpTPR[currentBinNum] = curTPR;
                    tmpFPR[currentBinNum] = curFPR;
                    if (currentBinNum != 0) {
                        prevTPR = tmpTPR[currentBinNum - 1];
                        prevFPR = tmpFPR[currentBinNum - 1];
                        double squareArea = (curFPR - prevFPR) * prevTPR;
                        double triangleArea = (curFPR - prevFPR) * (curTPR - prevTPR) * 0.5;
                        tmpAUC += squareArea + triangleArea;
                    }
                    this.textOutput.write(i2 + "\t" + apriori + "\t" + tmpTPR[currentBinNum] + "\t" + tmpFPR[currentBinNum]);
                    ++currentBinNum;
                }
                this.FPR[i2] = tmpFPR;
                this.TPR[i2] = tmpTPR;
                this.AUC[i2] = tmpAUC;
            }
            if (!bestmatches) {
                ROCCurve roc = new ROCCurve(1024, 1024, true, outputLoc + "ROC.pdf");
                roc.plot(this.TPR, this.FPR, this.AUC, 0.2);
                roc.draw(outputLoc + "ROC.pdf");
                roc.close();
            }
        }
    }

    public void loadTruePositives(HashMap<String, String> genotypeToExpression, HashMap<String, String> expressionToGenotype) {
        this.etg = expressionToGenotype;
        this.gte = genotypeToExpression;
    }

    public void loadTruePositives(String inFile) throws IOException {
        this.gte = new HashMap();
        this.etg = new HashMap();
        TextFile in = new TextFile(inFile, false);
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] lineElems = line.split("\t");
            if (lineElems.length <= 1) continue;
            this.gte.put(lineElems[0], lineElems[1]);
            this.etg.put(lineElems[1], lineElems[0]);
        }
        in.close();
    }

    public void loadFamilyData(HashMap<String, Trio> sampleToTrio) {
        this.sampleToTrio = sampleToTrio;
        this.loadedFamilyData = true;
    }

    private boolean isRelative(String colName, String coupledGenotype, ArrayList<String> relatives) {
        boolean isRelative = false;
        for (int i = 0; i < relatives.size(); ++i) {
            String relative = relatives.get(i);
            if (!relative.equals(colName) || relative.equals(coupledGenotype)) continue;
            isRelative = true;
            break;
        }
        return isRelative;
    }
}

