/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.mixupmapper;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.metaqtl3.MetaQTL3;
import eqtlmappingpipeline.mixupmapper.MixupMapperVisualization;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.text.Strings;
import umcg.genetica.util.RankArray;

public class MixupMapper
extends MetaQTL3 {
    private TriTyperGenotypeData genotypeData;
    private DoubleMatrixDataset<String, String> traitData;
    private HashMap<String, String> genotypeToTrait;
    private HashMap<String, String> traitToGenotype;

    public void run(String xmlSettingsFile, String texttoreplace, String texttoreplacewith, String ingt, String inexp, String inexpplatform, String inexpannot, String gte, String out, boolean cis, boolean trans, int perm, boolean textout, boolean binout, String snpfile, Integer threads, Integer maxNrResults, String regressouteqtls, String snpprobecombofile, String inputeQTLs, boolean testall) throws IOException, Exception {
        String initialOutputdir = out;
        if (!(inputeQTLs != null && Gpio.exists(inputeQTLs) || out == null)) {
            initialOutputdir = Gpio.formatAsDirectory(initialOutputdir);
            out = initialOutputdir + "Cis-eQTLs/";
            System.out.println("Looking for file: " + out + "eQTLProbesFDR0.05.txt");
            if (Gpio.exists(out + "eQTLProbesFDR0.05.txt")) {
                inputeQTLs = out + "eQTLProbesFDR0.05.txt";
            }
        }
        initialOutputdir = Gpio.formatAsDirectory(initialOutputdir);
        if (inputeQTLs == null) {
            System.out.println("Could not find eQTL file. Will therefore perform eQTL mapping first.");
            out = initialOutputdir + "Cis-eQTLs/";
            this.initialize(xmlSettingsFile, texttoreplace, texttoreplacewith, null, null, ingt, inexp, inexpplatform, inexpannot, gte, out, cis, trans, perm, textout, binout, snpfile, threads, maxNrResults, regressouteqtls, snpprobecombofile, true, true, null, 0.05, null);
            this.mapEQTLs();
            inputeQTLs = this.m_settings.outputReportsDir + "eQTLProbesFDR0.05.txt";
            this.m_gg = null;
        }
        if (!Gpio.exists(inputeQTLs)) {
            System.err.println("Something went wrong during eQTL mapping: most probably the FDR calculations failed.\nCheck the files in: " + this.m_settings.outputReportsDir);
            System.exit(-1);
        }
        System.out.println("Using: " + inputeQTLs + " as input for MixupMapper");
        this.loadGenotypeData(ingt);
        this.loadGeneExpressionData(inexp);
        this.linkSamples(gte);
        out = initialOutputdir + "MixupMapper/";
        Gpio.createDir(out);
        this.mapMixups(inputeQTLs, testall, out, false);
    }

    private void loadGenotypeData(String ingt) throws IOException {
        this.genotypeData = new TriTyperGenotypeData(ingt);
    }

    private void loadGeneExpressionData(String inexp) throws IOException {
        TextFile tf = new TextFile(inexp, false);
        String[] elems = tf.readLineElems(TextFile.tab);
        tf.close();
        if (elems[0].trim().toLowerCase().equals("probe") && elems[3].trim().toLowerCase().equals("chr") && elems[4].trim().toLowerCase().equals("chrstart")) {
            System.out.println("File is in old TriTyper format..");
            this.traitData = new DoubleMatrixDataset(inexp, null, null, 9);
        } else {
            this.traitData = new DoubleMatrixDataset(inexp);
        }
        this.traitData.rawData = this.rankAllExpressionData(this.traitData.rawData);
    }

    private double[][] rankAllExpressionData(double[][] matrix) {
        RankArray r = new RankArray();
        boolean rankWithTies = false;
        for (int p = 0; p < matrix.length; ++p) {
            double[] probeData = matrix[p];
            probeData = r.rank(probeData, rankWithTies);
            matrix[p] = probeData;
        }
        return matrix;
    }

    private void linkSamples(String gte) throws IOException {
        this.genotypeToTrait = new HashMap();
        this.traitToGenotype = new HashMap();
        String[] genotypeSamples = this.genotypeData.getIndividuals();
        HashSet<String> gtInds = new HashSet<String>();
        HashSet tInds = new HashSet();
        gtInds.addAll(Arrays.asList(genotypeSamples));
        tInds.addAll(this.traitData.colObjects);
        if (gte != null && Gpio.exists(gte)) {
            System.out.println("Loading genotype to trait link file: " + gte);
            TextFile tf = new TextFile(gte, false);
            String[] gtelems = tf.readLineElems(Strings.whitespace);
            while (gtelems != null) {
                String t;
                String g;
                Integer gId;
                if (gtelems.length >= 2 && (gId = this.genotypeData.getIndividualId(g = gtelems[0])) != null && this.genotypeData.getIsIncluded()[gId].booleanValue() && tInds.contains(t = gtelems[1])) {
                    if (this.genotypeToTrait.containsKey(g)) {
                        System.out.println("WARNING: " + g + "\tgenotype sample has already been linked to trait sample\t" + this.genotypeToTrait.get(g));
                    } else {
                        this.genotypeToTrait.put(g, t);
                    }
                    if (this.traitToGenotype.containsKey(t)) {
                        System.out.println("WARNING: " + t + "\ttrait sample has already been linked to genotype sample\t" + this.traitToGenotype.get(t));
                    } else {
                        this.traitToGenotype.put(t, g);
                    }
                }
                gtelems = tf.readLineElems(Strings.whitespace);
            }
            tf.close();
            System.out.println(this.traitToGenotype.size() + " combinations of traits and genotypes samples loaded.");
            System.out.println(this.genotypeToTrait.size() + " combinations of genotypes and traits samples loaded.");
        } else if (gte != null && !Gpio.exists(gte)) {
            System.out.println("ERROR: genotype to trait link file: " + gte + " does not exist.");
        } else {
            for (String ind : genotypeSamples) {
                Integer gId = this.genotypeData.getIndividualId(ind);
                if (gId == null || !this.genotypeData.getIsIncluded()[gId].booleanValue() || this.traitData.hashCols.get(ind) == null) continue;
                if (this.genotypeToTrait.get(ind) == null) {
                    this.genotypeToTrait.put(ind, ind);
                    this.traitToGenotype.put(ind, ind);
                    continue;
                }
                System.out.println("WARNING: " + ind + "\tgenotype sample has already been linked to trait sample\t" + this.genotypeToTrait.get(ind) + ". Your dataset most probably contains duplicate identifiers.");
            }
            System.out.println("Linking genotypes and trait data yielded: " + this.traitToGenotype.size() + " links");
        }
        if (this.traitToGenotype.isEmpty()) {
            System.out.println("ERROR: no links between genotype and trait samples found.");
            System.exit(0);
        }
    }

    private void mapMixups(String inputeQTLs, boolean testAll, String outDir, boolean leavehalveout) throws IOException {
        double sd;
        int row;
        int ctr;
        ArrayList<Pair<String, String>> eQTLs = new ArrayList<Pair<String, String>>();
        TextFile tf = new TextFile(inputeQTLs, false);
        tf.readLine();
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            if (elems.length >= 4) {
                String snp = elems[1];
                String probe = elems[4];
                if (this.traitData.hashRows.containsKey(probe) && this.genotypeData.getSnpToSNPId().get((Object)snp) != -9) {
                    Pair<String, String> p = new Pair<String, String>(snp, probe);
                    eQTLs.add(p);
                } else {
                    System.out.println("QTL not present in datasets: " + snp + " - " + probe);
                }
            }
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        if (eQTLs.isEmpty()) {
            System.out.println("ERROR: no eQTLs detected.");
            System.exit(-1);
        }
        HashMap<String, Integer> genotypeToRowIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> traitToColIndex = new HashMap<String, Integer>();
        String[] gtInds = this.genotypeData.getIndividuals();
        String[] trInds = this.traitData.colObjects.toArray(new String[0]);
        int nrGenotypes = 0;
        int nrTraits = 0;
        if (testAll) {
            System.out.println("All vs all comparison");
            ctr = 0;
            ArrayList<String> samplesToOrder = new ArrayList<String>();
            for (int i = 0; i < gtInds.length; ++i) {
                String sampleName = gtInds[i];
                if (this.genotypeData.getIsIncluded()[i].booleanValue() && this.genotypeToTrait.get(sampleName) != null) {
                    genotypeToRowIndex.put(sampleName, ctr);
                    ++ctr;
                    continue;
                }
                if (!this.genotypeData.getIsIncluded()[i].booleanValue()) continue;
                samplesToOrder.add(sampleName);
            }
            for (String s : samplesToOrder) {
                genotypeToRowIndex.put(s, ctr);
                ++ctr;
            }
            nrGenotypes = ctr;
            ArrayList<Integer> samplesWithoutGenotypes = new ArrayList<Integer>();
            for (int i = 0; i < trInds.length; ++i) {
                String traitSample = trInds[i];
                String genotypeSample = this.traitToGenotype.get(traitSample);
                if (genotypeSample == null) {
                    samplesWithoutGenotypes.add(i);
                    continue;
                }
                Integer n = (Integer)genotypeToRowIndex.get(genotypeSample);
                traitToColIndex.put(trInds[i], n);
                ++nrTraits;
            }
            System.out.println(samplesWithoutGenotypes.size() + " trait samples could not be linked to a genotype");
            for (Integer sample : samplesWithoutGenotypes) {
                traitToColIndex.put(trInds[sample], nrTraits);
                ++nrTraits;
            }
        } else {
            ctr = 0;
            System.out.println("Only comparing samples that have been linked to each other");
            for (int i = 0; i < gtInds.length; ++i) {
                String gtInd;
                if (!this.genotypeData.getIsIncluded()[i].booleanValue() || this.genotypeToTrait.get(gtInd = gtInds[i]) == null) continue;
                genotypeToRowIndex.put(gtInds[i], ctr);
                traitToColIndex.put(this.genotypeToTrait.get(gtInd), ctr);
                ++ctr;
            }
            nrTraits = ctr;
            nrGenotypes = ctr;
        }
        System.out.println(nrTraits + " trait samples will be tested");
        System.out.println(nrGenotypes + " genotype samples will be tested");
        double[][] comparisonMatrix = new double[nrGenotypes][nrTraits];
        double[][] comparisonMatrixNrTested = new double[nrGenotypes][nrTraits];
        SNPLoader loader = this.genotypeData.createSNPLoader();
        int numTested = 0;
        int numNotTested = 0;
        System.out.println("Using " + eQTLs.size() + " eQTLs.");
        for (Pair pair : eQTLs) {
            String snp = (String)pair.getLeft();
            String probe = (String)pair.getRight();
            if (leavehalveout && (!leavehalveout || !(Math.random() <= 0.5))) continue;
            Integer probeId = (Integer)this.traitData.hashRows.get(probe);
            Integer snpId = this.genotypeData.getSnpToSNPId().get((Object)snp);
            if (probeId == null || snpId == -9) {
                System.out.println("Null trait or SNP ID:" + snpId + " (" + snp + ")\t" + probeId + " (" + snp + ")");
                ++numNotTested;
                continue;
            }
            double sdAA = -1.0;
            double sdAB = -1.0;
            double sdBB = -1.0;
            double meanAA = -1.0;
            double meanAB = -1.0;
            double meanBB = -1.0;
            SNP loadedSNP = this.genotypeData.getSNPObject(snpId);
            loader.loadGenotypes(loadedSNP);
            int[] genotypes = new int[genotypeToRowIndex.size()];
            int numAA = 0;
            int numAB = 0;
            int numBB = 0;
            for (int i = 0; i < gtInds.length; ++i) {
                int gt;
                String genotypeSample = gtInds[i];
                Integer genotypeSampleIndex = (Integer)genotypeToRowIndex.get(genotypeSample);
                if (genotypeSampleIndex == null) continue;
                genotypes[genotypeSampleIndex.intValue()] = gt = loadedSNP.getGenotypes()[i];
                if (gt == 0) {
                    ++numAA;
                    continue;
                }
                if (gt == 2) {
                    ++numBB;
                    continue;
                }
                if (gt != 1) continue;
                ++numAB;
            }
            if (numAA >= 3 && numAB >= 3 && numBB >= 3) {
                String traitSample;
                int exp;
                double[] aa = new double[numAA];
                double[] ab = new double[numAB];
                double[] bb = new double[numBB];
                int aaCTR = 0;
                int abCTR = 0;
                int bbCTR = 0;
                for (exp = 0; exp < trInds.length; ++exp) {
                    traitSample = trInds[exp];
                    String linkedGenotype = this.traitToGenotype.get(traitSample);
                    Integer linkedGenotypeIndex = (Integer)genotypeToRowIndex.get(linkedGenotype);
                    if (linkedGenotype == null) continue;
                    double expValue = this.traitData.rawData[probeId][exp];
                    int gt = genotypes[linkedGenotypeIndex];
                    if (gt == -1) continue;
                    if (gt == 0) {
                        aa[aaCTR] = expValue;
                        ++aaCTR;
                        continue;
                    }
                    if (gt == 2) {
                        bb[bbCTR] = expValue;
                        ++bbCTR;
                        continue;
                    }
                    if (gt != 1) continue;
                    ab[abCTR] = expValue;
                    ++abCTR;
                }
                sdAA = ArrayMath.standardDeviation((double[])aa);
                sdBB = ArrayMath.standardDeviation((double[])bb);
                sdAB = ArrayMath.standardDeviation((double[])ab);
                meanAA = ArrayMath.mean((double[])aa);
                meanBB = ArrayMath.mean((double[])bb);
                meanAB = ArrayMath.mean((double[])ab);
                if (sdAA > 0.0 && sdAB > 0.0 && sdBB > 0.0) {
                    for (exp = 0; exp < trInds.length; ++exp) {
                        traitSample = trInds[exp];
                        Integer traitIndex = (Integer)traitToColIndex.get(traitSample);
                        for (int gen = 0; gen < gtInds.length; ++gen) {
                            String genotypeSample = gtInds[gen];
                            Integer genotypeIndex = (Integer)genotypeToRowIndex.get(genotypeSample);
                            if (traitIndex == null || genotypeIndex == null) continue;
                            double expression = this.traitData.rawData[probeId][exp];
                            int gt = genotypes[genotypeIndex];
                            if (gt == -1) continue;
                            double z = 0.0;
                            z = gt == 0 ? Math.abs(expression - meanAA) / sdAA : (gt == 1 ? Math.abs(expression - meanAB) / sdAB : Math.abs(expression - meanBB) / sdBB);
                            if (Double.isNaN(z) || z == 0.0) continue;
                            double[] dArray = comparisonMatrixNrTested[genotypeIndex];
                            int n = traitIndex;
                            dArray[n] = dArray[n] + 1.0;
                            double[] dArray2 = comparisonMatrix[genotypeIndex];
                            int n2 = traitIndex;
                            dArray2[n2] = dArray2[n2] + z;
                        }
                    }
                    ++numTested;
                } else {
                    ++numNotTested;
                }
            } else {
                ++numNotTested;
            }
            loadedSNP.clearGenotypes();
        }
        loader.close();
        System.out.println("Number QTLs tested: " + numTested + "");
        System.out.println("Number QTLs not tested: " + numNotTested + "");
        if (numTested == 0) {
            System.err.println("An error has occurred: none of the eQTLs was used during the MixupMapper test");
            System.exit(-1);
        }
        String[] gtRowNames = new String[nrGenotypes];
        String[] stringArray = new String[nrTraits];
        for (int exp = 0; exp < trInds.length; ++exp) {
            String traitSample = trInds[exp];
            Integer traitIndex = (Integer)traitToColIndex.get(traitSample);
            if (traitIndex == null) continue;
            stringArray[traitIndex.intValue()] = traitSample;
        }
        for (int gen = 0; gen < gtInds.length; ++gen) {
            String genotypeSample = gtInds[gen];
            Integer gtIndex = (Integer)genotypeToRowIndex.get(genotypeSample);
            if (gtIndex == null) continue;
            gtRowNames[gtIndex.intValue()] = genotypeSample;
        }
        for (row = 0; row < comparisonMatrix.length; ++row) {
            for (int col = 0; col < comparisonMatrix[row].length; ++col) {
                double[] dArray = comparisonMatrix[row];
                int n = col;
                dArray[n] = dArray[n] / comparisonMatrixNrTested[row][col];
            }
        }
        for (int col = 0; col < nrTraits; ++col) {
            double[] colData = new double[nrGenotypes];
            for (int row2 = 0; row2 < nrGenotypes; ++row2) {
                colData[row2] = comparisonMatrix[row2][col];
            }
            double mean = ArrayMath.mean((double[])colData);
            sd = ArrayMath.standardDeviation((double[])colData);
            for (int row3 = 0; row3 < nrGenotypes; ++row3) {
                comparisonMatrix[row3][col] = (comparisonMatrix[row3][col] - mean) / sd;
            }
        }
        for (row = 0; row < nrGenotypes; ++row) {
            double[] rowData = new double[nrTraits];
            System.arraycopy(comparisonMatrix[row], 0, rowData, 0, nrTraits);
            double mean = ArrayMath.mean((double[])rowData);
            sd = ArrayMath.standardDeviation((double[])rowData);
            for (int col = 0; col < nrTraits; ++col) {
                comparisonMatrix[row][col] = (comparisonMatrix[row][col] - mean) / sd;
            }
        }
        DoubleMatrixDataset<String, String> scoringMatrix = new DoubleMatrixDataset<String, String>(comparisonMatrix, Arrays.asList(gtRowNames), Arrays.asList(stringArray));
        scoringMatrix.save(outDir + "MixupMapperScores.txt");
        TextFile matchedGTOut = new TextFile(outDir + "BestMatchPerGenotype.txt", true);
        matchedGTOut.writeln("Genotype\tOriginalLinkedTrait\tOriginalLinkedTraitScore\tBestMatchingTrait\tBestMatchingTraitScore\tMixup");
        for (int row4 = 0; row4 < nrGenotypes; ++row4) {
            String gtSample = gtRowNames[row4];
            double minValue = Double.MAX_VALUE;
            int minCol = -1;
            for (int col = 0; col < comparisonMatrix[row4].length; ++col) {
                double v = comparisonMatrix[row4][col];
                if (!(v < minValue)) continue;
                minValue = v;
                minCol = col;
            }
            String linkedTrait = this.genotypeToTrait.get(gtSample);
            String linkedTraitScore = "N/A";
            if (linkedTrait == null) {
                linkedTrait = "N/A";
            } else {
                Integer linkedTraitID = (Integer)traitToColIndex.get(linkedTrait);
                linkedTraitScore = "" + comparisonMatrix[row4][linkedTraitID];
            }
            matchedGTOut.writeln(gtSample + "\t" + linkedTrait + "\t" + linkedTraitScore + "\t" + stringArray[minCol] + "\t" + comparisonMatrix[row4][minCol] + "\t" + (!linkedTrait.equals("N/A") && !linkedTrait.equals(stringArray[minCol])));
        }
        matchedGTOut.close();
        TextFile matchedTrOut = new TextFile(outDir + "BestMatchPerTrait.txt", true);
        matchedTrOut.writeln("Trait\tOriginalLinkedGenotype\tOriginalLinkedGenotypeScore\tBestMatchingGenotype\tBestMatchingGenotypeScore\tMixup");
        for (int col = 0; col < nrTraits; ++col) {
            String trSample = stringArray[col];
            double minValue = Double.MAX_VALUE;
            int minRow = -1;
            for (int row5 = 0; row5 < comparisonMatrix.length; ++row5) {
                double v = comparisonMatrix[row5][col];
                if (!(v < minValue)) continue;
                minValue = v;
                minRow = row5;
            }
            String linkedGenotype = this.traitToGenotype.get(trSample);
            String linkedGenotypeScore = "N/A";
            if (linkedGenotype == null) {
                linkedGenotype = "N/A";
            } else {
                Integer linkedTraitID = (Integer)genotypeToRowIndex.get(linkedGenotype);
                linkedGenotypeScore = "" + comparisonMatrix[linkedTraitID][col];
            }
            matchedTrOut.writeln(trSample + "\t" + linkedGenotype + "\t" + linkedGenotypeScore + "\t" + gtRowNames[minRow] + "\t" + comparisonMatrix[minRow][col] + "\t" + (!linkedGenotype.equals("N/A") && !linkedGenotype.equals(gtRowNames[minRow])));
        }
        matchedTrOut.close();
        double[] expPC1EigenVector = new double[scoringMatrix.colObjects.size()];
        double[] genPC1EigenVector = new double[scoringMatrix.rowObjects.size()];
        double genvarPC1 = 0.0;
        double expvarPC1 = 0.0;
        MixupMapperVisualization v = new MixupMapperVisualization();
        String subtitle = null;
        if (expPC1EigenVector != null || genPC1EigenVector != null) {
            subtitle = genPC1EigenVector != null && expPC1EigenVector == null ? "Genomic variance explained by PC1: " + new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(genvarPC1) : (genPC1EigenVector == null && genPC1EigenVector != null ? "Gene expression variance explained by PC1: " + new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(expvarPC1) : "Gene expression variance explained by PC1: " + new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(expvarPC1) + " | Genomic variance explained by PC1: " + new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(genvarPC1));
        }
        v.plotHeatMap(scoringMatrix, "HeatMap", subtitle, "Traits", "Genotypes", expPC1EigenVector, genPC1EigenVector, outDir);
    }
}

