/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Dataset;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTrait;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTraitTreeSet;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Settings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.containers.Pair;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.util.Primitives;

public class SingleDatasetAnalysisTask
implements Callable<Boolean> {
    private final long[] randomizationSeeds;
    private final ArrayList<MetaQTL4MetaTrait> availableTraits;
    private final MetaQTL4MetaTraitTreeSet availableTraitsHash;
    private final MetaQTL4Dataset dataset;
    private final MetaQTL4Settings m_settings;
    private final CompletionService resultPool;
    private final GeneticVariant variant;
    double mafthreshold;
    double hwepthreshold;
    double callratethreshold;
    Integer[] traitIndex;

    public SingleDatasetAnalysisTask(int nrThreads, long[] randomizationSeeds, ArrayList<MetaQTL4MetaTrait> availableTraits, MetaQTL4MetaTraitTreeSet availableTraitsHash, Integer[] traitIndex, MetaQTL4Dataset dataset, MetaQTL4Settings m_settings, Set<MetaQTL4MetaTrait> traitsToInclude, GeneticVariant variant, CompletionService resultPool) {
        this.randomizationSeeds = randomizationSeeds;
        this.availableTraits = availableTraits;
        this.availableTraitsHash = availableTraitsHash;
        this.dataset = dataset;
        this.m_settings = m_settings;
        this.traitIndex = traitIndex;
        this.resultPool = resultPool;
        this.variant = variant;
        this.mafthreshold = m_settings.getSnpQCMAFThreshold();
        this.hwepthreshold = m_settings.getSnpQCHWEThreshold();
        this.callratethreshold = m_settings.getSnpQCHWEThreshold();
    }

    @Override
    public Boolean call() throws Exception {
        try {
            int nrPermutations = this.randomizationSeeds.length;
            int maxNrSamples = this.dataset.getGenotypeToTraitCouplingInt().length;
            boolean[] includeTraitSample = new boolean[maxNrSamples];
            float[] genotypesTMP = this.dataset.getSampleDosages(this.variant);
            if (!this.variant.isBiallelic() || this.variant.getHwePvalue() < this.hwepthreshold || this.variant.getMinorAlleleFrequency() < this.mafthreshold || this.variant.getCallRate() < this.callratethreshold) {
                return true;
            }
            Pair<double[], Double> genotypedata = this.correctGenotypesForMissingValuesAndNormalize(this.dataset.getGenotypeToTraitCouplingInt(), this.variant, genotypesTMP, includeTraitSample);
            int snpStartPosition = this.variant.getStartPos();
            String sequence = this.variant.getSequenceName();
            HashSet<Integer> traitsToTest = null;
            double[] datasetGenotypeData = genotypedata.getLeft();
            int sampleSize = datasetGenotypeData.length;
            double genotypeVariance = genotypedata.getRight();
            if (this.m_settings.isCisAnalysis() ^ this.m_settings.isTransAnalysis()) {
                traitsToTest = new HashSet<Integer>();
                NavigableSet<MetaQTL4MetaTrait> traits = this.availableTraitsHash.getTraitInWindow(sequence, snpStartPosition, this.m_settings.getCiseQTLAnalysMaxSNPProbeMidPointDistance());
                for (MetaQTL4MetaTrait metaQTL4MetaTrait : traits) {
                    traitsToTest.add(metaQTL4MetaTrait.getCurrentMetaId());
                }
            }
            for (int permutation = -1; permutation < nrPermutations; ++permutation) {
                if (permutation >= 0) {
                    long seed = this.randomizationSeeds[permutation];
                    Random rand = new Random(seed);
                    if (datasetGenotypeData != null) {
                        datasetGenotypeData = this.permuteGenotypes(datasetGenotypeData, rand);
                    }
                }
                if (traitsToTest == null) {
                    for (int trait = 0; trait < this.availableTraits.size(); ++trait) {
                        this.test(sampleSize, datasetGenotypeData, genotypeVariance, trait, includeTraitSample);
                    }
                    continue;
                }
                if (this.m_settings.isCisAnalysis()) {
                    for (Integer n : traitsToTest) {
                        this.test(sampleSize, datasetGenotypeData, genotypeVariance, n, includeTraitSample);
                    }
                }
                if (!this.m_settings.isTransAnalysis()) continue;
                for (int i = 0; i < this.availableTraits.size(); ++i) {
                    if (traitsToTest.contains(i)) continue;
                    this.test(sampleSize, datasetGenotypeData, genotypeVariance, i, includeTraitSample);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void test(int sampleSize, double[] genotypes, double genotypeVariance, Integer traitId, boolean[] includeTraitSample) {
        double zscore = 0.0;
        if (genotypes == null) {
            zscore = Double.NaN;
        } else {
            Integer datasetId = this.traitIndex[traitId];
            double[] y = this.dataset.getTraitData(datasetId);
            double[] newY = new double[genotypes.length];
            int itr = 0;
            double sum = 0.0;
            for (int s = 0; s < y.length; ++s) {
                newY[itr] = y[s];
                sum += newY[itr];
                ++itr;
            }
            y = newY;
            double meanY = sum / (double)itr;
            double varsum = 0.0;
            for (int i = 0; i < y.length; ++i) {
                int n = i;
                y[n] = y[n] - meanY;
                varsum += y[i] * y[i];
            }
            double varianceY = varsum / (double)(y.length - 1);
            double varianceYOrig = this.dataset.getTraitVariance(traitId);
            if (varianceY == 0.0) {
                zscore = Double.NaN;
            } else {
                double correlation = Correlation.correlateMeanCenteredData(genotypes, y, genotypeVariance, varianceY);
                if (correlation >= -1.0 && correlation <= 1.0) {
                    zscore = Correlation.convertCorrelationToZScore(genotypes.length, correlation);
                    double p = Descriptives.convertZscoreToPvalue(zscore);
                } else {
                    System.err.println("Error! correlation invalid: " + correlation);
                    for (int i = 0; i < genotypes.length; ++i) {
                        System.out.println(genotypes[i] + "\t" + y[i] + "\t" + newY[i]);
                    }
                    System.exit(-1);
                }
            }
        }
    }

    private Pair<double[], Double> correctGenotypesForMissingValuesAndNormalize(int[] coupledTraitInt, GeneticVariant variant, float[] genotypesTMP, boolean[] includeTraitSample) {
        double[] snpmeancorrectedgenotypes;
        int xLen = genotypesTMP.length;
        int nrMissing = 0;
        if (variant.getCallRate() < 1.0) {
            double sum = 0.0;
            for (int i = 0; i < xLen; ++i) {
                if (genotypesTMP[i] < 0.0f) {
                    ++nrMissing;
                    int coupledTrait = coupledTraitInt[i];
                    includeTraitSample[coupledTrait] = false;
                    continue;
                }
                sum += (double)genotypesTMP[i];
            }
            int newXLen = xLen - nrMissing;
            double meanX = sum / (double)newXLen;
            snpmeancorrectedgenotypes = new double[newXLen];
            int itr = 0;
            for (int i = 0; i < newXLen; ++i) {
                if (!(genotypesTMP[i] >= 0.0f)) continue;
                snpmeancorrectedgenotypes[itr] = (double)genotypesTMP[i] - meanX;
                ++itr;
            }
        } else {
            double sum = 0.0;
            snpmeancorrectedgenotypes = new double[xLen];
            for (int i = 0; i < xLen; ++i) {
                double genotype = genotypesTMP[i];
                sum += genotype;
                snpmeancorrectedgenotypes[i] = genotype;
            }
        }
        double varianceX = ArrayMath.variance((double[])snpmeancorrectedgenotypes);
        return new Pair<double[], Double>(snpmeancorrectedgenotypes, varianceX);
    }

    private double[] permuteGenotypes(double[] genotypes, Random rand) {
        ArrayList<Double> availableGenotypes = new ArrayList<Double>();
        for (int i = 0; i < genotypes.length; ++i) {
            availableGenotypes.add(genotypes[i]);
        }
        Collections.shuffle(availableGenotypes, rand);
        return Primitives.toPrimitiveArr(availableGenotypes.toArray(new Double[0]));
    }
}

