/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import eqtlmappingpipeline.metaqtl4.MetaQTL4Dataset;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTrait;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTraitTreeSet;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Settings;
import eqtlmappingpipeline.metaqtl4.MetaQTL4TraitAnnotation;
import eqtlmappingpipeline.metaqtl4.SingleDatasetAnalysisTask;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.math.stats.Correlation;

public class SingleDatasetAnalysis {
    private Set<MetaQTL4MetaTrait> traitsToInclude = null;
    private Set<String> variantsToInclude = null;
    private Set<Pair<String, MetaQTL4MetaTrait>> genotypeTraitCombinations = null;
    private final MetaQTL4Settings m_settings;
    private MetaQTL4TraitAnnotation traitAnnotation;
    private MetaQTL4Dataset dataset;
    private ArrayList<MetaQTL4MetaTrait> availableTraits;
    private TObjectIntHashMap<MetaQTL4MetaTrait> availableTraitsHash;
    private static final Logger LOG = Logger.getLogger(SingleDatasetAnalysis.class);
    private Integer[] traitIndex;

    public SingleDatasetAnalysis(MetaQTL4Settings settings) throws IOException, Exception {
        LOG.info((Object)"WARNING: MetaQTL4 is experimental code!");
        this.m_settings = settings;
        this.initialize();
        this.run();
    }

    public SingleDatasetAnalysis(String settings, String replaceText, String testToReplaceWith) throws IOException, Exception {
        LOG.warn((Object)"WARNING: MetaQTL4 is experimental code!");
        this.m_settings = new MetaQTL4Settings(settings, replaceText, testToReplaceWith);
        this.initialize();
        this.run();
    }

    public final void initialize() throws IOException {
        HashSet<String> platforms = new HashSet<String>();
        for (int d = 0; d < this.m_settings.getNrDatasets(); ++d) {
            platforms.add(this.m_settings.getDatasetSettings().get(d).getTraitPlatform());
        }
        this.traitAnnotation = new MetaQTL4TraitAnnotation(this.m_settings.getProbeAnnotationFile(), platforms);
        if (this.m_settings.getConfineProbeFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getConfineProbeFile())) {
                throw new IOException("Failed to read file with probes to include: " + this.m_settings.getConfineProbeFile().getAbsolutePath());
            }
            this.traitsToInclude = this.loadMetaTraitList(this.m_settings.getConfineProbeFile());
        }
        if (this.m_settings.getConfineSNPFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getConfineSNPFile())) {
                throw new IOException("Failed to read file with SNPs to include: " + this.m_settings.getConfineSNPFile().getAbsolutePath());
            }
            TextFile tf = new TextFile(this.m_settings.getConfineSNPFile(), false);
            this.variantsToInclude = tf.readAsSet(0, TextFile.tab);
            tf.close();
        }
        if (this.m_settings.getSNPProbeConfineFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getSNPProbeConfineFile())) {
                throw new IOException("Failed to read file with SNP Probe combinations to include: " + this.m_settings.getSNPProbeConfineFile().getAbsolutePath());
            }
            Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>> combinations = this.loadgenotypeMarkerCombinations(this.m_settings.getSNPProbeConfineFile());
            this.variantsToInclude = combinations.getLeft();
            this.traitsToInclude = combinations.getMiddle();
            this.genotypeTraitCombinations = combinations.getRight();
        }
        LOG.info((Object)"Running probe filter");
        this.runProbeFilter();
        HashSet<String> platformSpecificProbesToInclude = null;
        if (this.traitsToInclude != null) {
            String platform = this.m_settings.getDatasetSettings().get(0).getTraitPlatform();
            Integer platformId = this.traitAnnotation.getPlatformId(platform);
            platformSpecificProbesToInclude = new HashSet<String>();
            for (MetaQTL4MetaTrait metaprobe : this.traitsToInclude) {
                String platformProbe = metaprobe.getPlatformIds()[platformId];
                if (platformProbe == null) continue;
                platformSpecificProbesToInclude.add(platformProbe);
            }
        }
        this.dataset = new MetaQTL4Dataset(this.m_settings.getDatasetSettings().get(0), platformSpecificProbesToInclude);
        if (this.m_settings.isPerformParametricAnalysis()) {
            this.dataset.rankTraitData(this.m_settings.isEqualRankForTies());
        }
        this.createTraitIndex();
        int nrSamples = this.dataset.getGenotypeToTraitCouplingInt().length;
        LOG.info((Object)("Meta-analysis will have " + nrSamples + " samples"));
        Correlation.correlationToZScore(nrSamples);
    }

    public final void run() {
        LOG.info((Object)"Running software!");
        int nrPermutations = this.m_settings.getNrPermutationsFDR();
        long[] randomizationSeeds = new long[nrPermutations];
        Random rand = new Random();
        for (int permutation = 0; permutation < nrPermutations; ++permutation) {
            randomizationSeeds[permutation] = rand.nextLong();
        }
        ExecutorService resultPool = Executors.newFixedThreadPool(1);
        ExecutorCompletionService resultPoolService = new ExecutorCompletionService(resultPool);
        int nrThreads = this.m_settings.getNrThreads();
        ExecutorService threadPool = Executors.newFixedThreadPool(nrThreads);
        ExecutorCompletionService<Boolean> pool = new ExecutorCompletionService<Boolean>(threadPool);
        MetaQTL4MetaTraitTreeSet traitTreeSet = new MetaQTL4MetaTraitTreeSet();
        for (MetaQTL4MetaTrait trait : this.availableTraits) {
            traitTreeSet.add(trait);
        }
        int ctr = 0;
        for (GeneticVariant variant : this.dataset.getGenotypeData()) {
            SingleDatasetAnalysisTask task = new SingleDatasetAnalysisTask(nrThreads, randomizationSeeds, this.availableTraits, traitTreeSet, this.traitIndex, this.dataset, this.m_settings, this.traitsToInclude, variant, resultPoolService);
            pool.submit(task);
            ++ctr;
        }
        int returned = 0;
        ProgressBar pb = new ProgressBar(ctr);
        while (returned < ctr) {
            try {
                Boolean result = (Boolean)pool.take().get();
                if (result != null && result.booleanValue()) {
                    pb.set(++returned);
                }
                if (returned % 10000 != 0) continue;
                System.out.println(returned + " have returned..");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(returned);
        threadPool.shutdown();
    }

    private void createTraitIndex() {
        HashSet<MetaQTL4MetaTrait> tmpAvailableTraits = new HashSet<MetaQTL4MetaTrait>();
        String platform = this.m_settings.getDatasetSettings().get(0).getTraitPlatform();
        Integer platformId = this.traitAnnotation.getPlatformId(platform);
        String[] availableTraitsInDataset = this.dataset.getTraits();
        LOG.info((Object)(this.m_settings.getDatasetSettings().get(0).getName() + " has " + availableTraitsInDataset.length + " traits on platform " + platform + " (" + platformId + ")"));
        for (String trait : availableTraitsInDataset) {
            MetaQTL4MetaTrait metatrait = this.traitAnnotation.getTraitForPlatformId(platformId, trait);
            if (metatrait == null) continue;
            String chr = metatrait.getChr();
            if (this.m_settings.isCisAnalysis() && this.m_settings.isTransAnalysis()) {
                tmpAvailableTraits.add(metatrait);
                continue;
            }
            byte chrByte = ChrAnnotation.parseChr(chr);
            if (!chr.equals("X") && (chrByte >= 23 || chrByte <= 0)) continue;
            tmpAvailableTraits.add(metatrait);
        }
        this.availableTraits = new ArrayList(tmpAvailableTraits);
        this.availableTraitsHash = new TObjectIntHashMap();
        this.traitIndex = new Integer[this.availableTraits.size()];
        for (int i = 0; i < this.availableTraits.size(); ++i) {
            MetaQTL4MetaTrait trait = this.availableTraits.get(i);
            trait.setMetaTraitId(i);
            this.availableTraitsHash.put((Object)trait, i);
            String probeName = trait.getPlatformIds()[platformId];
            if (probeName == null) continue;
            this.traitIndex[i] = this.dataset.getTraitId(probeName);
        }
        LOG.info((Object)(this.availableTraits.size() + " traits available to test."));
    }

    private void runProbeFilter() {
        if (this.m_settings.getConfineToProbesThatMapToChromosome() != null) {
            HashSet<MetaQTL4MetaTrait> finalTraitList = new HashSet<MetaQTL4MetaTrait>();
            if (this.traitsToInclude != null) {
                for (MetaQTL4MetaTrait metaprobe : this.traitsToInclude) {
                    String chrToInclude;
                    String chr = metaprobe.getChr();
                    if (!chr.equals(chrToInclude = "" + this.m_settings.getConfineToProbesThatMapToChromosome()) || this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() && (!this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() || !MetaQTL4MetaTrait.mapsToChromosome())) continue;
                    finalTraitList.add(metaprobe);
                }
            } else {
                MetaQTL4MetaTrait[] metaProbes;
                for (MetaQTL4MetaTrait metaprobe : metaProbes = this.traitAnnotation.getMetatraits().toArray(new MetaQTL4MetaTrait[0])) {
                    String chrToInclude;
                    String chr = metaprobe.getChr();
                    if (!chr.equals(chrToInclude = "" + this.m_settings.getConfineToProbesThatMapToChromosome()) || this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() && (!this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() || !MetaQTL4MetaTrait.mapsToChromosome())) continue;
                    finalTraitList.add(metaprobe);
                }
            }
            this.traitsToInclude = finalTraitList;
            if (this.genotypeTraitCombinations != null) {
                HashSet<Pair<String, MetaQTL4MetaTrait>> finalgenotypetraitpairs = new HashSet<Pair<String, MetaQTL4MetaTrait>>();
                for (Pair<String, MetaQTL4MetaTrait> p : this.genotypeTraitCombinations) {
                    MetaQTL4MetaTrait probe = p.getRight();
                    if (!this.traitsToInclude.contains(probe)) continue;
                    finalgenotypetraitpairs.add(p);
                }
                this.genotypeTraitCombinations = finalgenotypetraitpairs;
            }
        }
        if (this.traitsToInclude != null && this.traitsToInclude.isEmpty()) {
            throw new IllegalStateException("No traits remain after filtering.");
        }
        if (this.genotypeTraitCombinations != null && this.genotypeTraitCombinations.isEmpty()) {
            throw new IllegalStateException("No snp-trait combinations remain after filtering.");
        }
    }

    private Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>> loadgenotypeMarkerCombinations(File file) throws IOException {
        HashSet<Pair<String, MetaQTL4MetaTrait>> pairs = new HashSet<Pair<String, MetaQTL4MetaTrait>>();
        HashSet<String> snps = new HashSet<String>();
        HashSet<MetaQTL4MetaTrait> probes = new HashSet<MetaQTL4MetaTrait>();
        TextFile tf = new TextFile(file, false);
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            String snp = elems[0];
            String probe = elems[1];
            MetaQTL4MetaTrait t = this.traitAnnotation.getMetaTraitNameToObj().get(probe);
            if (t != null) {
                Pair<String, MetaQTL4MetaTrait> p = new Pair<String, MetaQTL4MetaTrait>(snp, t);
                pairs.add(p);
                snps.add(snp);
                probes.add(t);
            }
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        return new Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>>(snps, probes, pairs);
    }

    private Set<MetaQTL4MetaTrait> loadMetaTraitList(File location) throws IOException {
        TextFile tf = new TextFile(location, false);
        Set<String> list = tf.readAsSet(0, TextFile.tab);
        HashSet<MetaQTL4MetaTrait> traits = new HashSet<MetaQTL4MetaTrait>();
        for (String s : list) {
            MetaQTL4MetaTrait t = this.traitAnnotation.getMetaTraitNameToObj().get(s);
            if (t == null) continue;
            traits.add(t);
        }
        tf.close();
        return traits;
    }
}

