/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTrait;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTraitTreeSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import umcg.genetica.io.text.TextFile;

class MetaQTL4TraitAnnotation {
    private final String[] platforms;
    private final ArrayList<HashMap<String, MetaQTL4MetaTrait>> traitHashPerPlatform;
    private final HashMap<String, Integer> platformToId;
    private final MetaQTL4MetaTraitTreeSet metatraits;
    private final HashMap<String, MetaQTL4MetaTrait> metaTraitNameToObj;

    public MetaQTL4TraitAnnotation(File probeAnnotationFile, Set<String> platformsToInclude) throws IOException {
        TextFile tf = new TextFile(probeAnnotationFile, false);
        int nrLines = tf.countLines();
        String[] header = tf.readLineElems(TextFile.tab);
        boolean[] colsToInclude = new boolean[header.length];
        int nrPlatforms = 0;
        HashSet<String> visitedPlatforms = new HashSet<String>();
        for (int i = 0; i < header.length; ++i) {
            if (!platformsToInclude.contains(header[i])) continue;
            if (!visitedPlatforms.contains(header[i])) {
                colsToInclude[i] = true;
                visitedPlatforms.add(header[i]);
                ++nrPlatforms;
                continue;
            }
            System.err.println("ERROR: your probe annotation file contains duplicate platform identifiers!");
        }
        this.metatraits = new MetaQTL4MetaTraitTreeSet();
        this.metaTraitNameToObj = new HashMap();
        this.platformToId = new HashMap();
        this.platforms = new String[nrPlatforms];
        this.traitHashPerPlatform = new ArrayList();
        int platformNr = 0;
        for (int i = 0; i < header.length; ++i) {
            if (!colsToInclude[i]) continue;
            this.platforms[platformNr] = header[i];
            this.platformToId.put(header[i], platformNr);
            HashMap probeToId = new HashMap();
            this.traitHashPerPlatform.add(probeToId);
            ++platformNr;
        }
        for (String platform : platformsToInclude) {
            if (visitedPlatforms.contains(platform)) continue;
            System.err.println("WARNING: no annotation will be loaded for platform: " + platform);
        }
        int probeCounter = 0;
        for (String[] elems : tf.readLineElemsIterable(TextFile.tab)) {
            String metaTraitName = new String(elems[0].getBytes("UTF-8")).intern();
            String chr = new String(elems[2].getBytes("UTF-8")).intern();
            String chrpos = elems[3];
            String[] chrposElems = chrpos.split("-");
            int chrstartpos = -1;
            int chrendpos = -1;
            if (chrposElems.length >= 1) {
                try {
                    chrstartpos = Integer.parseInt(chrposElems[0]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    chrendpos = Integer.parseInt(chrposElems[chrposElems.length - 1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String hugo = new String(elems[4].getBytes("UTF-8")).intern();
            String[] platformIds = new String[nrPlatforms];
            MetaQTL4MetaTrait metaTraitObj = new MetaQTL4MetaTrait(probeCounter, metaTraitName, chr, chrstartpos, chrendpos, hugo, platformIds);
            for (int i = 5; i < elems.length; ++i) {
                platformNr = 0;
                if (!colsToInclude[i]) continue;
                platformIds[platformNr] = new String(elems[i].getBytes("UTF-8")).intern();
                HashMap<String, MetaQTL4MetaTrait> probeToId = this.traitHashPerPlatform.get(platformNr);
                probeToId.put(elems[i], metaTraitObj);
                ++platformNr;
            }
            ++probeCounter;
            this.metatraits.add(metaTraitObj);
            this.metaTraitNameToObj.put(metaTraitName, metaTraitObj);
        }
        System.out.println(tf.getFileName() + " has annotation for " + visitedPlatforms.size() + " platforms and " + this.metatraits.size() + " traits.");
        tf.close();
    }

    public Integer getPlatformId(String platform) {
        return this.platformToId.get(platform);
    }

    public MetaQTL4MetaTrait getTraitForPlatformId(Integer platformId, String platformTrait) {
        return this.traitHashPerPlatform.get(platformId).get(platformTrait);
    }

    public String[] getPlatforms() {
        return this.platforms;
    }

    public ArrayList<HashMap<String, MetaQTL4MetaTrait>> getTraitHashPerPlatform() {
        return this.traitHashPerPlatform;
    }

    public HashMap<String, Integer> getPlatformToId() {
        return this.platformToId;
    }

    public TreeSet<MetaQTL4MetaTrait> getMetatraits() {
        return this.metatraits;
    }

    public HashMap<String, MetaQTL4MetaTrait> getMetaTraitNameToObj() {
        return this.metaTraitNameToObj;
    }
}

