/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import eqtlmappingpipeline.metaqtl4.MetaQTL4DatasetSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class MetaQTL4Settings {
    private final boolean createSNPPValueSummaryStatisticsFile;
    private final boolean createSNPSummaryStatisticsFile;
    private final boolean createEQTLPValueTable;
    private final File outputReportsDir;
    private final boolean performParametricAnalysis;
    private final boolean useAbsoluteZScorePValue;
    private final int ciseQTLAnalysMaxSNPProbeMidPointDistance;
    private final int maxNrMostSignificantEQTLs;
    private final boolean performParametricAnalysisGetAccuratePValueEstimates;
    private final Integer nrThreads;
    private final double fdrCutOff;
    private final int nrPermutationsFDR;
    private final boolean performEQTLAnalysisOnSNPProbeCombinationSubset;
    private final Byte confineToSNPsThatMapToChromosome;
    private final boolean expressionDataLoadOnlyProbesThatMapToChromosome;
    private final double plotOutputPValueCutOff;
    private final String plotOutputDirectory;
    private final boolean runOnlyPermutations;
    private final Integer startWithPermutation;
    private final Boolean confineSNPsToSNPsPresentInAllDatasets;
    private final boolean confineProbesToProbesPresentInAllDatasets;
    private final ArrayList<MetaQTL4DatasetSettings> datasetSettings;
    private final String regressOutEQTLEffectFileName;
    private final Double snpQCCallRateThreshold;
    private final Double snpQCHWEThreshold;
    private final Double snpQCMAFThreshold;
    private final Byte confineToProbesThatMapToChromosome;
    private final boolean createBinaryOutputFiles;
    private final boolean createTEXTOutputFiles;
    private File strConfineSNP;
    private File strConfineProbe;
    private File strSNPProbeConfine;
    private final File probeAnnotationFile;
    private final boolean provideFoldChangeData;
    private final boolean provideBetasAndStandardErrors;
    private final boolean equalRankForTies;
    private final boolean createQQPlot;
    private final boolean createDotPlot;
    private final String settingsTextToReplace;
    private final String settingsTextReplaceWith;
    private final boolean cisAnalysis;
    private final boolean transAnalysis;

    public MetaQTL4Settings(String settings, String settingsTextToReplace, String settingsTextReplaceWith) throws IOException, Exception {
        byte chrConfine;
        Boolean confineTpSNPsPresentInAllDs;
        this.settingsTextToReplace = settingsTextToReplace;
        this.settingsTextReplaceWith = settingsTextReplaceWith;
        XMLConfiguration config = null;
        try {
            config = new XMLConfiguration(settings);
        }
        catch (ConfigurationException e) {
            throw new Exception("Configuration not properly formatted: " + e.getMessage());
        }
        String analysisType = null;
        String correlationType = null;
        Boolean useAbsPVal = null;
        Integer nrthread = null;
        Integer cisDist = null;
        Double MAF = null;
        Double HWE = null;
        Double callrate = null;
        String correctiontype = null;
        Double mtThreshold = null;
        Integer numPermutations = null;
        String outdir = null;
        Double outputplotthreshold = null;
        String outputplotdirectory = null;
        this.performEQTLAnalysisOnSNPProbeCombinationSubset = false;
        try {
            callrate = config.getDouble("defaults.qc.snpqccallratethreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.snpQCCallRateThreshold = callrate != null ? callrate : Double.valueOf(0.95);
        try {
            HWE = config.getDouble("defaults.qc.snpqchwethreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.snpQCHWEThreshold = HWE != null ? HWE : Double.valueOf(1.0E-4);
        String probeAnnot = null;
        try {
            probeAnnot = config.getString("defaults.analysis.probeAnnotationFile");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.probeAnnotationFile = new File(probeAnnot);
        try {
            MAF = config.getDouble("defaults.qc.snpqcmafthreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.snpQCMAFThreshold = MAF != null ? MAF : Double.valueOf(0.05);
        try {
            analysisType = config.getString("defaults.analysis.analysistype");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.createQQPlot = config.getBoolean("defaults.analysis.createqqplot", false);
        this.createDotPlot = config.getBoolean("defaults.analysis.createdotplot", false);
        this.runOnlyPermutations = config.getBoolean("defaults.analysis.onlypermutations", false);
        String strStartWithPermutation = null;
        try {
            strStartWithPermutation = config.getString("defaults.analysis.startwithpermutation", null);
            if (settingsTextToReplace != null && strStartWithPermutation.contains(settingsTextToReplace)) {
                strStartWithPermutation = strStartWithPermutation.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.startWithPermutation = strStartWithPermutation != null ? Integer.valueOf(Integer.parseInt(strStartWithPermutation)) : null;
        if (analysisType != null) {
            if (analysisType.toLowerCase().equals("cis")) {
                this.cisAnalysis = true;
                this.transAnalysis = false;
            } else if (analysisType.toLowerCase().equals("trans")) {
                this.cisAnalysis = false;
                this.transAnalysis = true;
            } else if (analysisType.toLowerCase().equals("cistrans")) {
                this.cisAnalysis = true;
                this.transAnalysis = true;
            } else {
                this.cisAnalysis = true;
                this.transAnalysis = false;
            }
        } else {
            this.cisAnalysis = true;
            this.transAnalysis = false;
        }
        try {
            cisDist = config.getInteger("defaults.analysis.cisanalysisprobedistance", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.ciseQTLAnalysMaxSNPProbeMidPointDistance = cisDist != null ? cisDist : 250000;
        try {
            correlationType = config.getString("defaults.analysis.correlationtype");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.performParametricAnalysis = correlationType != null ? correlationType.toLowerCase().equals("parametric") : false;
        Boolean useIdenticalRanksForTies = null;
        try {
            useIdenticalRanksForTies = config.getBoolean("defaults.analysis.equalrankforties");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.equalRankForTies = useIdenticalRanksForTies != null ? useIdenticalRanksForTies : false;
        try {
            useAbsPVal = config.getBoolean("defaults.analysis.useabsolutepvalue");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.useAbsoluteZScorePValue = useAbsPVal == null ? false : useAbsPVal;
        try {
            nrthread = config.getInteger("defaults.analysis.threads", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nrthread == null) {
            this.nrThreads = Runtime.getRuntime().availableProcessors() - 1;
        } else {
            int numProcs = Runtime.getRuntime().availableProcessors();
            this.nrThreads = nrthread > numProcs || nrthread < 1 ? Integer.valueOf(numProcs) : nrthread;
        }
        try {
            correctiontype = config.getString("defaults.multipletesting.type");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (correctiontype != null) {
            // empty if block
        }
        try {
            mtThreshold = config.getDouble("defaults.multipletesting.threshold", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fdrCutOff = mtThreshold != null ? mtThreshold : 0.05;
        try {
            numPermutations = config.getInteger("defaults.multipletesting.permutations", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.nrPermutationsFDR = numPermutations != null ? numPermutations : 0;
        try {
            outdir = config.getString("defaults.output.outputdirectory");
            if (settingsTextToReplace != null && outdir.contains(settingsTextToReplace)) {
                outdir = outdir.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (outdir != null) {
            this.outputReportsDir = new File(outdir);
            if (!Gpio.exists(outdir)) {
                Gpio.createOuputDir(this.outputReportsDir);
            }
            try {
                config.save(new File(this.outputReportsDir, "metaqtlsettings.xml"));
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            this.outputReportsDir = null;
            System.out.println("Error: please supply an output directory.");
            System.exit(-1);
        }
        try {
            outputplotthreshold = config.getDouble("defaults.output.outputplotthreshold");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.createBinaryOutputFiles = config.getBoolean("defaults.output.binaryoutput", false);
        this.createTEXTOutputFiles = config.getBoolean("defaults.output.textoutput", true);
        this.plotOutputPValueCutOff = outputplotthreshold != null ? outputplotthreshold : Double.MAX_VALUE;
        try {
            outputplotdirectory = config.getString("defaults.output.outputplotdirectory");
            if (settingsTextToReplace != null && outputplotdirectory.contains(settingsTextToReplace)) {
                outputplotdirectory = outputplotdirectory.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.plotOutputDirectory = outputplotdirectory != null ? Gpio.formatAsDirectory(outputplotdirectory) : outdir + "/plots/";
        if (this.plotOutputPValueCutOff != Double.MAX_VALUE && !Gpio.exists(this.plotOutputDirectory)) {
            Gpio.createDir(this.plotOutputDirectory);
        }
        this.createSNPPValueSummaryStatisticsFile = config.getBoolean("defaults.output.generatesnppvaluesummarystatistics", false);
        this.provideFoldChangeData = config.getBoolean("defaults.output.generatefoldchangevalues", false);
        this.provideBetasAndStandardErrors = config.getBoolean("defaults.output.generatebetaandfoldchanges", false);
        this.createSNPSummaryStatisticsFile = config.getBoolean("defaults.output.generatesnpsummarystatistics", false);
        this.createEQTLPValueTable = config.getBoolean("defaults.output.generateeqtlpvaluetable", false);
        this.maxNrMostSignificantEQTLs = config.getInt("defaults.output.maxnreqtlresults", 150000);
        this.expressionDataLoadOnlyProbesThatMapToChromosome = config.getBoolean("defaults.confine.confineProbesThatMapToKnownChromosome", true);
        this.confineSNPsToSNPsPresentInAllDatasets = confineTpSNPsPresentInAllDs = Boolean.valueOf(config.getBoolean("defaults.confine.confineSNPsToSNPsPresentInAllDatasets", false));
        this.confineToProbesThatMapToChromosome = null;
        String confineSNP = null;
        String confineProbe = null;
        String snpProbeConfine = null;
        try {
            confineSNP = config.getString("defaults.confine.snp");
            if (settingsTextToReplace != null && confineSNP.contains(settingsTextToReplace)) {
                confineSNP = confineSNP.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            confineProbe = config.getString("defaults.confine.probe");
            if (settingsTextToReplace != null && confineProbe.contains(settingsTextToReplace)) {
                confineProbe = confineProbe.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            snpProbeConfine = config.getString("defaults.confine.snpProbe");
            if (settingsTextToReplace != null && snpProbeConfine.contains(settingsTextToReplace)) {
                snpProbeConfine = snpProbeConfine.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (snpProbeConfine != null && snpProbeConfine.trim().length() > 0) {
            this.strSNPProbeConfine = new File(snpProbeConfine);
        }
        if (confineSNP != null && confineSNP.trim().length() > 0) {
            this.strConfineSNP = new File(confineSNP);
        }
        if (confineProbe != null && confineProbe.trim().length() > 0) {
            this.strConfineProbe = new File(confineProbe);
        }
        this.performParametricAnalysisGetAccuratePValueEstimates = false;
        String confineStr = null;
        try {
            confineStr = config.getString("defaults.confine.confineToSNPsThatMapToChromosome", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.confineToSNPsThatMapToChromosome = confineStr == null || confineStr.trim().length() == 0 ? null : ((chrConfine = ChrAnnotation.parseChr(confineStr)) < 1 ? null : Byte.valueOf(chrConfine));
        this.confineProbesToProbesPresentInAllDatasets = config.getBoolean("defaults.confine.confineToProbesPresentInAllDatasets", false);
        this.regressOutEQTLEffectFileName = config.getString("defaults.analysis.regressOutEQTLEffects");
        int i = 0;
        String dataset = config.getString("datasets.dataset(" + i + ").name");
        if (settingsTextToReplace != null && dataset.contains(settingsTextToReplace)) {
            dataset = dataset.replace(settingsTextToReplace, settingsTextReplaceWith);
        }
        this.datasetSettings = new ArrayList();
        while (dataset != null) {
            String expressionData = null;
            String genotypeLocation = null;
            String genToExpCoupling = null;
            String probeannotation = null;
            String expressionplatform = null;
            Object gte = null;
            try {
                expressionData = config.getString("datasets.dataset(" + i + ").expressiondata");
                if (settingsTextToReplace != null && expressionData.contains(settingsTextToReplace)) {
                    expressionData = expressionData.replace(settingsTextToReplace, settingsTextReplaceWith);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (expressionData != null) {
                String expressionPlatform = null;
                try {
                    expressionPlatform = config.getString("datasets.dataset(" + i + ").expressionplatform");
                    if (settingsTextToReplace != null && expressionData.contains(settingsTextToReplace)) {
                        expressionPlatform = expressionPlatform.replace(settingsTextToReplace, settingsTextReplaceWith);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                probeannotation = null;
                try {
                    probeannotation = config.getString("datasets.dataset(" + i + ").probeannotation");
                    if (settingsTextToReplace != null && expressionData.contains(settingsTextToReplace)) {
                        probeannotation = probeannotation.replace(settingsTextToReplace, settingsTextReplaceWith);
                    }
                    if (probeannotation.length() == 0) {
                        probeannotation = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                expressionplatform = expressionPlatform;
            }
            try {
                genotypeLocation = config.getString("datasets.dataset(" + i + ").location");
                if (settingsTextToReplace != null && genotypeLocation.contains(settingsTextToReplace)) {
                    genotypeLocation = genotypeLocation.replace(settingsTextToReplace, settingsTextReplaceWith);
                }
            }
            catch (Exception e) {
                System.out.println("Please provide a location on your disk where " + dataset + " is located");
                System.exit(-1);
            }
            Gpio.formatAsDirectory(genotypeLocation);
            try {
                genToExpCoupling = config.getString("datasets.dataset(" + i + ").genometoexpressioncoupling");
                if (settingsTextToReplace != null && genToExpCoupling.contains(settingsTextToReplace)) {
                    genToExpCoupling = genToExpCoupling.replace(settingsTextToReplace, settingsTextReplaceWith);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.datasetSettings.add(new MetaQTL4DatasetSettings(dataset, genotypeLocation, expressionData, genToExpCoupling, expressionplatform));
            dataset = null;
            ++i;
            try {
                dataset = config.getString("datasets.dataset(" + i + ").name");
                if (settingsTextToReplace == null || !dataset.contains(settingsTextToReplace)) continue;
                dataset = dataset.replace(settingsTextToReplace, settingsTextReplaceWith);
            }
            catch (Exception e) {}
        }
    }

    public String summarize() {
        String summary = "Following settings will be applied:\nSettings\n----\nsettingsTextToReplace\t" + this.settingsTextToReplace + "\n" + "settingsTextReplaceWith\t" + this.settingsTextReplaceWith + "\n" + "\nOutput\n----\n" + "createSNPPValueSummaryStatisticsFile\t" + this.createSNPPValueSummaryStatisticsFile + "\n" + "createEQTLPValueTable\t" + this.createEQTLPValueTable + "\n" + "outputReportsDir\t" + this.outputReportsDir + "\n" + "\nAnalysis\n----\n" + "performCiseQTLAnalysis\t" + this.cisAnalysis + "\n" + "performTranseQTLAnalysis\t" + this.transAnalysis + "\n" + "performParametricAnalysis\t" + this.performParametricAnalysis + "\n" + "useAbsoluteZScorePValue\t" + this.useAbsoluteZScorePValue + "\n" + "ciseQTLAnalysMaxSNPProbeMidPointDistance\t" + this.ciseQTLAnalysMaxSNPProbeMidPointDistance + "\n" + "maxNrMostSignificantEQTLs\t" + this.maxNrMostSignificantEQTLs + "\n" + "performParametricAnalysisGetAccuratePValueEstimates\t" + this.performParametricAnalysisGetAccuratePValueEstimates + "\n" + "nrThreads\t" + this.nrThreads + "\n" + "fdrCutOff\t" + this.fdrCutOff + "\n" + "nrPermutationsFDR\t" + this.nrPermutationsFDR + "\n" + "regressOutEQTLEffectFileName\t" + this.regressOutEQTLEffectFileName + "\n" + "snpQCCallRateThreshold\t" + this.snpQCCallRateThreshold + "\n" + "snpQCHWEThreshold\t" + this.snpQCHWEThreshold + "\n" + "snpQCMAFThreshold\t" + this.snpQCMAFThreshold + "\n" + "\nConfinements\n----\n" + "performEQTLAnalysisOnSNPProbeCombinationSubset\t" + this.performEQTLAnalysisOnSNPProbeCombinationSubset + "\n" + "confineToSNPsThatMapToChromosome\t" + this.confineToSNPsThatMapToChromosome + "\n" + "expressionDataLoadOnlyProbesThatMapToChromosome\t" + this.expressionDataLoadOnlyProbesThatMapToChromosome + "\n" + "confineSNPsToSNPsPresentInAllDatasets\t" + this.confineSNPsToSNPsPresentInAllDatasets + "\n" + "confineProbesToProbesPresentInAllDatasets\t" + this.confineProbesToProbesPresentInAllDatasets + "\n" + "confineToProbesThatMapToChromosome\t" + this.confineToProbesThatMapToChromosome + "\n" + "expressionDataLoadOnlyProbesThatMapToChromosome\t" + this.expressionDataLoadOnlyProbesThatMapToChromosome + "\n" + "\n";
        summary = summary + "\nDatasets\n----\n";
        for (MetaQTL4DatasetSettings settings : this.datasetSettings) {
            summary = summary + "DatasetName\t" + settings.getName() + "\n";
            summary = summary + "ExpressionData\t" + settings.getTraitDataLocation() + "\n";
            summary = summary + "ExpressionPlatform\t" + settings.getAnnotationFile() + "\n";
            summary = summary + "GenotypeData\t" + settings.getGenotypeLocation() + "\n";
            summary = summary + "GTE\t" + settings.getGenotypeToTraitCoupling() + "\n";
        }
        return summary;
    }

    public void writeSettingsToDisk() throws Exception {
        TextFile tf = new TextFile(this.outputReportsDir + "/UsedSettings.txt", true);
        tf.write(this.summarize());
        tf.close();
    }

    public String getSettingsTextToReplace() {
        return this.settingsTextToReplace;
    }

    public String getSettingsTextReplaceWith() {
        return this.settingsTextReplaceWith;
    }

    public boolean isCreateSNPPValueSummaryStatisticsFile() {
        return this.createSNPPValueSummaryStatisticsFile;
    }

    public boolean isCreateSNPSummaryStatisticsFile() {
        return this.createSNPSummaryStatisticsFile;
    }

    public boolean isCreateEQTLPValueTable() {
        return this.createEQTLPValueTable;
    }

    public File getOutputReportsDir() {
        return this.outputReportsDir;
    }

    public boolean isPerformParametricAnalysis() {
        return this.performParametricAnalysis;
    }

    public boolean isUseAbsoluteZScorePValue() {
        return this.useAbsoluteZScorePValue;
    }

    public int getCiseQTLAnalysMaxSNPProbeMidPointDistance() {
        return this.ciseQTLAnalysMaxSNPProbeMidPointDistance;
    }

    public int getMaxNrMostSignificantEQTLs() {
        return this.maxNrMostSignificantEQTLs;
    }

    public boolean isPerformParametricAnalysisGetAccuratePValueEstimates() {
        return this.performParametricAnalysisGetAccuratePValueEstimates;
    }

    public Integer getNrThreads() {
        return this.nrThreads;
    }

    public double getFdrCutOff() {
        return this.fdrCutOff;
    }

    public int getNrPermutationsFDR() {
        return this.nrPermutationsFDR;
    }

    public boolean isPerformEQTLAnalysisOnSNPProbeCombinationSubset() {
        return this.performEQTLAnalysisOnSNPProbeCombinationSubset;
    }

    public Byte getConfineToSNPsThatMapToChromosome() {
        return this.confineToSNPsThatMapToChromosome;
    }

    public boolean isExpressionDataLoadOnlyProbesThatMapToChromosome() {
        return this.expressionDataLoadOnlyProbesThatMapToChromosome;
    }

    public double getPlotOutputPValueCutOff() {
        return this.plotOutputPValueCutOff;
    }

    public String getPlotOutputDirectory() {
        return this.plotOutputDirectory;
    }

    public boolean isRunOnlyPermutations() {
        return this.runOnlyPermutations;
    }

    public Integer getStartWithPermutation() {
        return this.startWithPermutation;
    }

    public Boolean getConfineSNPsToSNPsPresentInAllDatasets() {
        return this.confineSNPsToSNPsPresentInAllDatasets;
    }

    public boolean isConfineProbesToProbesPresentInAllDatasets() {
        return this.confineProbesToProbesPresentInAllDatasets;
    }

    public ArrayList<MetaQTL4DatasetSettings> getDatasetSettings() {
        return this.datasetSettings;
    }

    public String getRegressOutEQTLEffectFileName() {
        return this.regressOutEQTLEffectFileName;
    }

    public Double getSnpQCCallRateThreshold() {
        return this.snpQCCallRateThreshold;
    }

    public Double getSnpQCHWEThreshold() {
        return this.snpQCHWEThreshold;
    }

    public Double getSnpQCMAFThreshold() {
        return this.snpQCMAFThreshold;
    }

    public Byte getConfineToProbesThatMapToChromosome() {
        return this.confineToProbesThatMapToChromosome;
    }

    public boolean isCreateBinaryOutputFiles() {
        return this.createBinaryOutputFiles;
    }

    public boolean isCreateTEXTOutputFiles() {
        return this.createTEXTOutputFiles;
    }

    public File getConfineSNPFile() {
        return this.strConfineSNP;
    }

    public File getConfineProbeFile() {
        return this.strConfineProbe;
    }

    public boolean isProvideFoldChangeData() {
        return this.provideFoldChangeData;
    }

    public boolean isProvideBetasAndStandardErrors() {
        return this.provideBetasAndStandardErrors;
    }

    public boolean isEqualRankForTies() {
        return this.equalRankForTies;
    }

    public boolean isCreateQQPlot() {
        return this.createQQPlot;
    }

    public boolean isCreateDotPlot() {
        return this.createDotPlot;
    }

    public File getSNPProbeConfineFile() {
        return this.strSNPProbeConfine;
    }

    public boolean isCisAnalysis() {
        return this.cisAnalysis;
    }

    public boolean isTransAnalysis() {
        return this.transAnalysis;
    }

    public int getNrDatasets() {
        return this.datasetSettings.size();
    }

    public File getProbeAnnotationFile() {
        return this.probeAnnotationFile;
    }
}

