/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import org.molgenis.genotype.util.ChromosomeComparator;

public class MetaQTL4MetaTrait
implements Comparable<Object> {
    private final int metaTraitId;
    private final String metaTraitName;
    private final String chr;
    private final int chrStart;
    private final int chrEnd;
    private final int chrMidpoint;
    private final String annotation;
    private final String[] platformIds;
    private static final ChromosomeComparator chrComparator = new ChromosomeComparator();
    private int currentMetaId;

    static boolean mapsToChromosome() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MetaQTL4MetaTrait(int metaTraitId, String metaTraitName, String chr, int chrStart, int chrEnd, String annotation, String[] platformIds) {
        this.metaTraitId = metaTraitId;
        this.metaTraitName = metaTraitName;
        this.chr = chr;
        this.chrStart = chrStart;
        this.chrEnd = chrEnd;
        this.chrMidpoint = chrStart >= 0 && chrEnd > 1 && chrStart != chrEnd ? Math.abs((chrStart + chrEnd) / 2) : (chrStart == chrEnd ? chrStart : -1);
        this.annotation = annotation;
        this.platformIds = platformIds;
    }

    @Override
    public int compareTo(Object t) {
        if (this.equals(t)) {
            return 0;
        }
        MetaQTL4MetaTrait that = (MetaQTL4MetaTrait)t;
        if (!this.getChr().equals(that.getChr())) {
            return chrComparator.compare(this.chr, that.getChr());
        }
        if (this.getChrMidpoint() == that.getChrMidpoint()) {
            return this.metaTraitId - that.metaTraitId;
        }
        return this.getChrMidpoint() - that.getChrMidpoint();
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.metaTraitId;
        hash = 59 * hash + (this.chr != null ? this.chr.hashCode() : 0);
        hash = 59 * hash + this.chrMidpoint;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaQTL4MetaTrait other = (MetaQTL4MetaTrait)obj;
        if (this.metaTraitId != other.metaTraitId) {
            return false;
        }
        if (this.chr == null ? other.chr != null : !this.chr.equals(other.chr)) {
            return false;
        }
        return this.chrMidpoint == other.chrMidpoint;
    }

    public int getMetaTraitId() {
        return this.metaTraitId;
    }

    public String getMetaTraitName() {
        return this.metaTraitName;
    }

    public String getChr() {
        return this.chr;
    }

    public int getChrStart() {
        return this.chrStart;
    }

    public int getChrEnd() {
        return this.chrEnd;
    }

    public int getChrMidpoint() {
        return this.chrMidpoint;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String[] getPlatformIds() {
        return this.platformIds;
    }

    void setMetaTraitId(int id) {
        this.currentMetaId = id;
    }

    public int getCurrentMetaId() {
        return this.currentMetaId;
    }
}

