/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import eqtlmappingpipeline.metaqtl4.MetaQTL4DatasetSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleIncludedFilter;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantIdIncludeFilter;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.util.RankArray;

public class MetaQTL4Dataset {
    private final DoubleMatrixDataset<String, String> traitData;
    private DoubleMatrixDataset traitVarianceAndMeanData;
    private final RandomAccessGenotypeData genotypeData;
    private final HashMap<String, String> genotypeToTraitCoupling;
    private int[] intGenotypeToTraitCoupling;
    private final String genotypeDataLocation;
    private static final Logger LOG = Logger.getLogger(MetaQTL4Dataset.class);

    public MetaQTL4Dataset(MetaQTL4DatasetSettings settings) throws IOException {
        this(settings.getTraitDataLocation(), null, settings.getGenotypeLocation(), settings.getGenotypeFormat(), null, settings.getGenotypeToTraitCoupling());
    }

    public MetaQTL4Dataset(MetaQTL4DatasetSettings settings, Set<String> markersToInclude) throws IOException {
        this(settings.getTraitDataLocation(), markersToInclude, settings.getGenotypeLocation(), settings.getGenotypeFormat(), null, settings.getGenotypeToTraitCoupling());
    }

    public MetaQTL4Dataset(String traitDataFile, Set<String> markersToInclude, String genotypeDatalocation, Set<String> snpsToInclude, RandomAccessGenotypeDataReaderFormats format) throws IOException {
        this(traitDataFile, markersToInclude, genotypeDatalocation, format, snpsToInclude, null);
    }

    public MetaQTL4Dataset(String traitDataFile, Set<String> markersToInclude, String genotypeDatalocation, RandomAccessGenotypeDataReaderFormats format, Set<String> snpsToInclude, String genotypeToTraitCouplingFile) throws IOException {
        this.genotypeDataLocation = genotypeDatalocation;
        RandomAccessGenotypeData tmpGenoData = snpsToInclude == null ? format.createFilteredGenotypeData(genotypeDatalocation, 50000, null, (SampleFilter)new SampleIncludedFilter()) : format.createFilteredGenotypeData(genotypeDatalocation, 50000, (VariantFilter)new VariantIdIncludeFilter(snpsToInclude), (SampleFilter)new SampleIncludedFilter());
        this.genotypeData = tmpGenoData;
        this.genotypeToTraitCoupling = new HashMap();
        Map<String, String> gte = null;
        if (genotypeToTraitCouplingFile != null && Gpio.exists(genotypeToTraitCouplingFile)) {
            TextFile tf = new TextFile(genotypeToTraitCouplingFile, false);
            gte = tf.readAsHashMap(0, 1);
            tf.close();
            HashSet<String> traitSamplesToSelect = new HashSet<String>();
            List samples = this.genotypeData.getSamples();
            for (int i = 0; i < samples.size(); ++i) {
                String sampleName = ((Sample)samples.get(i)).getId();
                String linkedTrait = gte.get(sampleName);
                if (linkedTrait == null) continue;
                traitSamplesToSelect.add(linkedTrait);
            }
            this.traitData = new DoubleMatrixDataset(traitDataFile, markersToInclude, traitSamplesToSelect);
            this.linkSamples(gte);
        } else {
            List genotypeSamples = this.genotypeData.getSamples();
            HashSet<String> traitSamplesToSelect = new HashSet<String>();
            for (int s = 0; s < genotypeSamples.size(); ++s) {
                traitSamplesToSelect.add(((Sample)genotypeSamples.get(s)).getId());
            }
            this.traitData = new DoubleMatrixDataset(traitDataFile, null, traitSamplesToSelect);
            this.linkSamples(null);
        }
        this.pruneGenotypeSamples(tmpGenoData);
        this.reorderAndPruneTraitSamples();
        this.linkSamples(gte);
        this.determineProbeMeanAndVariance();
        this.subtractMean();
        this.determineProbeMeanAndVariance();
    }

    private void linkSamples(Map<String, String> gte) {
        if (gte != null) {
            List genotypeSamples = this.genotypeData.getSamples();
            for (Sample s : genotypeSamples) {
                String genotypeSampleName = s.getId();
                String traitSampleName = gte.get(genotypeSampleName);
                if (traitSampleName == null || !this.traitData.hashCols.containsKey(traitSampleName)) continue;
                this.genotypeToTraitCoupling.put(genotypeSampleName, traitSampleName);
            }
        } else {
            List genotypeSamples = this.genotypeData.getSamples();
            for (Sample s : genotypeSamples) {
                String genotypeSampleName = s.getId();
                if (!this.traitData.hashCols.containsKey(genotypeSampleName)) continue;
                this.genotypeToTraitCoupling.put(genotypeSampleName, genotypeSampleName);
            }
        }
        if (this.genotypeToTraitCoupling.isEmpty()) {
            throw new IllegalStateException("No links between genotypes and traits found for dataset: " + this.genotypeDataLocation);
        }
        LOG.info((Object)("Found " + this.genotypeToTraitCoupling.size() + " links between genotypes and traits"));
    }

    private void reorderAndPruneTraitSamples() {
        this.traitData.transposeDataset();
        boolean[] excludeSampleBecauseOfLowVariance = new boolean[this.traitData.nrRows];
        for (int row = 0; row < this.traitData.nrRows; ++row) {
            double mean = Descriptives.mean(this.traitData.rawData[row]);
            double variance = Descriptives.variance(this.traitData.rawData[row], mean);
            if (variance < 1.0E-200 || Double.isNaN(variance)) {
                LOG.warn((Object)("WARNING: sample\t" + (String)this.traitData.rowObjects.get(row) + "\twill be excluded because sample variance " + variance + " < 1E-200"));
                excludeSampleBecauseOfLowVariance[row] = true;
                continue;
            }
            excludeSampleBecauseOfLowVariance[row] = false;
        }
        this.traitData.transposeDataset();
        double[][] traitDataMatrix = this.traitData.getRawData();
        List genotypeSamples = this.genotypeData.getSamples();
        ArrayList<String> samplesToInclude = new ArrayList<String>();
        for (int sampleNr = 0; sampleNr < genotypeSamples.size(); ++sampleNr) {
            String traitSample = this.genotypeToTraitCoupling.get(((Sample)genotypeSamples.get(sampleNr)).getId());
            Integer traitSampleId = (Integer)this.traitData.hashCols.get(traitSample);
            if (excludeSampleBecauseOfLowVariance[traitSampleId]) continue;
            samplesToInclude.add(traitSample);
        }
        if (samplesToInclude.isEmpty()) {
            throw new IllegalStateException("After removing samples with low trait variance, no samples remain.");
        }
        int[] sampleIndexes = new int[samplesToInclude.size()];
        for (int sampleNr = 0; sampleNr < samplesToInclude.size(); ++sampleNr) {
            int index;
            sampleIndexes[sampleNr] = index = ((Integer)this.traitData.hashCols.get(samplesToInclude.get(sampleNr))).intValue();
        }
        boolean[] includeTrait = new boolean[this.traitData.nrRows];
        int nrTraitsToInclude = 0;
        for (int row = 0; row < this.traitData.nrRows; ++row) {
            double sum = 0.0;
            int ctr = 0;
            for (int col = 0; col < this.traitData.nrCols; ++col) {
                if (excludeSampleBecauseOfLowVariance[col]) continue;
                sum += this.traitData.rawData[row][col];
                ++ctr;
            }
            double mean = sum / (double)ctr;
            double var = 0.0;
            ctr = 0;
            for (int col = 0; col < this.traitData.nrCols; ++col) {
                if (excludeSampleBecauseOfLowVariance[col]) continue;
                var += (this.traitData.rawData[row][col] - mean) * (this.traitData.rawData[row][col] - mean);
                ++ctr;
            }
            if ((var /= (double)(ctr - 1)) < 1.0E-200 || Double.isNaN(var)) {
                LOG.warn((Object)("WARNING: trait\t" + (String)this.traitData.rowObjects.get(row) + "\twill be excluded because variance " + var + " < 1E-200"));
                includeTrait[row] = false;
                continue;
            }
            ++nrTraitsToInclude;
            includeTrait[row] = true;
        }
        if (nrTraitsToInclude == 0) {
            throw new IllegalStateException("After removing traits with low variance, no traits remain.");
        }
        double[][] newTraitMatrix = new double[nrTraitsToInclude][samplesToInclude.size()];
        int traitCtr = 0;
        ArrayList newTraitIds = new ArrayList();
        for (int row = 0; row < traitDataMatrix.length; ++row) {
            if (!includeTrait[row]) continue;
            for (int col = 0; col < sampleIndexes.length; ++col) {
                newTraitMatrix[traitCtr][col] = traitDataMatrix[row][sampleIndexes[col]];
            }
            newTraitIds.add(this.traitData.rowObjects.get(row));
            ++traitCtr;
        }
        this.traitData.setRawData(newTraitMatrix);
        this.traitData.rowObjects = newTraitIds;
        this.traitData.colObjects = samplesToInclude;
        this.traitData.recalculateHashMaps();
    }

    public HashMap<String, String> getSampleLinks() {
        return this.genotypeToTraitCoupling;
    }

    public int[] getGenotypeToTraitCouplingInt() {
        if (this.intGenotypeToTraitCoupling == null) {
            List genotypeSamples = this.genotypeData.getSamples();
            this.intGenotypeToTraitCoupling = new int[genotypeSamples.size()];
            for (int i = 0; i < genotypeSamples.size(); ++i) {
                String traitSample = this.genotypeToTraitCoupling.get(((Sample)genotypeSamples.get(i)).getId());
                this.intGenotypeToTraitCoupling[i] = traitSample == null ? -1 : (Integer)this.traitData.hashCols.get(traitSample);
            }
        }
        return this.intGenotypeToTraitCoupling;
    }

    public void close() throws IOException {
        this.genotypeData.close();
    }

    public void rankTraitData(boolean rankWithTies) {
        LOG.info((Object)"Ranking trait data");
        RankArray r = new RankArray();
        for (int p = 0; p < this.traitData.nrRows; ++p) {
            double[] probeData = this.traitData.rawData[p];
            if (this.traitVarianceAndMeanData.rawData[0][p] == 0.0) {
                LOG.info((Object)("Trait that has no variance in expression:\t" + (String)this.traitData.rowObjects.get(p)));
                continue;
            }
            if (Double.isNaN(this.traitVarianceAndMeanData.rawData[0][p]) || Double.isNaN(this.traitVarianceAndMeanData.rawData[1][p])) {
                throw new IllegalStateException("Error ranking trait data: mean or variance is NaN!:\t" + p + "\t" + (String)this.traitData.rowObjects.get(p) + "\tMean: " + this.traitVarianceAndMeanData.rawData[0][p] + "\tVariance: " + this.traitVarianceAndMeanData.rawData[1][p]);
            }
            probeData = r.rank(probeData, rankWithTies);
            this.traitData.rawData[p] = probeData;
            this.subtractMean();
            this.determineProbeMeanAndVariance();
        }
    }

    private void determineProbeMeanAndVariance() {
        LOG.info((Object)("Determining trait mean and variance for " + this.traitData.nrRows + " traits"));
        this.traitVarianceAndMeanData = new DoubleMatrixDataset();
        this.traitVarianceAndMeanData.rawData = new double[2][this.traitData.nrRows];
        for (int i = 0; i < this.traitData.nrRows; ++i) {
            double mean;
            this.traitVarianceAndMeanData.rawData[0][i] = mean = Descriptives.mean(this.traitData.rawData[i]);
            this.traitVarianceAndMeanData.rawData[1][i] = Descriptives.variance(this.traitData.rawData[i], mean);
            if (!((String)this.traitData.rowObjects.get(i)).equals("4010021")) continue;
            System.out.println("MEAN: " + mean);
            System.out.println("VARIANCE: " + this.traitVarianceAndMeanData.rawData[1][i]);
        }
    }

    public String[] getTraits() {
        return this.traitData.rowObjects.toArray(new String[0]);
    }

    public Integer getTraitId(String probeName) {
        return (Integer)this.traitData.hashRows.get(probeName);
    }

    public RandomAccessGenotypeData getGenotypeData() {
        return this.genotypeData;
    }

    private void pruneGenotypeSamples(RandomAccessGenotypeData tmpGenoData) {
        List samples = tmpGenoData.getSamples();
        for (Sample sample : samples) {
            String sampleId = sample.getId();
            Boolean includeSample = false;
            if (this.genotypeToTraitCoupling.containsKey(sampleId)) {
                includeSample = true;
            }
            sample.putAnnotationValues("sampleInclude", (Object)includeSample);
        }
    }

    public synchronized float[] getSampleDosages(GeneticVariant variant) {
        return variant.getSampleDosages();
    }

    public double[] getTraitData(Integer traitId) {
        if (traitId == null || traitId < 0) {
            throw new IllegalArgumentException("Trait id is null or < 0. " + traitId);
        }
        return this.traitData.get(traitId);
    }

    public double getTraitMean(Integer traitId) {
        if (traitId == null || traitId < 0) {
            throw new IllegalArgumentException("Trait id is null or < 0. " + traitId);
        }
        return this.traitVarianceAndMeanData.get(0, traitId);
    }

    public double getTraitVariance(Integer traitId) {
        if (traitId == null || traitId < 0) {
            throw new IllegalArgumentException("Trait id is null or < 0. " + traitId);
        }
        return this.traitVarianceAndMeanData.get(1, traitId);
    }

    private void subtractMean() {
        for (int row = 0; row < this.traitData.nrRows; ++row) {
            double mean = Descriptives.mean(this.traitData.rawData[row]);
            int col = 0;
            while (col < this.traitData.nrCols) {
                double[] dArray = this.traitData.rawData[row];
                int n = col++;
                dArray[n] = dArray[n] - mean;
            }
        }
    }
}

