/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import JSci.maths.ArrayMath;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Dataset;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTrait;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Settings;
import eqtlmappingpipeline.metaqtl4.MetaQTL4TraitAnnotation;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.math.stats.Correlation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.ZScores;
import umcg.genetica.util.Primitives;

public class MetaQTL4CorrelationTask
implements Callable<Pair<int[], int[]>> {
    private final int distributionSize;
    private final long[] randomizationSeeds;
    private final ArrayList<MetaQTL4MetaTrait> availableTraits;
    private final TObjectIntHashMap<MetaQTL4MetaTrait> availableTraitsHash;
    private final MetaQTL4Dataset[] datasets;
    private final GeneticVariant[][] geneticVariantIndex;
    private final MetaQTL4Settings m_settings;
    private final MetaQTL4TraitAnnotation traitAnnotation;
    private final Integer[][] traitIndex;
    private final Set<MetaQTL4MetaTrait> traitsToInclude;
    private final Set<String> variantsToInclude;
    private final int threadIndex;
    private final int[] realDistribution;
    private final int[] permutedDistribution;

    MetaQTL4CorrelationTask(int nrThreads, int distributionSize, long[] randomizationSeeds, ArrayList<MetaQTL4MetaTrait> availableTraits, TObjectIntHashMap<MetaQTL4MetaTrait> availableTraitsHash, MetaQTL4Dataset[] datasets, GeneticVariant[][] geneticVariantIndex, MetaQTL4Settings m_settings, MetaQTL4TraitAnnotation traitAnnotation, Integer[][] traitIndex, Set<MetaQTL4MetaTrait> traitsToInclude, Set<String> variantsToInclude, int threadIndex) {
        this.distributionSize = distributionSize;
        this.randomizationSeeds = randomizationSeeds;
        this.availableTraits = availableTraits;
        this.availableTraitsHash = availableTraitsHash;
        this.datasets = datasets;
        this.geneticVariantIndex = geneticVariantIndex;
        this.m_settings = m_settings;
        this.traitAnnotation = traitAnnotation;
        this.traitIndex = traitIndex;
        this.traitsToInclude = traitsToInclude;
        this.variantsToInclude = variantsToInclude;
        this.threadIndex = threadIndex;
        this.realDistribution = new int[distributionSize];
        this.permutedDistribution = new int[distributionSize];
    }

    private int test(int[] sampleSizes, double[][] genotypes, double[] genotypeVariances, Integer traitId, boolean[][] includeTraitSample) {
        int nrDatasets = this.datasets.length;
        double[] zscores = new double[nrDatasets];
        for (int datasetId = 0; datasetId < nrDatasets; ++datasetId) {
            if (genotypes[datasetId] == null) {
                zscores[datasetId] = Double.NaN;
                continue;
            }
            double[] x = genotypes[datasetId];
            if (x == null) {
                System.err.println("ERROR: genotype is null");
                zscores[datasetId] = Double.NaN;
                continue;
            }
            double varianceX = genotypeVariances[datasetId];
            boolean[] includeDatasetTraitSample = includeTraitSample[datasetId];
            Integer datasetTraitId = this.traitIndex[datasetId][traitId];
            double[] y = this.datasets[datasetId].getTraitData(datasetTraitId);
            double[] newY = new double[x.length];
            int itr = 0;
            double sum = 0.0;
            for (int s = 0; s < y.length; ++s) {
                newY[itr] = y[s];
                sum += newY[itr];
                ++itr;
            }
            y = newY;
            double meanY = sum / (double)itr;
            double varsum = 0.0;
            for (int i = 0; i < y.length; ++i) {
                int n = i;
                y[n] = y[n] - meanY;
                varsum += y[i] * y[i];
            }
            double varianceY = varsum / (double)(y.length - 1);
            double varianceYOrig = this.datasets[datasetId].getTraitVariance(traitId);
            if (varianceY == 0.0) {
                zscores[datasetId] = Double.NaN;
                continue;
            }
            double correlation = Correlation.correlateMeanCenteredData(x, y, varianceX, varianceY);
            double correlation2 = ArrayMath.correlation((double[])x, (double[])y);
            System.out.println(correlation + "\t" + correlation2 + "\t" + x.length + "\t" + varianceX + "\t" + varianceYOrig + "\t" + varianceY + "\t" + Descriptives.variance(x) + "\t" + Descriptives.variance(y));
            if (correlation >= -1.0 && correlation <= 1.0) {
                zscores[datasetId] = Correlation.convertCorrelationToZScore(x.length, correlation);
                continue;
            }
            System.err.println("Error! correlation invalid: " + correlation);
            System.exit(-1);
        }
        double metaZ = ZScores.getWeightedZ(zscores, sampleSizes);
        double p = ZScores.zToP(metaZ);
        int bin = (int)Math.round(p * (double)this.distributionSize);
        if (bin == this.distributionSize) {
            --bin;
        }
        return bin;
    }

    private Pair<double[], Double> correctGenotypesForMissingValuesAndNormalize(int[] coupledTraitInt, GeneticVariant variant, float[] genotypesTMP, boolean[] includeTraitSample) {
        double[] snpmeancorrectedgenotypes;
        int xLen = genotypesTMP.length;
        int nrMissing = 0;
        if (variant.getCallRate() < 1.0) {
            double sum = 0.0;
            for (int i = 0; i < xLen; ++i) {
                if (genotypesTMP[i] < 0.0f) {
                    ++nrMissing;
                    int coupledTrait = coupledTraitInt[i];
                    includeTraitSample[coupledTrait] = false;
                    continue;
                }
                sum += (double)genotypesTMP[i];
            }
            int newXLen = xLen - nrMissing;
            double meanX = sum / (double)newXLen;
            snpmeancorrectedgenotypes = new double[newXLen];
            int itr = 0;
            for (int i = 0; i < newXLen; ++i) {
                if (!(genotypesTMP[i] >= 0.0f)) continue;
                snpmeancorrectedgenotypes[itr] = (double)genotypesTMP[i] - meanX;
                ++itr;
            }
        } else {
            double sum = 0.0;
            snpmeancorrectedgenotypes = new double[xLen];
            for (int i = 0; i < xLen; ++i) {
                double genotype = genotypesTMP[i];
                sum += genotype;
                snpmeancorrectedgenotypes[i] = genotype;
            }
        }
        double varianceX = ArrayMath.variance((double[])snpmeancorrectedgenotypes);
        return new Pair<double[], Double>(snpmeancorrectedgenotypes, varianceX);
    }

    private double[] permuteGenotypes(double[] genotypes, Random rand) {
        ArrayList<Double> availableGenotypes = new ArrayList<Double>();
        for (int i = 0; i < genotypes.length; ++i) {
            availableGenotypes.add(genotypes[i]);
        }
        Collections.shuffle(availableGenotypes, rand);
        return Primitives.toPrimitiveArr(availableGenotypes.toArray(new Double[0]));
    }

    @Override
    public Pair<int[], int[]> call() throws Exception {
        try {
            int nrPermutations = this.randomizationSeeds.length;
            int nrDatasets = this.geneticVariantIndex.length;
            int nrVariants = this.geneticVariantIndex[nrDatasets - 1].length;
            ArrayList<Integer> traitsToTest = null;
            boolean[] flipEffects = new boolean[nrDatasets];
            boolean numberOfDatasetsPassingQC = false;
            double mafthreshold = this.m_settings.getSnpQCMAFThreshold();
            double hwepthreshold = this.m_settings.getSnpQCHWEThreshold();
            double callratethreshold = this.m_settings.getSnpQCHWEThreshold();
            int[] maxNrSamplesPerDataset = new int[this.datasets.length];
            boolean[][] includeTraitSample = new boolean[nrDatasets][0];
            for (int d = 0; d < maxNrSamplesPerDataset.length; ++d) {
                int nrSamples;
                maxNrSamplesPerDataset[d] = nrSamples = this.datasets[d].getGenotypeToTraitCouplingInt().length;
                includeTraitSample[d] = new boolean[nrSamples];
            }
            ProgressBar pb = new ProgressBar(nrVariants, "Running calculations...");
            for (int variantId = 0; variantId < nrVariants; variantId += this.threadIndex) {
                pb.iterate();
                double[][] genotypes = new double[nrDatasets][0];
                double[] genotypeVariances = new double[nrDatasets];
                int[] sampleSizes = new int[nrDatasets];
                int startPosition = -1;
                String sequence = null;
                numberOfDatasetsPassingQC = false;
                for (int datasetId = 0; datasetId < nrDatasets; ++datasetId) {
                    GeneticVariant variant = this.geneticVariantIndex[datasetId][variantId];
                    MetaQTL4Dataset dataset = this.datasets[datasetId];
                    int[] gte = dataset.getGenotypeToTraitCouplingInt();
                    if (variant != null) {
                        float[] genotypesTMP = dataset.getSampleDosages(variant);
                        double maf = variant.getMinorAlleleFrequency();
                        double hwep = variant.getHwePvalue();
                        double callrate = variant.getCallRate();
                        if (maf > mafthreshold && hwep > hwepthreshold && callrate > callratethreshold) {
                            Pair<double[], Double> genotypedata = this.correctGenotypesForMissingValuesAndNormalize(gte, variant, genotypesTMP, includeTraitSample[datasetId]);
                            genotypes[datasetId] = genotypedata.getLeft();
                            genotypeVariances[datasetId] = genotypedata.getRight();
                            sampleSizes[datasetId] = genotypes[datasetId].length;
                            if (sequence != null) continue;
                            startPosition = variant.getStartPos();
                            sequence = variant.getSequenceName();
                            continue;
                        }
                        genotypes[datasetId] = null;
                        continue;
                    }
                    genotypes[datasetId] = null;
                }
                if (this.m_settings.isCisAnalysis() ^ this.m_settings.isTransAnalysis() && traitsToTest == null) {
                    traitsToTest = new ArrayList<Integer>();
                    for (int i = 0; i < this.availableTraits.size(); ++i) {
                        MetaQTL4MetaTrait trait = this.availableTraits.get(i);
                        boolean sameChr = trait.getChr().equals(sequence);
                        if (sameChr) {
                            int distance = Math.abs(trait.getChrMidpoint() - startPosition);
                            if (this.m_settings.isCisAnalysis() && distance < this.m_settings.getCiseQTLAnalysMaxSNPProbeMidPointDistance()) {
                                traitsToTest.add(i);
                            }
                            if (this.m_settings.isTransAnalysis() && distance > this.m_settings.getCiseQTLAnalysMaxSNPProbeMidPointDistance()) {
                                traitsToTest.add(i);
                            }
                        }
                        if (sameChr || !this.m_settings.isTransAnalysis()) continue;
                        traitsToTest.add(i);
                    }
                }
                if (traitsToTest != null && traitsToTest.isEmpty()) continue;
                for (int permutation = -1; permutation < nrPermutations; ++permutation) {
                    int[] dist;
                    if (permutation >= 0) {
                        dist = this.permutedDistribution;
                        long seed = this.randomizationSeeds[permutation];
                        Random rand = new Random(seed);
                        for (int d = 0; d < this.datasets.length; ++d) {
                            if (genotypes[d] == null) continue;
                            genotypes[d] = this.permuteGenotypes(genotypes[d], rand);
                        }
                    } else {
                        dist = this.realDistribution;
                    }
                    if (traitsToTest == null) {
                        for (int trait = 0; trait < this.availableTraits.size(); ++trait) {
                            int bin;
                            int n = bin = this.test(sampleSizes, genotypes, genotypeVariances, trait, includeTraitSample);
                            dist[n] = dist[n] + 1;
                        }
                        continue;
                    }
                    for (Integer trait : traitsToTest) {
                        int bin;
                        int n = bin = this.test(sampleSizes, genotypes, genotypeVariances, trait, includeTraitSample);
                        dist[n] = dist[n] + 1;
                    }
                }
            }
            pb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Pair<int[], int[]>(this.realDistribution, this.permutedDistribution);
    }
}

