/*
 * Decompiled with CFR 0.152.
 */
package eqtlmappingpipeline.metaqtl4;

import eqtlmappingpipeline.metaqtl4.MetaQTL4Dataset;
import eqtlmappingpipeline.metaqtl4.MetaQTL4ExecutionTask;
import eqtlmappingpipeline.metaqtl4.MetaQTL4MetaTrait;
import eqtlmappingpipeline.metaqtl4.MetaQTL4Settings;
import eqtlmappingpipeline.metaqtl4.MetaQTL4TraitAnnotation;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.math.stats.Correlation;

public class MetaQTL4 {
    private Set<MetaQTL4MetaTrait> traitsToInclude = null;
    private Set<String> variantsToInclude = null;
    private Set<Pair<String, MetaQTL4MetaTrait>> genotypeTraitCombinations = null;
    private final MetaQTL4Settings m_settings;
    private MetaQTL4TraitAnnotation traitAnnotation;
    private MetaQTL4Dataset[] datasets;
    private Integer[][] traitIndex;
    private ArrayList<MetaQTL4MetaTrait> availableTraits;
    private TObjectIntHashMap<MetaQTL4MetaTrait> availableTraitsHash;
    private GeneticVariant[][] geneticVariantIndex;
    private static final Logger LOG = Logger.getLogger(MetaQTL4.class);

    public MetaQTL4(MetaQTL4Settings settings) throws IOException, Exception {
        LOG.info((Object)"WARNING: MetaQTL4 is experimental code!");
        this.m_settings = settings;
        this.initialize();
        this.run();
    }

    public MetaQTL4(String settings, String replaceText, String testToReplaceWith) throws IOException, Exception {
        LOG.warn((Object)"WARNING: MetaQTL4 is experimental code!");
        this.m_settings = new MetaQTL4Settings(settings, replaceText, testToReplaceWith);
        this.initialize();
        this.run();
    }

    public final void initialize() throws IOException {
        int d;
        HashSet<String> platforms = new HashSet<String>();
        for (d = 0; d < this.m_settings.getNrDatasets(); ++d) {
            platforms.add(this.m_settings.getDatasetSettings().get(d).getTraitPlatform());
        }
        this.traitAnnotation = new MetaQTL4TraitAnnotation(this.m_settings.getProbeAnnotationFile(), platforms);
        if (this.m_settings.getConfineProbeFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getConfineProbeFile())) {
                throw new IOException("Failed to read file with probes to include: " + this.m_settings.getConfineProbeFile().getAbsolutePath());
            }
            this.traitsToInclude = this.loadMetaTraitList(this.m_settings.getConfineProbeFile());
        }
        if (this.m_settings.getConfineSNPFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getConfineSNPFile())) {
                throw new IOException("Failed to read file with SNPs to include: " + this.m_settings.getConfineSNPFile().getAbsolutePath());
            }
            TextFile tf = new TextFile(this.m_settings.getConfineSNPFile(), false);
            this.variantsToInclude = tf.readAsSet(0, TextFile.tab);
            tf.close();
        }
        if (this.m_settings.getSNPProbeConfineFile() != null) {
            if (!Gpio.existsAndReadable(this.m_settings.getSNPProbeConfineFile())) {
                throw new IOException("Failed to read file with SNP Probe combinations to include: " + this.m_settings.getSNPProbeConfineFile().getAbsolutePath());
            }
            Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>> combinations = this.loadgenotypeMarkerCombinations(this.m_settings.getSNPProbeConfineFile());
            this.variantsToInclude = combinations.getLeft();
            this.traitsToInclude = combinations.getMiddle();
            this.genotypeTraitCombinations = combinations.getRight();
        }
        LOG.info((Object)"Running probe filter");
        this.runProbeFilter();
        this.datasets = new MetaQTL4Dataset[this.m_settings.getNrDatasets()];
        if (this.datasets.length == 0) {
            throw new IllegalStateException("Error: no dataset information provided.");
        }
        for (d = 0; d < this.datasets.length; ++d) {
            HashSet<String> platformSpecificProbesToInclude = null;
            if (this.traitsToInclude != null) {
                String platform = this.m_settings.getDatasetSettings().get(d).getTraitPlatform();
                Integer platformId = this.traitAnnotation.getPlatformId(platform);
                platformSpecificProbesToInclude = new HashSet<String>();
                for (MetaQTL4MetaTrait metaprobe : this.traitsToInclude) {
                    String platformProbe = metaprobe.getPlatformIds()[platformId];
                    if (platformProbe == null) continue;
                    platformSpecificProbesToInclude.add(platformProbe);
                }
            }
            this.datasets[d] = new MetaQTL4Dataset(this.m_settings.getDatasetSettings().get(d), platformSpecificProbesToInclude);
            if (!this.m_settings.isPerformParametricAnalysis()) continue;
            this.datasets[d].rankTraitData(this.m_settings.isEqualRankForTies());
        }
        LOG.info((Object)"Creating trait index");
        this.createTraitIndex();
        LOG.info((Object)"Create SNP index");
        this.createSNPIndex();
        int nrSamples = 0;
        for (MetaQTL4Dataset dataset : this.datasets) {
            nrSamples += dataset.getGenotypeToTraitCouplingInt().length;
        }
        LOG.info((Object)("Meta-analysis will have " + nrSamples + " samples"));
        Correlation.correlationToZScore(nrSamples);
    }

    public final void run() {
        LOG.info((Object)"Running software!");
        int nrPermutations = this.m_settings.getNrPermutationsFDR();
        long[] randomizationSeeds = new long[nrPermutations];
        Random rand = new Random();
        for (int permutation = 0; permutation < nrPermutations; ++permutation) {
            randomizationSeeds[permutation] = rand.nextLong();
        }
        ExecutorService resultPool = Executors.newFixedThreadPool(1);
        ExecutorCompletionService resultPoolService = new ExecutorCompletionService(resultPool);
        int bufferSize = 100;
        int nrThreads = this.m_settings.getNrThreads();
        ExecutorService threadPool = Executors.newFixedThreadPool(nrThreads);
        ExecutorCompletionService<Boolean> pool = new ExecutorCompletionService<Boolean>(threadPool);
        int start = 0;
        int stop = this.geneticVariantIndex.length;
        MetaQTL4ExecutionTask task = new MetaQTL4ExecutionTask(nrThreads, randomizationSeeds, this.availableTraits, this.availableTraitsHash, this.datasets, this.geneticVariantIndex, this.m_settings, this.traitAnnotation, this.traitIndex, this.traitsToInclude, this.variantsToInclude, start, stop, bufferSize, resultPoolService);
        pool.submit(task);
        int returned = 0;
        while (returned < nrThreads) {
            try {
                Boolean result = (Boolean)pool.take().get();
                if (result == null || !result.booleanValue()) continue;
                ++returned;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        threadPool.shutdown();
    }

    private Set<MetaQTL4MetaTrait> loadMetaTraitList(File location) throws IOException {
        TextFile tf = new TextFile(location, false);
        Set<String> list = tf.readAsSet(0, TextFile.tab);
        HashSet<MetaQTL4MetaTrait> traits = new HashSet<MetaQTL4MetaTrait>();
        for (String s : list) {
            MetaQTL4MetaTrait t = this.traitAnnotation.getMetaTraitNameToObj().get(s);
            if (t == null) continue;
            traits.add(t);
        }
        tf.close();
        return traits;
    }

    private Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>> loadgenotypeMarkerCombinations(File file) throws IOException {
        HashSet<Pair<String, MetaQTL4MetaTrait>> pairs = new HashSet<Pair<String, MetaQTL4MetaTrait>>();
        HashSet<String> snps = new HashSet<String>();
        HashSet<MetaQTL4MetaTrait> probes = new HashSet<MetaQTL4MetaTrait>();
        TextFile tf = new TextFile(file, false);
        String[] elems = tf.readLineElems(TextFile.tab);
        while (elems != null) {
            String snp = elems[0];
            String probe = elems[1];
            MetaQTL4MetaTrait t = this.traitAnnotation.getMetaTraitNameToObj().get(probe);
            if (t != null) {
                Pair<String, MetaQTL4MetaTrait> p = new Pair<String, MetaQTL4MetaTrait>(snp, t);
                pairs.add(p);
                snps.add(snp);
                probes.add(t);
            }
            elems = tf.readLineElems(TextFile.tab);
        }
        tf.close();
        return new Triple<HashSet<String>, HashSet<MetaQTL4MetaTrait>, HashSet<Pair<String, MetaQTL4MetaTrait>>>(snps, probes, pairs);
    }

    private void runProbeFilter() {
        if (this.m_settings.getConfineToProbesThatMapToChromosome() != null) {
            HashSet<MetaQTL4MetaTrait> finalTraitList = new HashSet<MetaQTL4MetaTrait>();
            if (this.traitsToInclude != null) {
                for (MetaQTL4MetaTrait metaprobe : this.traitsToInclude) {
                    String chrToInclude;
                    String chr = metaprobe.getChr();
                    if (!chr.equals(chrToInclude = "" + this.m_settings.getConfineToProbesThatMapToChromosome()) || this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() && (!this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() || !MetaQTL4MetaTrait.mapsToChromosome())) continue;
                    finalTraitList.add(metaprobe);
                }
            } else {
                MetaQTL4MetaTrait[] metaProbes;
                for (MetaQTL4MetaTrait metaprobe : metaProbes = this.traitAnnotation.getMetatraits().toArray(new MetaQTL4MetaTrait[0])) {
                    String chrToInclude;
                    String chr = metaprobe.getChr();
                    if (!chr.equals(chrToInclude = "" + this.m_settings.getConfineToProbesThatMapToChromosome()) || this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() && (!this.m_settings.isExpressionDataLoadOnlyProbesThatMapToChromosome() || !MetaQTL4MetaTrait.mapsToChromosome())) continue;
                    finalTraitList.add(metaprobe);
                }
            }
            this.traitsToInclude = finalTraitList;
            if (this.genotypeTraitCombinations != null) {
                HashSet<Pair<String, MetaQTL4MetaTrait>> finalgenotypetraitpairs = new HashSet<Pair<String, MetaQTL4MetaTrait>>();
                for (Pair<String, MetaQTL4MetaTrait> p : this.genotypeTraitCombinations) {
                    MetaQTL4MetaTrait probe = p.getRight();
                    if (!this.traitsToInclude.contains(probe)) continue;
                    finalgenotypetraitpairs.add(p);
                }
                this.genotypeTraitCombinations = finalgenotypetraitpairs;
            }
        }
        if (this.traitsToInclude != null && this.traitsToInclude.isEmpty()) {
            throw new IllegalStateException("No traits remain after filtering.");
        }
        if (this.genotypeTraitCombinations != null && this.genotypeTraitCombinations.isEmpty()) {
            throw new IllegalStateException("No snp-trait combinations remain after filtering.");
        }
    }

    private void createTraitIndex() {
        HashSet<MetaQTL4MetaTrait> tmpAvailableTraits = new HashSet<MetaQTL4MetaTrait>();
        for (int d = 0; d < this.datasets.length; ++d) {
            String platform = this.m_settings.getDatasetSettings().get(d).getTraitPlatform();
            Integer platformId = this.traitAnnotation.getPlatformId(platform);
            String[] availableTraitsInDataset = this.datasets[d].getTraits();
            LOG.info((Object)(this.m_settings.getDatasetSettings().get(d).getName() + " has " + availableTraitsInDataset.length + " traits on platform " + platform + " (" + platformId + ")"));
            for (String trait : availableTraitsInDataset) {
                MetaQTL4MetaTrait metatrait = this.traitAnnotation.getTraitForPlatformId(platformId, trait);
                if (metatrait == null) continue;
                String chr = metatrait.getChr();
                if (this.m_settings.isCisAnalysis() && this.m_settings.isTransAnalysis()) {
                    tmpAvailableTraits.add(metatrait);
                    continue;
                }
                byte chrByte = ChrAnnotation.parseChr(chr);
                if (!chr.equals("X") && (chrByte >= 23 || chrByte <= 0)) continue;
                tmpAvailableTraits.add(metatrait);
            }
        }
        this.availableTraits = new ArrayList(tmpAvailableTraits);
        this.availableTraitsHash = new TObjectIntHashMap();
        this.traitIndex = new Integer[this.datasets.length][this.availableTraits.size()];
        for (int ds = 0; ds < this.datasets.length; ++ds) {
            Integer platformId = this.traitAnnotation.getPlatformId(this.m_settings.getDatasetSettings().get(ds).getTraitPlatform());
            for (int i = 0; i < this.availableTraits.size(); ++i) {
                MetaQTL4MetaTrait trait = this.availableTraits.get(i);
                this.availableTraitsHash.put((Object)trait, i);
                String probeName = trait.getPlatformIds()[platformId];
                if (probeName == null) continue;
                this.traitIndex[ds][i] = this.datasets[ds].getTraitId(probeName);
            }
        }
        LOG.info((Object)(this.availableTraits.size() + " traits available to test."));
    }

    private void createSNPIndex() {
        RandomAccessGenotypeData data;
        Integer ctr;
        if (this.traitIndex == null) {
            this.createTraitIndex();
        }
        LOG.info((Object)"Indexing SNPs");
        int distance = this.m_settings.getCiseQTLAnalysMaxSNPProbeMidPointDistance();
        Set<Object> uniquePositions = new HashSet();
        if (this.m_settings.isCisAnalysis() && !this.m_settings.isTransAnalysis()) {
            LOG.info((Object)("Performing cis-eQTL analysis, so keeping only SNPs within " + this.m_settings.getCiseQTLAnalysMaxSNPProbeMidPointDistance()));
            LOG.info((Object)"");
            int tctr = 0;
            HashMap<Pair<String, Integer>, Integer> allPositions = new HashMap<Pair<String, Integer>, Integer>();
            for (int d = 0; d < this.datasets.length; ++d) {
                RandomAccessGenotypeData data2 = this.datasets[d].getGenotypeData();
                ProgressBar pb = new ProgressBar(this.availableTraits.size(), "Dataset " + d);
                for (MetaQTL4MetaTrait metaQTL4MetaTrait : this.availableTraits) {
                    String chr = metaQTL4MetaTrait.getChr();
                    int midpoint = metaQTL4MetaTrait.getChrMidpoint();
                    Iterable variants = data2.getVariantsByRange(chr, midpoint - distance, midpoint + distance);
                    for (GeneticVariant variant : variants) {
                        String primaryId = variant.getPrimaryVariantId();
                        if (this.variantsToInclude != null && !this.variantsToInclude.contains(primaryId)) continue;
                        Pair<String, Integer> position = new Pair<String, Integer>(variant.getSequenceName(), variant.getStartPos());
                        Integer ctr2 = (Integer)allPositions.get(position);
                        if (ctr2 == null) {
                            ctr2 = 1;
                        } else {
                            Integer n = ctr2;
                            Integer n2 = ctr2 = Integer.valueOf(ctr2 + 1);
                        }
                        allPositions.put(position, ctr2);
                    }
                    pb.iterate();
                    ++tctr;
                }
                pb.close();
            }
            LOG.info((Object)(allPositions.size() + " variants amongst all datasets."));
            if (this.m_settings.getConfineSNPsToSNPsPresentInAllDatasets() != null && this.m_settings.getConfineSNPsToSNPsPresentInAllDatasets().booleanValue()) {
                HashSet<Pair> tmpPositions = new HashSet<Pair>();
                for (Pair pair : allPositions.keySet()) {
                    ctr = (Integer)allPositions.get(pair);
                    if (ctr != this.datasets.length) continue;
                    tmpPositions.add(pair);
                }
                uniquePositions = tmpPositions;
            } else {
                uniquePositions = allPositions.keySet();
            }
            allPositions = null;
        } else {
            for (int i = 0; i < 23; ++i) {
                String chr = "" + i;
                if (i == 23) {
                    chr = "X";
                }
                HashMap<Integer, Integer> allPositions = new HashMap<Integer, Integer>();
                for (int d = 0; d < this.datasets.length; ++d) {
                    data = this.datasets[d].getGenotypeData();
                    Iterable variants = data.getSequenceGeneticVariants(chr);
                    for (GeneticVariant variant : variants) {
                        Integer position;
                        String variantSequence;
                        String primaryId = variant.getPrimaryVariantId();
                        if (this.variantsToInclude != null && !this.variantsToInclude.contains(primaryId) || !(variantSequence = variant.getSequenceName()).equals(chr) || (position = Integer.valueOf(variant.getStartPos())) <= 0) continue;
                        Integer ctr3 = (Integer)allPositions.get(position);
                        if (ctr3 == null) {
                            ctr3 = 1;
                        } else {
                            Integer n = ctr3;
                            Integer n3 = ctr3 = Integer.valueOf(ctr3 + 1);
                        }
                        allPositions.put(position, ctr3);
                    }
                }
                for (Integer position : allPositions.keySet()) {
                    ctr = (Integer)allPositions.get(position);
                    if ((this.m_settings.getConfineSNPsToSNPsPresentInAllDatasets() == null || !this.m_settings.getConfineSNPsToSNPsPresentInAllDatasets().booleanValue() || ctr != this.datasets.length) && this.m_settings.getConfineSNPsToSNPsPresentInAllDatasets().booleanValue()) continue;
                    uniquePositions.add(new Pair<String, Integer>(chr, position));
                }
            }
        }
        int numberFinalPositions = uniquePositions.size();
        if (numberFinalPositions == 0) {
            System.err.println("Error: no SNPs found to test");
        }
        LOG.info((Object)"Creating final index");
        this.geneticVariantIndex = new GeneticVariant[this.datasets.length][numberFinalPositions];
        ProgressBar pb2 = new ProgressBar(this.datasets.length * numberFinalPositions);
        for (int dataset = 0; dataset < this.datasets.length; ++dataset) {
            int ctr4 = 0;
            data = this.datasets[dataset].getGenotypeData();
            for (Pair pair : uniquePositions) {
                this.geneticVariantIndex[dataset][ctr4] = data.getSnpVariantByPos((String)pair.getLeft(), ((Integer)pair.getRight()).intValue());
                ++ctr4;
                pb2.iterate();
            }
        }
        pb2.close();
        LOG.info((Object)"Done");
    }
}

